/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.index.PrebuiltIndexProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.CompositeBinaryBuilderMap;
import com.intellij.psi.stubs.IndexingStampInfo;
import com.intellij.psi.stubs.PrebuiltStubsKt;
import com.intellij.psi.stubs.PrebuiltStubsProvider;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializedStubTreeDataExternalizer;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubBuilderType;
import com.intellij.psi.stubs.StubForwardIndexExternalizer;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexEx;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubUpdatingForwardIndexAccessor;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.BitUtil;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexDataComparer;
import com.intellij.util.indexing.IndexDataPresenter;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.SingleEntryCompositeIndexer;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.forward.AbstractMapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.EmptyForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.IntMapForwardIndex;
import com.intellij.util.indexing.impl.storage.TransientChangesIndexStorage;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.snapshot.SnapshotInputMappings;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StubUpdatingIndex
extends SingleEntryFileBasedIndexExtension<SerializedStubTree>
implements CustomImplementationFileBasedIndexExtension<Integer, SerializedStubTree> {
    static final Logger LOG = Logger.getInstance(StubUpdatingIndex.class);
    public static final boolean USE_SNAPSHOT_MAPPINGS = SystemProperties.is((String)"stubs.use.snapshot.mappings");
    private static final int VERSION = 45 + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 1 : 0);
    private static final FileAttribute INDEXED_STAMP = new FileAttribute("stubIndexStamp", 3, true);
    public static final ID<Integer, SerializedStubTree> INDEX_ID = ID.create((String)"Stubs");
    private static final FileBasedIndex.InputFilter INPUT_FILTER = StubUpdatingIndex::canHaveStub;
    @NotNull
    private final StubForwardIndexExternalizer<?> myStubIndexesExternalizer;
    @NotNull
    private final SerializationManagerEx mySerializationManager;
    private static final byte IS_BINARY_MASK = 1;
    private static final byte BYTE_AND_CHAR_LENGTHS_ARE_THE_SAME_MASK = 2;

    public StubUpdatingIndex() {
        this(StubForwardIndexExternalizer.getIdeUsedExternalizer(), SerializationManagerEx.getInstanceEx());
    }

    public StubUpdatingIndex(@NotNull StubForwardIndexExternalizer<?> stubIndexesExternalizer, @NotNull SerializationManagerEx serializationManager) {
        this.myStubIndexesExternalizer = stubIndexesExternalizer;
        this.mySerializationManager = serializationManager;
    }

    public boolean hasSnapshotMapping() {
        return USE_SNAPSHOT_MAPPINGS;
    }

    public static boolean canHaveStub(@NotNull VirtualFile file2) {
        BinaryFileStubBuilder builder2;
        Project project = ProjectUtil.guessProjectForFile((VirtualFile)file2);
        FileType fileType = SubstitutedFileType.substituteFileType(file2, file2.getFileType(), project);
        if (fileType instanceof LanguageFileType) {
            Language l = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l);
            if (parserDefinition == null) {
                return false;
            }
            IFileElementType elementType = parserDefinition.getFileNodeType();
            if (elementType instanceof IStubFileElementType && ((IStubFileElementType)elementType).shouldBuildStubFor(file2)) {
                return true;
            }
        }
        return (builder2 = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType)) != null && builder2.acceptsFile(file2);
    }

    @NotNull
    public ID<Integer, SerializedStubTree> getName() {
        return INDEX_ID;
    }

    @NotNull
    public SingleEntryIndexer<SerializedStubTree> getIndexer() {
        return new SingleEntryCompositeIndexer<SerializedStubTree, StubBuilderType, String>(false){

            public boolean requiresContentForSubIndexerEvaluation(@NotNull IndexedFile file2) {
                return StubTreeBuilder.requiresContentToFindBuilder(file2.getFileType());
            }

            @Nullable
            public StubBuilderType calculateSubIndexer(@NotNull IndexedFile file2) {
                return StubTreeBuilder.getStubBuilderType(file2, true);
            }

            @NotNull
            public String getSubIndexerVersion(@NotNull StubBuilderType type) {
                return type.getVersion();
            }

            @NotNull
            public KeyDescriptor<String> getSubIndexerVersionDescriptor() {
                return EnumeratorStringDescriptor.INSTANCE;
            }

            @Nullable
            protected SerializedStubTree computeValue(@NotNull FileContent inputData, @NotNull StubBuilderType type) {
                try {
                    SerializedStubTree prebuiltTree = StubUpdatingIndex.findPrebuiltSerializedStubTree(inputData);
                    if (prebuiltTree != null) {
                        prebuiltTree = prebuiltTree.reSerialize(StubUpdatingIndex.this.mySerializationManager, StubUpdatingIndex.this.myStubIndexesExternalizer);
                        if (PrebuiltIndexProvider.DEBUG_PREBUILT_INDICES) {
                            StubUpdatingIndex.this.assertPrebuiltStubTreeMatchesActualTree(prebuiltTree, inputData, type);
                        }
                        return prebuiltTree;
                    }
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Exception e) {
                    LOG.error("Error while indexing: " + inputData.getFileName() + " using prebuilt stub index", (Throwable)e);
                }
                try {
                    Stub stub = StubTreeBuilder.buildStubTree(inputData, type);
                    if (stub == null) {
                        return null;
                    }
                    SerializedStubTree serializedStubTree = SerializedStubTree.serializeStub(stub, StubUpdatingIndex.this.mySerializationManager, StubUpdatingIndex.this.myStubIndexesExternalizer);
                    if (IndexDebugProperties.DEBUG) {
                        StubUpdatingIndex.assertDeserializedStubMatchesOriginalStub(serializedStubTree, stub);
                    }
                    return serializedStubTree;
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Throwable t) {
                    LOG.error("Error indexing:" + inputData.getFile(), t);
                    return null;
                }
            }
        };
    }

    @Nullable
    static SerializedStubTree findPrebuiltSerializedStubTree(@NotNull FileContent fileContent) {
        if (!PrebuiltIndexProvider.USE_PREBUILT_INDEX) {
            return null;
        }
        PrebuiltStubsProvider prebuiltStubsProvider = (PrebuiltStubsProvider)PrebuiltStubsKt.getPrebuiltStubsProvider().forFileType(fileContent.getFileType());
        if (prebuiltStubsProvider == null) {
            return null;
        }
        return prebuiltStubsProvider.findStub(fileContent);
    }

    private static void assertDeserializedStubMatchesOriginalStub(@NotNull SerializedStubTree stubTree, @NotNull Stub originalStub) {
        Stub deserializedStub;
        try {
            deserializedStub = stubTree.getStub();
        }
        catch (SerializerNotFoundException e) {
            throw new RuntimeException("Failed to deserialize stub tree", e);
        }
        StubUpdatingIndex.assertStubsAreSimilar(originalStub, deserializedStub);
    }

    private static void assertStubsAreSimilar(@NotNull Stub stub, @NotNull Stub stub2) {
        assert (stub.getStubType() == stub2.getStubType());
        List stubs = stub.getChildrenStubs();
        List stubs2 = stub2.getChildrenStubs();
        assert (stubs.size() == stubs2.size());
        int len = stubs.size();
        for (int i2 = 0; i2 < len; ++i2) {
            StubUpdatingIndex.assertStubsAreSimilar((Stub)stubs.get(i2), (Stub)stubs2.get(i2));
        }
    }

    private void assertPrebuiltStubTreeMatchesActualTree(@NotNull SerializedStubTree prebuiltStubTree, @NotNull FileContent fileContent, @NotNull StubBuilderType type) {
        try {
            Stub stub = StubTreeBuilder.buildStubTree(fileContent, type);
            if (stub == null) {
                return;
            }
            SerializedStubTree actualTree = SerializedStubTree.serializeStub(stub, this.mySerializationManager, this.myStubIndexesExternalizer);
            if (!IndexDataComparer.INSTANCE.areStubTreesTheSame(actualTree, prebuiltStubTree)) {
                throw new RuntimeExceptionWithAttachments("Prebuilt stub tree does not match actual stub tree", new Attachment[]{new Attachment("actual-stub-tree.txt", IndexDataPresenter.INSTANCE.getPresentableSerializedStubTree(actualTree)), new Attachment("prebuilt-stub-tree.txt", IndexDataPresenter.INSTANCE.getPresentableSerializedStubTree(prebuiltStubTree))});
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void rememberIndexingStamp(@NotNull FileContent content2) {
        VirtualFile file2 = content2.getFile();
        boolean isBinary = file2.getFileType().isBinary();
        int contentLength = isBinary ? -1 : content2.getPsiFile().getTextLength();
        long byteLength = file2.getLength();
        StubUpdatingIndex.rememberIndexingStamp(file2, isBinary, byteLength, contentLength);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Indexing stubs for " + file2 + "; " + IndexingStampInfo.dumpSize(byteLength, contentLength));
        }
    }

    private static void rememberIndexingStamp(@NotNull VirtualFile file2, boolean isBinary, long contentByteLength, int contentCharLength) {
        try (DataOutputStream stream = INDEXED_STAMP.writeAttribute(file2);){
            DataInputOutputUtil.writeTIME((DataOutput)stream, (long)file2.getTimeStamp());
            DataInputOutputUtil.writeLONG((DataOutput)stream, (long)contentByteLength);
            boolean lengthsAreTheSame = contentByteLength == (long)contentCharLength;
            byte flags = 0;
            flags = BitUtil.set((byte)flags, (byte)1, (boolean)isBinary);
            flags = BitUtil.set((byte)flags, (byte)2, (boolean)lengthsAreTheSame);
            stream.writeByte(flags);
            if (!lengthsAreTheSame && !isBinary) {
                DataInputOutputUtil.writeINT((DataOutput)stream, (int)contentCharLength);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static IndexingStampInfo getIndexingStampInfo(@NotNull VirtualFile file2) {
        try (DataInputStream stream = INDEXED_STAMP.readAttribute(file2);){
            if (stream == null) {
                IndexingStampInfo indexingStampInfo2 = null;
                return indexingStampInfo2;
            }
            long stamp = DataInputOutputUtil.readTIME((DataInput)stream);
            long byteLength = DataInputOutputUtil.readLONG((DataInput)stream);
            byte flags = stream.readByte();
            boolean isBinary = BitUtil.isSet((byte)flags, (byte)1);
            boolean readOnlyOneLength = BitUtil.isSet((byte)flags, (byte)2);
            int charLength = isBinary ? -1 : (readOnlyOneLength ? (int)byteLength : DataInputOutputUtil.readINT((DataInput)stream));
            IndexingStampInfo indexingStampInfo = new IndexingStampInfo(stamp, byteLength, charLength);
            return indexingStampInfo;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    public DataExternalizer<SerializedStubTree> getValueExternalizer() {
        StubUpdatingIndex.ensureSerializationManagerInitialized(this.mySerializationManager);
        return new SerializedStubTreeDataExternalizer(true, this.mySerializationManager, this.myStubIndexesExternalizer);
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return INPUT_FILTER;
    }

    public int getVersion() {
        return VERSION;
    }

    @Override
    @NotNull
    public UpdatableIndex<Integer, SerializedStubTree, FileContent> createIndexImplementation(@NotNull FileBasedIndexExtension<Integer, SerializedStubTree> extension, @NotNull IndexStorage<Integer, SerializedStubTree> storage) throws StorageException, IOException {
        ((StubIndexImpl)StubIndex.getInstance()).initializeStubIndexes();
        if (storage instanceof TransientChangesIndexStorage) {
            TransientChangesIndexStorage memStorage = (TransientChangesIndexStorage)storage;
            memStorage.addBufferingStateListener(new TransientChangesIndexStorage.BufferingStateListener(){

                @Override
                public void bufferingStateChanged(boolean newState2) {
                    ((StubIndexImpl)StubIndex.getInstance()).setDataBufferingEnabled(newState2);
                }

                @Override
                public void memoryStorageCleared() {
                    ((StubIndexImpl)StubIndex.getInstance()).cleanupMemoryStorage();
                }
            });
        }
        this.checkNameStorage();
        boolean hasSnapshotMapping = VfsAwareMapReduceIndex.hasSnapshotMapping(this);
        StubUpdatingForwardIndexAccessor stubForwardIndexAccessor = new StubUpdatingForwardIndexAccessor(extension);
        SnapshotInputMappings<Integer, SerializedStubTree> snapshotInputMappings = hasSnapshotMapping ? new SnapshotInputMappings<Integer, SerializedStubTree>((IndexExtension<Integer, SerializedStubTree, FileContent>)this, stubForwardIndexAccessor) : null;
        IntMapForwardIndex forwardIndex = hasSnapshotMapping ? new IntMapForwardIndex(snapshotInputMappings.getInputIndexStorageFile(), true) : new EmptyForwardIndex();
        AbstractMapForwardIndexAccessor accessor = hasSnapshotMapping ? snapshotInputMappings.getForwardIndexAccessor() : stubForwardIndexAccessor;
        return new MyIndex(extension, storage, (ForwardIndex)forwardIndex, (ForwardIndexAccessor<Integer, SerializedStubTree>)accessor, snapshotInputMappings);
    }

    private void checkNameStorage() throws StorageException {
        if (this.mySerializationManager.isNameStorageCorrupted()) {
            this.mySerializationManager.repairNameStorage();
            throw new StorageException("NameStorage for stubs serialization has been corrupted");
        }
    }

    private static void ensureSerializationManagerInitialized(@NotNull SerializationManagerEx serializationManager) {
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            StubUpdatingIndex.instantiateElementTypesFromFields();
            StubIndexEx.initExtensions();
            serializationManager.initSerializers();
        });
    }

    private static void instantiateElementTypesFromFields() {
        FileTypeRegistry.getInstance().getRegisteredFileTypes();
        StubUpdatingIndex.getExtensions(BinaryFileStubBuilders.INSTANCE).forEach(builder2 -> {});
        StubUpdatingIndex.getExtensions(LanguageParserDefinitions.INSTANCE).forEach(ParserDefinition::getFileNodeType);
    }

    @NotNull
    private static <T> Stream<T> getExtensions(@NotNull KeyedExtensionCollector<T, ?> collector) {
        ExtensionPoint point = collector.getPoint();
        return point == null ? Stream.empty() : point.extensions().map(KeyedLazyInstance::getInstance);
    }

    private static class MyIndex
    extends VfsAwareMapReduceIndex<Integer, SerializedStubTree> {
        private StubIndexImpl myStubIndex;
        @Nullable
        private final CompositeBinaryBuilderMap myCompositeBinaryBuilderMap = FileBasedIndex.USE_IN_MEMORY_INDEX ? null : new CompositeBinaryBuilderMap();

        MyIndex(@NotNull FileBasedIndexExtension<Integer, SerializedStubTree> extension, @NotNull IndexStorage<Integer, SerializedStubTree> storage, @Nullable ForwardIndex forwardIndex, @Nullable ForwardIndexAccessor<Integer, SerializedStubTree> forwardIndexAccessor, @Nullable SnapshotInputMappings<Integer, SerializedStubTree> snapshotInputMappings) throws IOException {
            super(extension, storage, forwardIndex, forwardIndexAccessor, snapshotInputMappings, (ReadWriteLock)null);
        }

        @Override
        protected void doFlush() throws IOException, StorageException {
            StubIndexImpl stubIndex = this.getStubIndex();
            try {
                stubIndex.flush();
            }
            finally {
                super.doFlush();
            }
        }

        @NotNull
        private StubIndexImpl getStubIndex() {
            StubIndexImpl index = this.myStubIndex;
            if (index == null) {
                this.myStubIndex = index = (StubIndexImpl)StubIndex.getInstance();
            }
            return index;
        }

        @Override
        @NotNull
        protected InputData<Integer, SerializedStubTree> mapInput(int inputId, @Nullable FileContent content2) {
            InputData data2 = super.mapInput(inputId, content2);
            if (content2 != null && !data2.getKeyValues().isEmpty()) {
                StubUpdatingIndex.rememberIndexingStamp(content2);
            }
            return data2;
        }

        @Override
        protected void removeTransientDataForInMemoryKeys(int inputId, @NotNull Map<? extends Integer, ? extends SerializedStubTree> map2) {
            super.removeTransientDataForInMemoryKeys(inputId, map2);
            MyIndex.removeStubIndexKeys(inputId, MyIndex.getStubIndexMaps(map2));
        }

        @Override
        public void removeTransientDataForKeys(int inputId, @NotNull Collection<? extends Integer> keys2) {
            Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> maps;
            try {
                Map data2 = this.getIndexedFileData(inputId);
                maps = MyIndex.getStubIndexMaps(data2);
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
            super.removeTransientDataForKeys(inputId, keys2);
            MyIndex.removeStubIndexKeys(inputId, maps);
        }

        private static void removeStubIndexKeys(int inputId, @NotNull Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> indexedStubs) {
            StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
            for (StubIndexKey<?, ?> key : indexedStubs.keySet()) {
                stubIndex.removeTransientDataForFile(key, inputId, indexedStubs.get(key).keySet());
            }
        }

        @NotNull
        private static Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> getStubIndexMaps(@NotNull Map<? extends Integer, ? extends SerializedStubTree> data2) {
            if (data2.isEmpty()) {
                return Collections.emptyMap();
            }
            SerializedStubTree tree = data2.values().iterator().next();
            return tree == null ? Collections.emptyMap() : tree.getStubIndicesValueMap();
        }

        @Override
        protected void doClear() throws StorageException, IOException {
            StubIndexImpl stubIndex = StubIndexImpl.getInstanceOrInvalidate();
            if (stubIndex != null) {
                stubIndex.clearAllIndices();
            }
            super.doClear();
        }

        @Override
        protected void doDispose() throws StorageException {
            try {
                super.doDispose();
            }
            finally {
                this.getStubIndex().dispose();
            }
        }

        @Override
        public void setIndexedStateForFile(int fileId, @NotNull IndexedFile file2) {
            super.setIndexedStateForFile(fileId, file2);
            this.setBinaryBuilderConfiguration(fileId, file2);
        }

        @Override
        protected boolean isIndexConfigurationUpToDate(int fileId, @NotNull IndexedFile file2) {
            if (this.myCompositeBinaryBuilderMap == null) {
                return true;
            }
            try {
                return this.myCompositeBinaryBuilderMap.isUpToDateState(fileId, file2.getFile());
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return false;
            }
        }

        @Override
        protected void setIndexConfigurationUpToDate(int fileId, @NotNull IndexedFile file2) {
            this.setBinaryBuilderConfiguration(fileId, file2);
        }

        private void setBinaryBuilderConfiguration(int fileId, @NotNull IndexedFile file2) {
            if (this.myCompositeBinaryBuilderMap != null) {
                try {
                    this.myCompositeBinaryBuilderMap.persistState(fileId, file2.getFile());
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }
}

