/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StubTextInconsistencyException
extends RuntimeException
implements ExceptionWithAttachments {
    private final String myStubsFromText;
    private final String myStubsFromPsi;
    private final String myFileName;
    private final String myFileText;

    private StubTextInconsistencyException(String message, PsiFile file2, List<PsiFileStub> fromText, List<PsiFileStub> fromPsi) {
        super(message);
        this.myStubsFromText = StringUtil.join(fromText, DebugUtil::stubTreeToString, (String)"\n");
        this.myStubsFromPsi = StringUtil.join(fromPsi, DebugUtil::stubTreeToString, (String)"\n");
        this.myFileName = file2.getName();
        this.myFileText = file2.getText();
    }

    @NotNull
    public String getStubsFromText() {
        return this.myStubsFromText;
    }

    @NotNull
    public String getStubsFromPsi() {
        return this.myStubsFromPsi;
    }

    public Attachment @NotNull [] getAttachments() {
        return new Attachment[]{new Attachment(this.myFileName, this.myFileText), new Attachment("stubsRestoredFromText.txt", this.myStubsFromText), new Attachment("stubsFromExistingPsi.txt", this.myStubsFromPsi)};
    }

    public static void checkStubTextConsistency(@NotNull PsiFile file2) throws StubTextInconsistencyException {
        PsiUtilCore.ensureValid((PsiElement)file2);
        FileViewProvider viewProvider = file2.getViewProvider();
        if (viewProvider instanceof FreeThreadedFileViewProvider || viewProvider.getVirtualFile() instanceof LightVirtualFile) {
            return;
        }
        PsiFile bindingRoot = viewProvider.getStubBindingRoot();
        if (!(bindingRoot instanceof PsiFileImpl)) {
            return;
        }
        IStubFileElementType fileElementType = ((PsiFileImpl)bindingRoot).getElementTypeForStubBuilder();
        if (fileElementType == null || !fileElementType.shouldBuildStubFor(viewProvider.getVirtualFile())) {
            return;
        }
        List<PsiFileStub> fromText = StubTextInconsistencyException.restoreStubsFromText(viewProvider);
        List fromPsi = ContainerUtil.map(StubTreeBuilder.getStubbedRoots(viewProvider), p -> ((PsiFileImpl)p.getSecond()).calcStubTree().getRoot());
        if (fromPsi.size() != fromText.size()) {
            throw new StubTextInconsistencyException("Inconsistent stub roots: PSI says it's " + ContainerUtil.map((Collection)fromPsi, s -> s.getType()) + " but re-parsing the text gives " + ContainerUtil.map(fromText, s -> s.getType()), file2, fromText, fromPsi);
        }
        for (int i2 = 0; i2 < fromPsi.size(); ++i2) {
            PsiFileStub psiStub = (PsiFileStub)fromPsi.get(i2);
            if (DebugUtil.stubTreeToString((Stub)psiStub).equals(DebugUtil.stubTreeToString((Stub)fromText.get(i2)))) continue;
            throw new StubTextInconsistencyException("Stub is inconsistent with text in " + file2.getLanguage(), file2, fromText, fromPsi);
        }
    }

    @NotNull
    private static List<PsiFileStub> restoreStubsFromText(FileViewProvider viewProvider) {
        FileContentImpl fc = new FileContentImpl(viewProvider.getVirtualFile(), viewProvider.getContents(), 0L);
        fc.setProject(viewProvider.getManager().getProject());
        PsiFileStubImpl copyTree = (PsiFileStubImpl)StubTreeBuilder.buildStubTree((FileContent)fc);
        return copyTree == null ? Collections.emptyList() : Arrays.asList(copyTree.getStubRoots());
    }
}

