/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.psi.stubs.ByteArrayInterner;
import com.intellij.psi.stubs.FileLocalStringEnumerator;
import com.intellij.psi.stubs.IntEnumerator;
import com.intellij.psi.stubs.LazyStubData;
import com.intellij.psi.stubs.LazyStubList;
import com.intellij.psi.stubs.MostlyUShortIntList;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubList;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializationUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.RecentStringInterner;
import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataEnumeratorEx;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StubSerializationHelper {
    private static final Logger LOG = Logger.getInstance(StubSerializationHelper.class);
    private final DataEnumeratorEx<String> myNameStorage;
    private final TIntObjectHashMap<String> myIdToName = new TIntObjectHashMap();
    private final TObjectIntHashMap<String> myNameToId = new TObjectIntHashMap();
    private final THashMap<String, Computable<ObjectStubSerializer>> myNameToLazySerializer = new THashMap();
    private final ConcurrentIntObjectMap<ObjectStubSerializer> myIdToSerializer = ContainerUtil.createConcurrentIntObjectMap();
    private final Map<ObjectStubSerializer, Integer> mySerializerToId = new ConcurrentHashMap<ObjectStubSerializer, Integer>();
    private final boolean myUnmodifiable;
    private final RecentStringInterner myStringInterner;
    private static final ThreadLocal<ObjectStubSerializer> ourRootStubSerializer = new ThreadLocal();

    void dropRegisteredSerializers() {
        this.myIdToName.clear();
        this.myNameToId.clear();
        this.myNameToLazySerializer.clear();
        this.myIdToSerializer.clear();
        this.mySerializerToId.clear();
    }

    StubSerializationHelper(@NotNull DataEnumeratorEx<String> nameStorage, boolean unmodifiable, @NotNull Disposable parentDisposable) {
        this.myNameStorage = nameStorage;
        this.myUnmodifiable = unmodifiable;
        this.myStringInterner = new RecentStringInterner(parentDisposable);
    }

    void assignId(@NotNull Computable<ObjectStubSerializer> serializer, String name) throws IOException {
        int id2;
        Computable old = (Computable)this.myNameToLazySerializer.put((Object)name, serializer);
        if (old != null) {
            ObjectStubSerializer computed;
            ObjectStubSerializer existing = (ObjectStubSerializer)old.compute();
            if (existing != (computed = (ObjectStubSerializer)serializer.compute())) {
                throw new AssertionError((Object)("ID: " + name + " is not unique, but found in both " + existing.getClass().getName() + " and " + computed.getClass().getName()));
            }
            return;
        }
        if (this.myUnmodifiable) {
            id2 = this.myNameStorage.tryEnumerate((Object)name);
            if (id2 == 0) {
                LOG.debug("serialized " + name + " is ignored in unmodifiable stub serialization manager");
                return;
            }
        } else {
            id2 = this.myNameStorage.enumerate((Object)name);
        }
        this.myIdToName.put(id2, (Object)name);
        this.myNameToId.put((Object)name, id2);
    }

    void copyFrom(@Nullable StubSerializationHelper helper) throws IOException {
        if (helper == null) {
            return;
        }
        for (String name : helper.myNameToLazySerializer.keySet()) {
            this.assignId((Computable<ObjectStubSerializer>)((Computable)helper.myNameToLazySerializer.get((Object)name)), name);
        }
    }

    private ObjectStubSerializer<Stub, Stub> writeSerializerId(Stub stub, @NotNull DataOutput stream, IntEnumerator serializerLocalEnumerator) throws IOException {
        ObjectStubSerializer serializer = StubSerializationUtil.getSerializer((Stub)stub);
        if (serializer == null) {
            throw new Error("No serializer was returned for " + stub);
        }
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)serializerLocalEnumerator.enumerate(this.getClassId((ObjectStubSerializer<Stub, Stub>)serializer)));
        return serializer;
    }

    private void serializeSelf(Stub stub, @NotNull StubOutputStream stream, IntEnumerator serializerLocalEnumerator) throws IOException {
        if (((ObjectStubBase)stub).isDangling()) {
            stream.writeByte(0);
        }
        this.writeSerializerId(stub, (DataOutput)stream, serializerLocalEnumerator).serialize(stub, stream);
    }

    private void serializeChildren(@NotNull Stub parent, @NotNull StubOutputStream stream, IntEnumerator serializerLocalEnumerator) throws IOException {
        List children2 = parent.getChildrenStubs();
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)children2.size());
        for (Stub child2 : children2) {
            this.serializeSelf(child2, stream, serializerLocalEnumerator);
            this.serializeChildren(child2, stream, serializerLocalEnumerator);
        }
    }

    void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) throws IOException {
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        FileLocalStringEnumerator storage = new FileLocalStringEnumerator(true);
        IntEnumerator selializerIdLocalEnumerator = new IntEnumerator();
        StubOutputStream stubOutputStream = new StubOutputStream((OutputStream)out, (AbstractStringEnumerator)storage);
        boolean doDefaultSerialization = true;
        if (rootStub instanceof PsiFileStubImpl) {
            PsiFileStub[] roots = ((PsiFileStubImpl)rootStub).getStubRoots();
            if (roots.length == 0) {
                Logger.getInstance(this.getClass()).error("Incorrect stub files count during serialization:" + rootStub + "," + rootStub.getStubType());
            } else {
                doDefaultSerialization = false;
                DataInputOutputUtil.writeINT((DataOutput)stubOutputStream, (int)roots.length);
                for (PsiFileStub root : roots) {
                    this.serializeRoot(stubOutputStream, (Stub)root, storage, selializerIdLocalEnumerator);
                }
            }
        }
        if (doDefaultSerialization) {
            DataInputOutputUtil.writeINT((DataOutput)stubOutputStream, (int)1);
            this.serializeRoot(stubOutputStream, rootStub, storage, selializerIdLocalEnumerator);
        }
        DataOutputStream resultStream = new DataOutputStream(stream);
        selializerIdLocalEnumerator.dump(resultStream);
        storage.write(resultStream);
        resultStream.write(out.getInternalBuffer(), 0, out.size());
    }

    private int getClassId(@NotNull ObjectStubSerializer<Stub, Stub> serializer) {
        Integer idValue = this.mySerializerToId.get(serializer);
        if (idValue == null) {
            String name = serializer.getExternalId();
            idValue = this.myNameToId.get((Object)name);
            assert (idValue > 0) : "No ID found for serializer " + LogUtil.objectAndClass(serializer) + ", external id:" + name + (serializer instanceof IElementType ? ", language:" + ((IElementType)serializer).getLanguage() + ", " + serializer : "");
            this.mySerializerToId.put(serializer, idValue);
        }
        return idValue;
    }

    @NotNull
    Stub deserialize(@NotNull InputStream stream) throws IOException, SerializerNotFoundException {
        PsiFileStub[] stubsArray;
        FileLocalStringEnumerator storage = new FileLocalStringEnumerator(false);
        StubInputStream inputStream = new StubInputStream(stream, (AbstractStringEnumerator)storage);
        IntEnumerator serializerLocalEnumerator = IntEnumerator.read((DataInputStream)inputStream);
        storage.read((DataInput)inputStream, this::intern);
        int stubFilesCount = DataInputOutputUtil.readINT((DataInput)inputStream);
        if (stubFilesCount <= 0) {
            Logger.getInstance(this.getClass()).error("Incorrect stub files count during deserialization:" + stubFilesCount);
        }
        Stub baseStub = this.deserializeRoot(inputStream, storage, serializerLocalEnumerator);
        ArrayList<PsiFileStub> stubs = new ArrayList<PsiFileStub>(stubFilesCount);
        if (baseStub instanceof PsiFileStub) {
            stubs.add((PsiFileStub)baseStub);
        }
        for (int j = 1; j < stubFilesCount; ++j) {
            Stub deserialize = this.deserializeRoot(inputStream, storage, serializerLocalEnumerator);
            if (deserialize instanceof PsiFileStub) {
                PsiFileStub fileStub = (PsiFileStub)deserialize;
                stubs.add(fileStub);
                continue;
            }
            Logger.getInstance(this.getClass()).error("Stub root must be PsiFileStub for files with several stub roots");
        }
        for (PsiFileStub stub : stubsArray = stubs.toArray(PsiFileStub.EMPTY_ARRAY)) {
            if (!(stub instanceof PsiFileStubImpl)) continue;
            ((PsiFileStubImpl)stub).setStubRoots(stubsArray);
        }
        return baseStub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stub deserializeRoot(StubInputStream inputStream, FileLocalStringEnumerator storage, IntEnumerator serializerLocalEnumerator) throws IOException, SerializerNotFoundException {
        ObjectStubSerializer<?, Stub> serializer = this.getClassById(DataInputOutputUtil.readINT((DataInput)inputStream), null, serializerLocalEnumerator);
        ourRootStubSerializer.set(serializer);
        try {
            Stub stub = serializer.deserialize(inputStream, null);
            if (stub instanceof StubBase) {
                this.deserializeStubList((StubBase)stub, serializer, inputStream, storage, serializerLocalEnumerator);
            } else {
                this.deserializeChildren(inputStream, stub, serializerLocalEnumerator);
            }
            Stub stub2 = stub;
            return stub2;
        }
        finally {
            ourRootStubSerializer.set(null);
        }
    }

    private void serializeRoot(StubOutputStream out, Stub root, AbstractStringEnumerator storage, IntEnumerator serializerLocalEnumerator) throws IOException {
        this.serializeSelf(root, out, serializerLocalEnumerator);
        if (root instanceof StubBase) {
            StubList stubList = ((StubBase)root).myStubList;
            if (root != stubList.get(0)) {
                throw new IllegalArgumentException("Serialization is supported only for root stubs");
            }
            this.serializeStubList(stubList, (DataOutput)out, storage, serializerLocalEnumerator);
        } else {
            this.serializeChildren(root, out, serializerLocalEnumerator);
        }
    }

    private void deserializeStubList(StubBase<?> root, final ObjectStubSerializer rootType, final StubInputStream inputStream, FileLocalStringEnumerator storage, final IntEnumerator serializerLocalEnumerator) throws IOException, SerializerNotFoundException {
        int stubCount = DataInputOutputUtil.readINT((DataInput)inputStream);
        final LazyStubList stubList = new LazyStubList(stubCount, root, rootType);
        final MostlyUShortIntList parentsAndStarts = new MostlyUShortIntList(stubCount * 2);
        final BitSet allStarts = new BitSet();
        new Object(){
            int currentIndex = 1;

            private void deserializeStub(int parentIndex) throws IOException, SerializerNotFoundException {
                int index = this.currentIndex++;
                int serializerId = DataInputOutputUtil.readINT((DataInput)inputStream);
                int start2 = DataInputOutputUtil.readINT((DataInput)inputStream);
                allStarts.set(start2);
                this.addStub(parentIndex, index, start2, (IElementType)StubSerializationHelper.this.getClassById(serializerId, null, serializerLocalEnumerator));
                this.deserializeChildren(index);
            }

            private void addStub(int parentIndex, int index, int start2, IElementType type) {
                parentsAndStarts.add(parentIndex);
                parentsAndStarts.add(start2);
                stubList.addLazyStub(type, index, parentIndex);
            }

            private void deserializeChildren(int parentIndex) throws IOException, SerializerNotFoundException {
                int childrenCount = DataInputOutputUtil.readINT((DataInput)inputStream);
                stubList.prepareForChildren(parentIndex, childrenCount);
                for (int i2 = 0; i2 < childrenCount; ++i2) {
                    this.deserializeStub(parentIndex);
                }
            }

            void deserializeRoot() throws IOException, SerializerNotFoundException {
                this.addStub(0, 0, 0, (IElementType)rootType);
                this.deserializeChildren(0);
            }
        }.deserializeRoot();
        byte[] serializedStubs = this.readByteArray(inputStream);
        stubList.setStubData(new LazyStubData(storage, parentsAndStarts, serializedStubs, allStarts));
    }

    private void serializeStubList(StubList stubList, DataOutput out, AbstractStringEnumerator storage, IntEnumerator serializerLocalEnumerator) throws IOException {
        if (!stubList.isChildrenLayoutOptimal()) {
            throw new IllegalArgumentException("Manually assembled stubs should be normalized before serialization, consider wrapping them into StubTree");
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)stubList.size());
        DataInputOutputUtil.writeINT((DataOutput)out, (int)stubList.getChildrenCount(0));
        BufferExposingByteArrayOutputStream tempBuffer = new BufferExposingByteArrayOutputStream();
        ByteArrayInterner interner = new ByteArrayInterner();
        for (int i2 = 1; i2 < stubList.size(); ++i2) {
            StubBase stub = (StubBase)stubList.get(i2);
            ObjectStubSerializer<Stub, Stub> serializer = this.writeSerializerId((Stub)stub, out, serializerLocalEnumerator);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)interner.internBytes(StubSerializationHelper.serializeStub(serializer, storage, stub, tempBuffer)));
            DataInputOutputUtil.writeINT((DataOutput)out, (int)stubList.getChildrenCount(stub.id));
        }
        StubSerializationHelper.writeByteArray(out, interner.joinedBuffer.getInternalBuffer(), interner.joinedBuffer.size());
    }

    private static byte[] serializeStub(ObjectStubSerializer<Stub, Stub> serializer, AbstractStringEnumerator storage, StubBase<?> stub, BufferExposingByteArrayOutputStream tempBuffer) throws IOException {
        tempBuffer.reset();
        StubOutputStream stubOut = new StubOutputStream((OutputStream)tempBuffer, storage);
        serializer.serialize(stub, stubOut);
        if (stub.isDangling()) {
            stubOut.writeByte(0);
        }
        return tempBuffer.size() == 0 ? ArrayUtilRt.EMPTY_BYTE_ARRAY : tempBuffer.toByteArray();
    }

    private byte[] readByteArray(StubInputStream inputStream) throws IOException {
        int length = DataInputOutputUtil.readINT((DataInput)inputStream);
        if (length == 0) {
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        byte[] array2 = new byte[length];
        int read = inputStream.read(array2);
        if (read != array2.length) {
            Logger.getInstance(this.getClass()).error("Serialized array length mismatch");
        }
        return array2;
    }

    private static void writeByteArray(DataOutput out, byte[] array2, int len) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)out, (int)len);
        out.write(array2, 0, len);
    }

    @Nullable
    @Contract(value="null -> null")
    String intern(@Nullable String str) {
        return this.myStringInterner.get(str);
    }

    void reSerializeStub(@NotNull DataInputStream inStub, @NotNull DataOutputStream outStub, @NotNull StubSerializationHelper newSerializationHelper) throws IOException {
        IntEnumerator currentSerializerEnumerator = IntEnumerator.read(inStub);
        currentSerializerEnumerator.dump(outStub, id2 -> {
            String name = (String)this.myIdToName.get(id2);
            return name == null ? 0 : newSerializationHelper.myNameToId.get((Object)name);
        });
        StreamUtil.copyStreamContent((InputStream)inStub, (OutputStream)outStub);
    }

    private ObjectStubSerializer<?, Stub> getClassById(int localId, @Nullable Stub parentStub, IntEnumerator enumerator) throws SerializerNotFoundException {
        int id2 = enumerator.valueOf(localId);
        ObjectStubSerializer serializer = (ObjectStubSerializer)this.myIdToSerializer.get(id2);
        if (serializer == null) {
            serializer = this.instantiateSerializer(id2, parentStub);
            this.myIdToSerializer.put(id2, (Object)serializer);
        }
        return serializer;
    }

    @NotNull
    private ObjectStubSerializer instantiateSerializer(int id2, @Nullable Stub parentStub) throws SerializerNotFoundException {
        ObjectStubSerializer serializer;
        String name = (String)this.myIdToName.get(id2);
        Computable lazy = name == null ? null : (Computable)this.myNameToLazySerializer.get((Object)name);
        ObjectStubSerializer objectStubSerializer = serializer = lazy == null ? null : (ObjectStubSerializer)lazy.compute();
        if (serializer == null) {
            throw this.reportMissingSerializer(id2, parentStub);
        }
        return serializer;
    }

    private SerializerNotFoundException reportMissingSerializer(int id2, @Nullable Stub parentStub) {
        String externalId = null;
        try {
            externalId = (String)this.myNameStorage.valueOf(id2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new SerializerNotFoundException(StubSerializationUtil.brokenStubFormat((ObjectStubSerializer)ourRootStubSerializer.get()) + "Internal details, no serializer registered for stub: ID=" + id2 + ", externalId:" + externalId + "; parent stub class=" + (parentStub != null ? parentStub.getClass().getName() + ", parent stub type:" + parentStub.getStubType() : "null"));
    }

    private void deserializeChildren(StubInputStream stream, Stub parent, IntEnumerator serializerLocalEnumerator) throws IOException, SerializerNotFoundException {
        int childCount = DataInputOutputUtil.readINT((DataInput)stream);
        for (int i2 = 0; i2 < childCount; ++i2) {
            boolean dangling = false;
            int id2 = DataInputOutputUtil.readINT((DataInput)stream);
            if (id2 == 0) {
                dangling = true;
                id2 = DataInputOutputUtil.readINT((DataInput)stream);
            }
            Stub child2 = this.getClassById(id2, parent, serializerLocalEnumerator).deserialize(stream, parent);
            if (dangling) {
                ((ObjectStubBase)child2).markDangling();
            }
            this.deserializeChildren(stream, child2, serializerLocalEnumerator);
        }
    }
}

