/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubForwardIndexExternalizer;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubIndexKeyDescriptorCache;
import com.intellij.psi.stubs.StubTree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SerializedStubTree {
    final byte[] myTreeBytes;
    final int myTreeByteLength;
    final byte[] myIndexedStubBytes;
    final int myIndexedStubByteLength;
    private Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> myIndexedStubs;
    @NotNull
    private final SerializationManagerEx mySerializationManager;
    @NotNull
    private final StubForwardIndexExternalizer<?> myStubIndexesExternalizer;
    private byte[] myTreeHash;
    public static final Stub NO_STUB = new Stub(){

        public Stub getParentStub() {
            return null;
        }

        @NotNull
        public List<? extends Stub> getChildrenStubs() {
            return Collections.emptyList();
        }

        public ObjectStubSerializer getStubType() {
            return null;
        }

        public String toString() {
            return "<no stub>";
        }
    };

    public SerializedStubTree(byte @NotNull [] treeBytes, int treeByteLength, byte @NotNull [] indexedStubBytes, int indexedStubByteLength, @Nullable Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> indexedStubs, @NotNull StubForwardIndexExternalizer<?> stubIndexesExternalizer, @NotNull SerializationManagerEx serializationManager) {
        this.myTreeBytes = treeBytes;
        this.myTreeByteLength = treeByteLength;
        this.myIndexedStubBytes = indexedStubBytes;
        this.myIndexedStubByteLength = indexedStubByteLength;
        this.myIndexedStubs = indexedStubs;
        this.myStubIndexesExternalizer = stubIndexesExternalizer;
        this.mySerializationManager = serializationManager;
    }

    @NotNull
    public static SerializedStubTree serializeStub(@NotNull Stub rootStub, @NotNull SerializationManagerEx serializationManager, @NotNull StubForwardIndexExternalizer<?> forwardIndexExternalizer) throws IOException {
        BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
        serializationManager.serialize(rootStub, (OutputStream)bytes);
        byte[] treeBytes = bytes.getInternalBuffer();
        int treeByteLength = bytes.size();
        ObjectStubBase root = (ObjectStubBase)rootStub;
        Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> indexedStubs = SerializedStubTree.indexTree((Stub)root);
        BufferExposingByteArrayOutputStream indexBytes = new BufferExposingByteArrayOutputStream();
        forwardIndexExternalizer.save((DataOutput)new DataOutputStream((OutputStream)indexBytes), indexedStubs);
        byte[] indexedStubBytes = indexBytes.getInternalBuffer();
        int indexedStubByteLength = indexBytes.size();
        return new SerializedStubTree(treeBytes, treeByteLength, indexedStubBytes, indexedStubByteLength, indexedStubs, forwardIndexExternalizer, serializationManager);
    }

    @NotNull
    public SerializedStubTree reSerialize(@NotNull SerializationManagerEx newSerializationManager, @NotNull StubForwardIndexExternalizer<?> newForwardIndexSerializer) throws IOException {
        int reSerializedIndexByteLength;
        byte[] reSerializedIndexBytes;
        BufferExposingByteArrayOutputStream outStub = new BufferExposingByteArrayOutputStream();
        this.mySerializationManager.reSerialize(new ByteArrayInputStream(this.myTreeBytes, 0, this.myTreeByteLength), (OutputStream)outStub, newSerializationManager);
        if (this.myStubIndexesExternalizer == newForwardIndexSerializer) {
            reSerializedIndexBytes = this.myIndexedStubBytes;
            reSerializedIndexByteLength = this.myIndexedStubByteLength;
        } else {
            BufferExposingByteArrayOutputStream reSerializedStubIndices = new BufferExposingByteArrayOutputStream();
            newForwardIndexSerializer.save((DataOutput)new DataOutputStream((OutputStream)reSerializedStubIndices), this.getStubIndicesValueMap());
            reSerializedIndexBytes = reSerializedStubIndices.getInternalBuffer();
            reSerializedIndexByteLength = reSerializedStubIndices.size();
        }
        return new SerializedStubTree(outStub.getInternalBuffer(), outStub.size(), reSerializedIndexBytes, reSerializedIndexByteLength, this.myIndexedStubs, newForwardIndexSerializer, newSerializationManager);
    }

    @ApiStatus.Internal
    @NotNull
    public StubForwardIndexExternalizer<?> getStubIndexesExternalizer() {
        return this.myStubIndexesExternalizer;
    }

    void restoreIndexedStubs() throws IOException {
        if (this.myIndexedStubs == null) {
            this.myIndexedStubs = this.myStubIndexesExternalizer.read(new DataInputStream(new ByteArrayInputStream(this.myIndexedStubBytes, 0, this.myIndexedStubByteLength)));
        }
    }

    <K> StubIdList restoreIndexedStubs(@NotNull StubIndexKey<K, ?> indexKey, @NotNull K key) throws IOException {
        Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> incompleteMap = this.myStubIndexesExternalizer.doRead(new DataInputStream(new ByteArrayInputStream(this.myIndexedStubBytes, 0, this.myIndexedStubByteLength)), indexKey, key);
        if (incompleteMap == null) {
            return null;
        }
        Map<Object, StubIdList> map2 = incompleteMap.get(indexKey);
        return map2 == null ? null : map2.get(key);
    }

    @NotNull
    public Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> getStubIndicesValueMap() {
        try {
            this.restoreIndexedStubs();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.myIndexedStubs;
    }

    @NotNull
    public Stub getStub() throws SerializerNotFoundException {
        if (this.myTreeByteLength == 0) {
            return NO_STUB;
        }
        return this.mySerializationManager.deserialize((InputStream)new UnsyncByteArrayInputStream(this.myTreeBytes, 0, this.myTreeByteLength));
    }

    @NotNull
    public SerializedStubTree withoutStub() {
        return new SerializedStubTree(ArrayUtil.EMPTY_BYTE_ARRAY, 0, this.myIndexedStubBytes, this.myIndexedStubByteLength, this.myIndexedStubs, this.myStubIndexesExternalizer, this.mySerializationManager);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof SerializedStubTree)) {
            return false;
        }
        SerializedStubTree thatTree = (SerializedStubTree)that;
        int length = this.myTreeByteLength;
        if (length != thatTree.myTreeByteLength) {
            return false;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (this.myTreeBytes[i2] == thatTree.myTreeBytes[i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result2 = 1;
        for (int i2 = 0; i2 < this.myTreeByteLength; ++i2) {
            result2 = 31 * result2 + this.myTreeBytes[i2];
        }
        return result2;
    }

    @NotNull
    static Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> indexTree(@NotNull Stub root) {
        ObjectStubTree objectStubTree = root instanceof PsiFileStub ? new StubTree((PsiFileStub)root, false) : new ObjectStubTree((ObjectStubBase)root, false);
        Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> map2 = objectStubTree.indexStubTree(k -> StubIndexKeyDescriptorCache.INSTANCE.getKeyHashingStrategy(k));
        for (StubIndexKey<?, ?> key : map2.keySet()) {
            Map<Object, StubIdList> value2 = map2.get(key);
            for (Object k2 : value2.keySet()) {
                int[] ints = (int[])value2.get(k2);
                StubIdList stubList = ints.length == 1 ? new StubIdList(ints[0]) : new StubIdList(ints, ints.length);
                value2.put(k2, stubList);
            }
        }
        return map2;
    }

    public synchronized byte @NotNull [] getTreeHash() {
        if (this.myTreeHash == null) {
            MessageDigest digest = DigestUtil.sha256();
            digest.update(String.valueOf(this.myTreeByteLength).getBytes(StandardCharsets.UTF_8));
            digest.update("\u0000".getBytes(StandardCharsets.UTF_8));
            digest.update(this.myTreeBytes, 0, this.myTreeByteLength);
            this.myTreeHash = digest.digest();
        }
        return this.myTreeHash;
    }
}

