/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.IndexPatternOptimizer;
import com.intellij.util.PlatformUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class IndexPatternOptimizerImpl
implements IndexPatternOptimizer {
    @NotNull
    public List<String> extractStringsToFind(@NotNull String regexp) {
        if (ApplicationManager.getApplication().isUnitTestMode() && PlatformUtils.isDataGrip()) {
            return Collections.emptyList();
        }
        Project project = ProjectLocator.getInstance().guessProjectForFile(null);
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        String stringToFind = FindInProjectUtil.extractStringToFind(regexp, project);
        return StringUtil.getWordsIn((String)stringToFind);
    }
}

