/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FileTypeIndexImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.MapInputDataDiffBuilder;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.util.io.StorageLockContext;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class FileTypeMapReduceIndex
extends VfsAwareMapReduceIndex<FileType, Void> {
    private static final Logger LOG = Logger.getInstance(FileTypeIndexImpl.class);
    private PersistentStringEnumerator myFileTypeNameEnumerator = FileTypeMapReduceIndex.createFileTypeNameEnumerator();

    FileTypeMapReduceIndex(@NotNull FileBasedIndexExtension<FileType, Void> extension, @NotNull IndexStorage<FileType, Void> storage) throws IOException {
        super(extension, storage);
    }

    @Override
    @NotNull
    public FileIndexingState getIndexingStateForFile(int fileId, @NotNull IndexedFile file2) {
        @NotNull FileIndexingState isIndexed = super.getIndexingStateForFile(fileId, file2);
        if (isIndexed != FileIndexingState.UP_TO_DATE) {
            return isIndexed;
        }
        try {
            Collection inputData = ((MapInputDataDiffBuilder)this.getKeysDiffBuilder(fileId)).getKeys();
            FileType indexedFileType = (FileType)ContainerUtil.getFirstItem((Collection)inputData);
            return this.getExtension().getKeyDescriptor().isEqual((Object)indexedFileType, (Object)file2.getFileType()) ? FileIndexingState.UP_TO_DATE : FileIndexingState.OUT_DATED;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return FileIndexingState.OUT_DATED;
        }
    }

    @Override
    protected void doFlush() throws IOException, StorageException {
        super.doFlush();
        this.myFileTypeNameEnumerator.force();
    }

    @Override
    protected void doDispose() throws StorageException {
        try {
            super.doDispose();
        }
        catch (Throwable throwable) {
            IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{this.myFileTypeNameEnumerator});
            throw throwable;
        }
        IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{this.myFileTypeNameEnumerator});
    }

    @Override
    protected void doClear() throws StorageException, IOException {
        super.doClear();
        IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{this.myFileTypeNameEnumerator});
        IOUtil.deleteAllFilesStartingWith((File)FileTypeMapReduceIndex.getFileTypeNameEnumeratorPath().toFile());
        this.myFileTypeNameEnumerator = FileTypeMapReduceIndex.createFileTypeNameEnumerator();
    }

    public int getFileTypeId(String name) throws IOException {
        return this.myFileTypeNameEnumerator.enumerate(name);
    }

    public String getFileTypeName(int id2) throws IOException {
        return this.myFileTypeNameEnumerator.valueOf(id2);
    }

    @NotNull
    private static PersistentStringEnumerator createFileTypeNameEnumerator() throws IOException {
        return new PersistentStringEnumerator(FileTypeMapReduceIndex.getFileTypeNameEnumeratorPath(), 128, true, new StorageLockContext(true));
    }

    @NotNull
    private static Path getFileTypeNameEnumeratorPath() {
        return IndexInfrastructure.getIndexRootDir(FileTypeIndex.NAME).toPath().resolve("file.type.names");
    }
}

