/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FileTypeKeyDescriptor;
import com.intellij.psi.search.FileTypeMapReduceIndex;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.io.KeyDescriptor;
import java.io.IOException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public final class FileTypeIndexImpl
extends ScalarIndexExtension<FileType>
implements CustomImplementationFileBasedIndexExtension<FileType, Void> {
    @NotNull
    public ID<FileType, Void> getName() {
        return FileTypeIndex.NAME;
    }

    @NotNull
    public DataIndexer<FileType, Void, FileContent> getIndexer() {
        return in -> Collections.singletonMap(in.getFileType(), null);
    }

    @NotNull
    public KeyDescriptor<FileType> getKeyDescriptor() {
        return new FileTypeKeyDescriptor();
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return file2 -> !file2.isDirectory();
    }

    public boolean dependsOnFileContent() {
        return false;
    }

    public int getVersion() {
        return 3;
    }

    @Override
    @NotNull
    public UpdatableIndex<FileType, Void, FileContent> createIndexImplementation(@NotNull FileBasedIndexExtension<FileType, Void> extension, @NotNull IndexStorage<FileType, Void> storage) throws StorageException, IOException {
        return new FileTypeMapReduceIndex(extension, storage);
    }
}

