/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected.changesHandler;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.injected.changesHandler.BaseInjectedFileChangesHandler;
import com.intellij.psi.impl.source.tree.injected.changesHandler.CommonInjectedFileChangesHandler;
import com.intellij.psi.impl.source.tree.injected.changesHandler.CommonInjectedFileChangesHandlerKt;
import com.intellij.psi.impl.source.tree.injected.changesHandler.MarkersMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J6\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00180\u00170\u00032\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ.\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00182\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0010\b\u0002\u0010!\u001a\n\u0018\u00010\"j\u0004\u0018\u0001`#H\u0004J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0004H\u0004J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0004J*\u0010(\u001a\u00020)2\u0006\u0010 \u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u000e\u0010!\u001a\n\u0018\u00010\"j\u0004\u0018\u0001`#H\u0004J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001bH\u0016J\b\u0010-\u001a\u00020+H\u0016J\u0012\u0010.\u001a\u00020\u00182\b\u0010/\u001a\u0004\u0018\u00010\u001bH\u0004J \u00100\u001a\u00020\u00122\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0018H\u0004J\u0016\u00106\u001a\u00020\u0018*\u00020\b2\b\u0010/\u001a\u0004\u0018\u00010\u001bH\u0004J\u0012\u00107\u001a\u00020\u0018*\b\u0012\u0004\u0012\u00020\u000e0\rH\u0004J\u001c\u00108\u001a\u00020\u0018*\u00020\u00182\u0006\u00109\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020\u001dH\u0004R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006;"}, d2={"Lcom/intellij/psi/impl/source/tree/injected/changesHandler/CommonInjectedFileChangesHandler;", "Lcom/intellij/psi/impl/source/tree/injected/changesHandler/BaseInjectedFileChangesHandler;", "shreds", "", "Lcom/intellij/psi/PsiLanguageInjectionHost$Shred;", "hostEditor", "Lcom/intellij/openapi/editor/Editor;", "fragmentDocument", "Lcom/intellij/openapi/editor/Document;", "injectedFile", "Lcom/intellij/psi/PsiFile;", "(Ljava/util/List;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/Document;Lcom/intellij/psi/PsiFile;)V", "markers", "", "Lcom/intellij/psi/impl/source/tree/injected/changesHandler/MarkersMapping;", "getMarkers", "()Ljava/util/List;", "commitToOriginal", "", "e", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "dispose", "distributeTextToMarkers", "Lkotlin/Pair;", "", "affectedMarkers", "affectedRange", "Lcom/intellij/openapi/util/TextRange;", "limit", "", "failAndReport", "", "message", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "fragmentMarkerFromShred", "Lcom/intellij/openapi/editor/RangeMarker;", "shred", "getMarkersFromShreds", "getReportException", "Lcom/intellij/openapi/diagnostic/RuntimeExceptionWithAttachments;", "handlesRange", "", "range", "isValid", "logHostMarker", "rangeInHost", "updateInjectionHostElement", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "insideHost", "Lcom/intellij/openapi/util/ProperTextRange;", "content", "logMarker", "logMarkersRanges", "substringVerbose", "start", "cursor", "intellij.platform.lang.impl"})
public class CommonInjectedFileChangesHandler
extends BaseInjectedFileChangesHandler {
    @NotNull
    private final List<MarkersMapping> markers;

    @NotNull
    protected final List<MarkersMapping> getMarkers() {
        return this.markers;
    }

    @NotNull
    protected final List<MarkersMapping> getMarkersFromShreds(@NotNull List<? extends PsiLanguageInjectionHost.Shred> shreds) {
        ArrayList<MarkersMapping> result2 = new ArrayList<MarkersMapping>(shreds.size());
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        int curOffset = -1;
        for (PsiLanguageInjectionHost.Shred shred : shreds) {
            PsiLanguageInjectionHost host;
            RangeMarker rangeMarker = this.fragmentMarkerFromShred(shred);
            TextRange rangeInsideHost = shred.getRangeInsideHost();
            if (shred.getHost() == null) {
                Void void_ = this.failAndReport("host should not be null", null, null);
                throw null;
            }
            RangeMarker origMarker = this.myHostDocument.createRangeMarker(rangeInsideHost.shiftRight(host.getTextRange().getStartOffset()));
            SmartPsiElementPointer elementPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)host);
            result2.add(new MarkersMapping(origMarker, rangeMarker, (SmartPsiElementPointer<PsiLanguageInjectionHost>)elementPointer));
            origMarker.setGreedyToRight(true);
            rangeMarker.setGreedyToRight(true);
            if (origMarker.getStartOffset() > curOffset) {
                origMarker.setGreedyToLeft(true);
                rangeMarker.setGreedyToLeft(true);
            }
            curOffset = origMarker.getEndOffset();
        }
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValid() {
        MarkersMapping it;
        if (!this.myInjectedFile.isValid()) return false;
        Iterable $this$all$iv = this.markers;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (MarkersMapping)element$iv;
            boolean bl = false;
        } while (it.isValid());
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void commitToOriginal(@NotNull DocumentEvent e) {
        void $this$groupByTo$iv;
        String text = this.myFragmentDocument.getText();
        Iterable iterable = this.markers;
        Map destination$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv : $this$groupByTo$iv) {
            Object object;
            MarkersMapping it = (MarkersMapping)element$iv;
            boolean bl = false;
            PsiLanguageInjectionHost key$iv = it.getHost();
            Map $this$getOrPut$iv$iv = destination$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
            if (value$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                object = answer$iv$iv;
            } else {
                object = value$iv$iv;
            }
            List list$iv = (List)object;
            list$iv.add(element$iv);
        }
        LinkedHashMap map2 = (LinkedHashMap)destination$iv;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        documentManager.commitDocument(this.myHostDocument);
        int localInsideFileCursor = 0;
        for (PsiLanguageInjectionHost host : map2.keySet()) {
            if (host == null) continue;
            String hostText = host.getText();
            ProperTextRange insideHost = null;
            StringBuilder sb = new StringBuilder();
            List $i$f$getOrPut = (List)map2.get(host);
            boolean value$iv$iv = false;
            List list2 = $i$f$getOrPut;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            for (MarkersMapping markersMapping : list2) {
                void hostMarker;
                $i$f$getOrPut = markersMapping.component1();
                RangeMarker fragmentMarker = markersMapping.component2();
                int hostOffset = host.getTextRange().getStartOffset();
                ProperTextRange localInsideHost = new ProperTextRange(hostMarker.getStartOffset() - hostOffset, hostMarker.getEndOffset() - hostOffset);
                int n = fragmentMarker.getStartOffset();
                boolean bl = false;
                ProperTextRange localInsideFile = new ProperTextRange(Math.max(localInsideFileCursor, n), fragmentMarker.getEndOffset());
                if (insideHost != null) {
                    sb.append(hostText, insideHost.getEndOffset(), localInsideHost.getStartOffset());
                }
                if (localInsideFile.getEndOffset() <= text.length() && !localInsideFile.isEmpty()) {
                    sb.append(localInsideFile.substring(text));
                }
                localInsideFileCursor = localInsideFile.getEndOffset();
                ProperTextRange properTextRange = insideHost;
                if (properTextRange == null || (properTextRange = properTextRange.union((TextRange)localInsideHost)) == null) {
                    properTextRange = localInsideHost;
                }
                insideHost = properTextRange;
            }
            if (insideHost == null) {
                Void void_ = CommonInjectedFileChangesHandler.failAndReport$default(this, "insideHost is null", e, null, 4, null);
                throw null;
            }
            this.updateInjectionHostElement(host, insideHost, sb.toString());
            documentManager.commitDocument(this.myHostDocument);
        }
    }

    protected final void updateInjectionHostElement(@NotNull PsiLanguageInjectionHost host, @NotNull ProperTextRange insideHost, @NotNull String content2) {
        ElementManipulators.handleContentChange((PsiElement)((PsiElement)host), (TextRange)((TextRange)insideHost), (String)content2);
    }

    @Override
    public void dispose() {
        Iterable $this$forEach$iv = this.markers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MarkersMapping p1 = (MarkersMapping)element$iv;
            boolean bl = false;
            p1.dispose();
        }
        this.markers.clear();
        super.dispose();
    }

    public boolean handlesRange(@NotNull TextRange range2) {
        if (this.markers.isEmpty()) {
            return false;
        }
        TextRange hostRange = TextRange.create((int)this.markers.get(0).getHostMarker().getStartOffset(), (int)this.markers.get(this.markers.size() - 1).getHostMarker().getEndOffset());
        return range2.intersects(hostRange);
    }

    @NotNull
    protected final RangeMarker fragmentMarkerFromShred(@NotNull PsiLanguageInjectionHost.Shred shred) {
        PsiLanguageInjectionHost.Shred $this$innerRange$iv = shred;
        boolean $i$f$getInnerRange = false;
        return this.myFragmentDocument.createRangeMarker(TextRange.create((int)($this$innerRange$iv.getRange().getStartOffset() + $this$innerRange$iv.getPrefix().length()), (int)($this$innerRange$iv.getRange().getEndOffset() - $this$innerRange$iv.getSuffix().length())));
    }

    @NotNull
    protected final Void failAndReport(@NotNull String message, @Nullable DocumentEvent e, @Nullable Exception exception) {
        throw (Throwable)this.getReportException(message, e, exception);
    }

    public static /* synthetic */ Void failAndReport$default(CommonInjectedFileChangesHandler commonInjectedFileChangesHandler, String string, DocumentEvent documentEvent, Exception exception, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: failAndReport");
        }
        if ((n & 2) != 0) {
            documentEvent = null;
        }
        if ((n & 4) != 0) {
            exception = null;
        }
        return commonInjectedFileChangesHandler.failAndReport(string, documentEvent, exception);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final RuntimeExceptionWithAttachments getReportException(@NotNull String message, @Nullable DocumentEvent e, @Nullable Exception exception) {
        Attachment attachment;
        String string = this.getClass().getSimpleName() + ": " + message + " (event = " + e + ")," + " myInjectedFile.isValid = " + this.myInjectedFile.isValid() + ", isValid = " + this.isValid();
        Object[] objectArray = new Attachment[4];
        objectArray[0] = new Attachment("hosts", CollectionsKt.joinToString$default((Iterable)this.markers, (CharSequence)"\n\n", null, null, (int)0, null, (Function1)getReportException.1.INSTANCE, (int)30, null));
        objectArray[1] = new Attachment("markers", this.logMarkersRanges(this.markers));
        objectArray[2] = new Attachment("injected document", this.myFragmentDocument.getText());
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = objectArray;
        int n = 3;
        Exception exception2 = exception;
        if (exception2 != null) {
            void it;
            Exception exception3 = exception2;
            boolean bl = false;
            boolean bl2 = false;
            Exception exception4 = exception3;
            int n2 = n;
            Object[] objectArray4 = objectArray2;
            Object[] objectArray5 = objectArray3;
            String string2 = string;
            boolean bl3 = false;
            Attachment attachment2 = new Attachment("exception", (Throwable)it);
            string = string2;
            objectArray3 = objectArray5;
            objectArray2 = objectArray4;
            n = n2;
            attachment = attachment2;
        } else {
            attachment = null;
        }
        objectArray2[n] = attachment;
        Collection $this$toTypedArray$iv = CollectionsKt.listOfNotNull((Object[])objectArray3);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Attachment[] attachmentArray = thisCollection$iv.toArray(new Attachment[0]);
        if (attachmentArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Attachment[] attachmentArray2 = Arrays.copyOf(attachmentArray, attachmentArray.length);
        String string3 = string;
        return new RuntimeExceptionWithAttachments(string3, attachmentArray2);
    }

    @NotNull
    protected final String logMarkersRanges(@NotNull List<MarkersMapping> $this$logMarkersRanges) {
        return CollectionsKt.joinToString$default((Iterable)$this$logMarkersRanges, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<MarkersMapping, CharSequence>(this){
            final /* synthetic */ CommonInjectedFileChangesHandler this$0;

            @NotNull
            public final CharSequence invoke(@NotNull MarkersMapping mm) {
                Segment $this$range$iv = (Segment)mm.getHostMarker();
                boolean $i$f$getRange = false;
                return "fragment:" + this.this$0.logMarker(this.this$0.myFragmentDocument, mm.getFragmentRange()) + " host:" + this.this$0.logHostMarker(TextRange.create((Segment)$this$range$iv));
            }
            {
                this.this$0 = commonInjectedFileChangesHandler;
                super(1);
            }
        }), (int)30, null);
    }

    @NotNull
    protected final String logHostMarker(@Nullable TextRange rangeInHost) {
        return this.logMarker(this.myHostDocument, rangeInHost);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final String logMarker(@NotNull Document $this$logMarker, @Nullable TextRange rangeInHost) {
        String string;
        StringBuilder stringBuilder = new StringBuilder().append(rangeInHost).append(" -> '");
        TextRange textRange = rangeInHost;
        if (textRange != null) {
            String string2;
            TextRange textRange2 = textRange;
            boolean bl = false;
            boolean bl2 = false;
            TextRange textRange3 = textRange2;
            StringBuilder stringBuilder2 = stringBuilder;
            boolean bl3 = false;
            try {
                void it;
                string2 = $this$logMarker.getText((TextRange)it);
            }
            catch (IndexOutOfBoundsException e) {
                string2 = e.toString();
            }
            String string3 = string2;
            stringBuilder = stringBuilder2;
            string = string3;
        } else {
            string = null;
        }
        return stringBuilder.append(string).append('\'').toString();
    }

    @NotNull
    protected final String substringVerbose(@NotNull String $this$substringVerbose, int start2, int cursor) {
        String string;
        try {
            string = $this$substringVerbose;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(start2, cursor);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string3;
        }
        catch (StringIndexOutOfBoundsException e) {
            Void void_ = CommonInjectedFileChangesHandler.failAndReport$default(this, "can't get substring (" + start2 + ", " + cursor + ") of '" + $this$substringVerbose + "'[" + $this$substringVerbose.length() + ']', null, e, 2, null);
            throw null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<MarkersMapping, String>> distributeTextToMarkers(@NotNull List<MarkersMapping> affectedMarkers, @NotNull TextRange affectedRange, int limit) {
        void $this$mapTo$iv$iv;
        int cursor = 0;
        Iterable $this$map$iv = (Iterable)CollectionsKt.getIndices((Collection)affectedMarkers);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String string;
            void i2;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            MarkersMapping marker = affectedMarkers.get((int)i2);
            RangeMarker fragmentMarker = marker.getFragmentMarker();
            if (fragmentMarker.isValid()) {
                int n2;
                int n3 = cursor;
                int n4 = fragmentMarker.getStartOffset();
                int n5 = 0;
                int start2 = Math.max(n3, n4);
                String text = fragmentMarker.getDocument().getText();
                if (CommonInjectedFileChangesHandlerKt.access$affectedLength(marker, affectedRange) == 0 && CommonInjectedFileChangesHandlerKt.access$affectedLength((MarkersMapping)CollectionsKt.getOrNull(affectedMarkers, (int)(i2 + true)), affectedRange) > 1) {
                    Object object = CollectionsKt.getOrNull(affectedMarkers, (int)(i2 + true));
                    if (object == null) {
                        Intrinsics.throwNpe();
                    }
                    n2 = ((MarkersMapping)object).getFragmentMarker().getStartOffset();
                } else {
                    n4 = text.length();
                    n5 = fragmentMarker.getEndOffset();
                    int n6 = limit;
                    boolean bl2 = false;
                    n5 = Math.max(n5, n6);
                    n6 = 0;
                    n2 = Math.min(n4, n5);
                }
                cursor = n2;
                string = this.substringVerbose(text, start2, cursor);
            } else {
                string = "";
            }
            Pair pair = TuplesKt.to((Object)marker, (Object)string);
            collection.add(pair);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public CommonInjectedFileChangesHandler(@NotNull List<? extends PsiLanguageInjectionHost.Shred> shreds, @NotNull Editor hostEditor, @NotNull Document fragmentDocument, @NotNull PsiFile injectedFile) {
        super(hostEditor, fragmentDocument, injectedFile);
        void $this$apply;
        LinkedList linkedList = new LinkedList();
        boolean bl = false;
        boolean bl2 = false;
        LinkedList linkedList2 = linkedList;
        CommonInjectedFileChangesHandler commonInjectedFileChangesHandler = this;
        boolean bl3 = false;
        $this$apply.addAll((Collection)this.getMarkersFromShreds(shreds));
        Unit unit = Unit.INSTANCE;
        commonInjectedFileChangesHandler.markers = linkedList;
    }
}

