/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.DocumentWindowImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class SingleRootInjectedFileViewProvider
extends SingleRootFileViewProvider
implements InjectedFileViewProvider {
    static final ThreadLocal<Boolean> disabledTemporarily = ThreadLocal.withInitial(() -> false);
    static Key<Language> LANGUAGE_FOR_INJECTED_COPY_KEY = Key.create((String)"LANGUAGE_FOR_INJECTED_COPY_KEY");
    private final Object myLock = new Object();
    private final DocumentWindowImpl myDocumentWindow;
    private boolean myPatchingLeaves;

    SingleRootInjectedFileViewProvider(@NotNull PsiManager psiManager, @NotNull VirtualFileWindow virtualFile, @NotNull DocumentWindowImpl documentWindow, @NotNull Language language) {
        super(psiManager, (VirtualFile)virtualFile, true, language);
        this.myDocumentWindow = documentWindow;
    }

    @Override
    public Object getLock() {
        return this.myLock;
    }

    @Override
    public boolean getPatchingLeaves() {
        return this.myPatchingLeaves;
    }

    @Override
    public FileViewProvider clone() {
        return this.cloneImpl();
    }

    @Override
    public void rootChanged(@NotNull PsiFile psiFile) {
        super.rootChanged(psiFile);
        this.rootChangedImpl(psiFile);
    }

    @Override
    public boolean isEventSystemEnabled() {
        return this.isEventSystemEnabledImpl();
    }

    @Override
    public boolean isPhysical() {
        return this.isPhysicalImpl();
    }

    @Override
    @NotNull
    public DocumentWindowImpl getDocument() {
        return this.myDocumentWindow;
    }

    @Override
    @NonNls
    public String toString() {
        return "Single root injected file '" + this.getVirtualFile().getName() + "' " + (this.isValid() ? "" : " invalid") + (this.isPhysical() ? "" : " nonphysical");
    }

    public void doNotInterruptMeWhileImPatchingLeaves(@NotNull Runnable runnable2) {
        this.myPatchingLeaves = true;
        try {
            runnable2.run();
        }
        finally {
            this.myPatchingLeaves = false;
        }
    }
}

