/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.diagnostic.PluginException;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.StaticGetter;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementTypeBase;
import com.intellij.reference.SoftReference;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyParseableElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance(LazyParseableElement.class);
    private static final StaticGetter<CharSequence> NO_TEXT = new StaticGetter(null);
    private final ReentrantLock myLock = new ReentrantLock();
    @NotNull
    private volatile Getter<CharSequence> myText;
    private volatile boolean myParsed;
    private static boolean ourParsingAllowed = true;

    public LazyParseableElement(@NotNull IElementType type, @Nullable CharSequence text) {
        super(type);
        LazyParseableElement.waitForLock(this.myLock);
        try {
            if (text == null) {
                this.myParsed = true;
                this.myText = NO_TEXT;
            } else {
                this.myText = new StaticGetter((Object)ImmutableCharSequence.asImmutable((CharSequence)text));
                this.setCachedLength(text.length());
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        LazyParseableElement.waitForLock(this.myLock);
        try {
            if (this.myParsed) {
                this.myText = NO_TEXT;
            } else {
                this.setCachedLength(((CharSequence)this.myText.get()).length());
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    @Override
    @NotNull
    public String getText() {
        CharSequence text = this.myText();
        if (text != null) {
            return text.toString();
        }
        String s = super.getText();
        this.myText = new SoftReference((Object)s);
        return s;
    }

    @Override
    @NotNull
    public CharSequence getChars() {
        CharSequence text = this.myText();
        if (text == null) {
            text = super.getText();
            this.myText = new SoftReference((Object)text);
        }
        return text;
    }

    @Override
    public int getTextLength() {
        CharSequence text = this.myText();
        if (text != null) {
            return text.length();
        }
        return super.getTextLength();
    }

    @Override
    public int hc() {
        CharSequence text = this.myText();
        return text == null ? super.hc() : LeafElement.leafHC(text);
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start2) {
        CharSequence text = this.myText();
        if (text != null) {
            return LeafElement.leafTextMatches(text, buffer, start2);
        }
        return super.textMatches(buffer, start2);
    }

    public boolean isParsed() {
        return this.myParsed;
    }

    private CharSequence myText() {
        return (CharSequence)this.myText.get();
    }

    @Override
    final void setFirstChildNode(TreeElement child2) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setFirstChildNode(child2);
    }

    @Override
    final void setLastChildNode(TreeElement child2) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setLastChildNode(child2);
    }

    private void ensureParsed() {
        if (!ourParsingAllowed) {
            LOG.error("Parsing not allowed!!!");
        }
        if (this.myParsed) {
            return;
        }
        LazyParseableElement.waitForLock(this.myLock);
        try {
            if (this.myParsed) {
                return;
            }
            CharSequence text = (CharSequence)this.myText.get();
            assert (text != null);
            FileElement fileElement = TreeUtil.getFileElement(this);
            if (fileElement == null) {
                LOG.error("Chameleons must not be parsed till they're in file tree: " + this);
            } else {
                fileElement.assertReadAccessAllowed();
            }
            if (this.rawFirstChild() != null) {
                LOG.error("Reentrant parsing?");
            }
            DebugUtil.performPsiModification("lazy-parsing", () -> {
                TreeElement parsedNode = (TreeElement)((ILazyParseableElementTypeBase)this.getElementType()).parseContents((ASTNode)this);
                this.assertTextLengthIntact(text, parsedNode);
                if (parsedNode != null) {
                    this.setChildren(parsedNode);
                }
                this.myParsed = true;
                this.myText = new SoftReference((Object)text);
            });
        }
        finally {
            this.myLock.unlock();
        }
    }

    private void assertTextLengthIntact(CharSequence text, TreeElement child2) {
        int length = 0;
        while (child2 != null) {
            length += child2.getTextLength();
            child2 = child2.getTreeNext();
        }
        if (length != text.length()) {
            LOG.error("Text mismatch in " + LogUtil.objectAndClass((Object)this.getElementType()), (Throwable)PluginException.createByClass((String)"Text mismatch", null, this.getElementType().getClass()), new Attachment[]{new Attachment("code.txt", text.toString())});
        }
    }

    private void setChildren(@NotNull TreeElement parsedNode) {
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            try {
                TreeElement last = LazyParseableElement.rawSetParents(parsedNode, this);
                super.setFirstChildNode(parsedNode);
                super.setLastChildNode(last);
            }
            catch (Throwable e) {
                LOG.error("Chameleon expansion may not be interrupted by exceptions", e);
            }
        });
    }

    @Override
    public void rawAddChildrenWithoutNotifications(@NotNull TreeElement first) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon " + this.getClass());
        }
        super.rawAddChildrenWithoutNotifications(first);
    }

    @Override
    public TreeElement getFirstChildNode() {
        this.ensureParsed();
        return super.getFirstChildNode();
    }

    @Override
    public TreeElement getLastChildNode() {
        this.ensureParsed();
        return super.getLastChildNode();
    }

    public int copyTo(char @Nullable [] buffer, int start2) {
        CharSequence text = this.myText();
        if (text == null) {
            return -1;
        }
        if (buffer != null) {
            CharArrayUtil.getChars((CharSequence)text, (char[])buffer, (int)start2);
        }
        return start2 + text.length();
    }

    public static void setParsingAllowed(boolean allowed) {
        ourParsingAllowed = allowed;
    }

    private static void waitForLock(@NotNull ReentrantLock ml) {
        while (true) {
            try {
                if (ml.tryLock(10L, TimeUnit.MILLISECONDS)) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ProgressManager.checkCanceled();
        }
    }
}

