/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.model.search.impl.InjectionInfo;
import com.intellij.model.search.impl.LanguageInfo;
import com.intellij.model.search.impl.QueryRequest;
import com.intellij.model.search.impl.QueryResult;
import com.intellij.model.search.impl.RequestsKt;
import com.intellij.model.search.impl.ValueResult;
import com.intellij.model.search.impl.WordRequest;
import com.intellij.model.search.impl.XResult;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.search.HelperKt;
import com.intellij.psi.impl.search.LayerResult;
import com.intellij.psi.impl.search.LeafOccurrence;
import com.intellij.psi.impl.search.MyBulkOccurrenceProcessor;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.impl.search.RequestAndProcessors;
import com.intellij.psi.impl.search.RequestProcessors;
import com.intellij.psi.impl.search.WordRequestInfo;
import com.intellij.psi.impl.search.WordRequestInfoImpl;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchSession;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.text.StringSearcher;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\t0\b\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\b\u00a2\u0006\u0002\u0010\fJ$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\b2\u0014\u0010\u0011\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u0012H\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\bH\u0002J\u0016\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\bH\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\u001e\u0010\u001b\u001a\u00020\u00152\u0014\u0010\u0011\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u0012H\u0002J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0012J\u0018\u0010\u001e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001f0\u00122\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J*\u0010 \u001a\u0016\u0012\u0004\u0012\u00020\"\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u001f0\u00120!2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\bH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/psi/impl/search/Layer;", "T", "", "project", "Lcom/intellij/openapi/project/Project;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "queryRequests", "", "Lcom/intellij/model/search/impl/QueryRequest;", "wordRequests", "Lcom/intellij/model/search/impl/WordRequest;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/util/Collection;Ljava/util/Collection;)V", "myHelper", "Lcom/intellij/psi/impl/search/PsiSearchHelperImpl;", "distributeWordRequests", "Lcom/intellij/psi/impl/search/RequestAndProcessors;", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/model/search/impl/XResult;", "processGlobalRequests", "", "globals", "processLocalRequests", "locals", "processSingleRequest", "requestAndProcessors", "processWordRequests", "runLayer", "Lcom/intellij/psi/impl/search/LayerResult;", "scopeProcessor", "Lcom/intellij/psi/PsiElement;", "scopeProcessors", "", "Lcom/intellij/psi/impl/search/WordRequestInfo;", "intellij.platform.indexing.impl"})
final class Layer<T> {
    private final PsiSearchHelperImpl myHelper;
    private final Project project;
    private final ProgressIndicator progress;
    private final Collection<QueryRequest<?, T>> queryRequests;
    private final Collection<WordRequest<T>> wordRequests;

    @NotNull
    public final LayerResult<T> runLayer(@NotNull Processor<? super T> processor2) {
        List subQueries = Collections.synchronizedList(new ArrayList());
        Processor xProcessor2 = new Processor<XResult<? extends T>>(processor2, subQueries){
            final /* synthetic */ Processor $processor;
            final /* synthetic */ List $subQueries;

            public final boolean process(XResult<? extends T> result2) {
                boolean bl;
                XResult<? extends T> xResult = result2;
                if (xResult instanceof ValueResult) {
                    bl = this.$processor.process(((ValueResult)result2).getValue());
                } else if (xResult instanceof QueryResult) {
                    this.$subQueries.add(((QueryResult)result2).getQuery());
                    bl = true;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return bl;
            }
            {
                this.$processor = processor2;
                this.$subQueries = list2;
            }
        };
        if (!HelperKt.access$processQueryRequests(this.progress, this.queryRequests, xProcessor2)) {
            return LayerResult.Stop.INSTANCE;
        }
        if (!this.processWordRequests(xProcessor2)) {
            return LayerResult.Stop.INSTANCE;
        }
        return new LayerResult.Ok(subQueries);
    }

    private final boolean processWordRequests(Processor<? super XResult<? extends T>> processor2) {
        if (this.wordRequests.isEmpty()) {
            return true;
        }
        Collection<RequestAndProcessors> allRequests = this.distributeWordRequests(processor2);
        SmartList globals = new SmartList();
        SmartList locals = new SmartList();
        for (RequestAndProcessors requestAndProcessor : allRequests) {
            boolean bl;
            Collection collection;
            if (requestAndProcessor.getRequest().getSearchScope() instanceof LocalSearchScope) {
                collection = (Collection)locals;
                bl = false;
                collection.add(requestAndProcessor);
                continue;
            }
            collection = (Collection)globals;
            bl = false;
            collection.add(requestAndProcessor);
        }
        return this.processGlobalRequests((Collection)globals) && this.processLocalRequests((Collection)locals);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<RequestAndProcessors> distributeWordRequests(Processor<? super XResult<? extends T>> processor2) {
        void $this$mapTo$iv$iv;
        boolean bl;
        Function1<LeafOccurrence, Boolean> function1;
        Object answer$iv;
        Map byRequest;
        LinkedHashMap theMap = new LinkedHashMap();
        for (WordRequest<T> wordRequest : this.wordRequests) {
            Collection collection;
            Object object;
            void $this$getOrPut$iv;
            this.progress.checkCanceled();
            Map map2 = theMap;
            WordRequestInfoImpl key$iv = wordRequest.getSearchWordRequest();
            boolean $i$f$getOrPut2 = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                Pair answer$iv2 = new Pair((Object)new SmartList(), new LinkedHashMap());
                $this$getOrPut$iv.put(key$iv, answer$iv2);
                object = answer$iv2;
            } else {
                object = value$iv;
            }
            byRequest = (Pair)object;
            Object injectionInfo = wordRequest.getInjectionInfo();
            if (Intrinsics.areEqual((Object)injectionInfo, (Object)InjectionInfo.NoInjection.INSTANCE)) {
                collection = (Collection)byRequest.getFirst();
            } else if (injectionInfo instanceof InjectionInfo.InInjection) {
                Object object2;
                void $this$getOrPut$iv2;
                Map $i$f$getOrPut2 = (Map)byRequest.getSecond();
                LanguageInfo key$iv2 = ((InjectionInfo.InInjection)injectionInfo).getLanguageInfo();
                boolean $i$f$getOrPut3 = false;
                Object value$iv2 = $this$getOrPut$iv2.get(key$iv2);
                if (value$iv2 == null) {
                    boolean bl3 = false;
                    answer$iv = (Collection)new SmartList();
                    $this$getOrPut$iv2.put(key$iv2, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv2;
                }
                collection = (Collection)object2;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Collection occurrenceProcessors = collection;
            injectionInfo = occurrenceProcessors;
            function1 = RequestsKt.occurrenceProcessor(wordRequest, processor2);
            bl = false;
            injectionInfo.add(function1);
        }
        Map $this$map$iv = theMap;
        boolean $i$f$map = false;
        byRequest = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        function1 = $this$mapTo$iv$iv;
        bl = false;
        for (Map.Entry item$iv$iv : function1.entrySet()) {
            void hostProcessors;
            void wordRequest;
            void $dstr$wordRequest$byRequest;
            answer$iv = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            Collection collection2 = $dstr$wordRequest$byRequest;
            boolean bl5 = false;
            WordRequestInfo wordRequestInfo = (WordRequestInfo)collection2.getKey();
            collection2 = $dstr$wordRequest$byRequest;
            bl5 = false;
            Pair byRequest2 = (Pair)collection2.getValue();
            this.progress.checkCanceled();
            Pair pair = byRequest2;
            collection2 = (Collection)pair.component1();
            Map injectionProcessors = (Map)pair.component2();
            RequestAndProcessors requestAndProcessors = new RequestAndProcessors((WordRequestInfo)wordRequest, new RequestProcessors((Collection<? extends Function1<? super LeafOccurrence, Boolean>>)hostProcessors, injectionProcessors));
            collection.add(requestAndProcessors);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean processGlobalRequests(Collection<RequestAndProcessors> globals) {
        void $this$groupByTo$iv$iv;
        if (globals.isEmpty()) {
            return true;
        }
        if (globals.size() == 1) {
            return this.processSingleRequest((RequestAndProcessors)CollectionsKt.first((Iterable)globals));
        }
        Iterable $this$groupBy$iv = globals;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            RequestAndProcessors $dstr$request$_u24__u24 = (RequestAndProcessors)element$iv$iv;
            boolean bl = false;
            WordRequestInfo request2 = $dstr$request$_u24__u24.component1();
            Set key$iv$iv = CollectionsKt.toSet((Iterable)PsiSearchHelperImpl.getWordEntries(request2.getWord(), request2.isCaseSensitive()));
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            $dstr$request$_u24__u24 = (RequestAndProcessors)element$iv$iv;
            List list2 = list$iv$iv;
            boolean bl3 = false;
            request2 = $dstr$request$_u24__u24.component1();
            this.progress.checkCanceled();
            WordRequestInfo wordRequestInfo = request2;
            list2.add(wordRequestInfo);
        }
        Map globalsIds = destination$iv$iv;
        return this.myHelper.processGlobalRequests(globalsIds, this.progress, this.scopeProcessors(globals));
    }

    private final Map<WordRequestInfo, Processor<? super PsiElement>> scopeProcessors(Collection<RequestAndProcessors> globals) {
        THashMap result2 = new THashMap();
        for (RequestAndProcessors requestAndProcessors : globals) {
            this.progress.checkCanceled();
            ((Map)result2).put(requestAndProcessors.getRequest(), this.scopeProcessor(requestAndProcessors));
        }
        return (Map)result2;
    }

    /*
     * WARNING - void declaration
     */
    private final Processor<? super PsiElement> scopeProcessor(RequestAndProcessors requestAndProcessors) {
        void request2;
        RequestAndProcessors requestAndProcessors2 = requestAndProcessors;
        WordRequestInfo wordRequestInfo = requestAndProcessors2.component1();
        RequestProcessors processors = requestAndProcessors2.component2();
        StringSearcher searcher = new StringSearcher(request2.getWord(), request2.isCaseSensitive(), true, false);
        MyBulkOccurrenceProcessor adapted = new MyBulkOccurrenceProcessor(this.project, processors);
        return PsiSearchHelperImpl.localProcessor(searcher, adapted);
    }

    private final boolean processLocalRequests(Collection<RequestAndProcessors> locals) {
        if (locals.isEmpty()) {
            return true;
        }
        for (RequestAndProcessors requestAndProcessors : locals) {
            this.progress.checkCanceled();
            if (this.processSingleRequest(requestAndProcessors)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean processSingleRequest(RequestAndProcessors requestAndProcessors) {
        void request2;
        RequestAndProcessors requestAndProcessors2 = requestAndProcessors;
        WordRequestInfo wordRequestInfo = requestAndProcessors2.component1();
        RequestProcessors processors = requestAndProcessors2.component2();
        EnumSet<Enum> options2 = EnumSet.of((Enum)PsiSearchHelperImpl.Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE);
        if (request2.isCaseSensitive()) {
            options2.add(PsiSearchHelperImpl.Options.CASE_SENSITIVE_SEARCH);
        }
        return this.myHelper.bulkProcessElementsWithWord(request2.getSearchScope(), request2.getWord(), request2.getSearchContext(), options2, request2.getContainerName(), new SearchSession(), new MyBulkOccurrenceProcessor(this.project, processors));
    }

    public Layer(@NotNull Project project, @NotNull ProgressIndicator progress2, @NotNull Collection<? extends QueryRequest<?, ? extends T>> queryRequests, @NotNull Collection<? extends WordRequest<? extends T>> wordRequests) {
        this.project = project;
        this.progress = progress2;
        this.queryRequests = queryRequests;
        this.wordRequests = wordRequests;
        PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)this.project);
        if (psiSearchHelper == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.search.PsiSearchHelperImpl");
        }
        this.myHelper = (PsiSearchHelperImpl)psiSearchHelper;
    }
}

