/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.messages.MessageBus;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiModificationTrackerImpl
implements PsiModificationTracker,
PsiTreeChangePreprocessor {
    private final SimpleModificationTracker myModificationCount = new SimpleModificationTracker();
    private final SimpleModificationTracker myAllLanguagesTracker = new SimpleModificationTracker();
    private final Map<Language, SimpleModificationTracker> myLanguageTrackers = ConcurrentFactoryMap.createWeakMap(language -> new SimpleModificationTracker());
    private final PsiModificationTracker.Listener myPublisher;

    public PsiModificationTrackerImpl(@NotNull Project project) {
        MessageBus bus = project.getMessageBus();
        this.myPublisher = (PsiModificationTracker.Listener)bus.syncPublisher(TOPIC);
        bus.connect().subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                PsiModificationTrackerImpl.this.doIncCounter();
            }

            public void exitDumbMode() {
                PsiModificationTrackerImpl.this.doIncCounter();
            }
        });
    }

    private void doIncCounter() {
        ApplicationManager.getApplication().runWriteAction(() -> this.incCounter());
    }

    public void incCounter() {
        this.incCountersInner();
    }

    public void incOutOfCodeBlockModificationCounter() {
        this.incCountersInner();
    }

    private void fireEvent() {
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        this.myPublisher.modificationCountChanged();
    }

    private void incCountersInner() {
        this.myModificationCount.incModificationCount();
        this.fireEvent();
    }

    @Override
    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (!PsiModificationTrackerImpl.canAffectPsi(event)) {
            return;
        }
        this.incLanguageCounters(event);
        this.incCountersInner();
    }

    public static boolean canAffectPsi(@NotNull PsiTreeChangeEventImpl event) {
        PsiTreeChangeEventImpl.PsiEventType code = event.getCode();
        return code != PsiTreeChangeEventImpl.PsiEventType.BEFORE_PROPERTY_CHANGE && (code != PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED || event.getPropertyName() != "writable");
    }

    private void incLanguageCounters(@NotNull PsiTreeChangeEventImpl event) {
        PsiTreeChangeEventImpl.PsiEventType code = event.getCode();
        String propertyName = event.getPropertyName();
        if (code == PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED && (propertyName == "propUnloadedPsi" || propertyName == "roots" || propertyName == "propFileTypes") || code == PsiTreeChangeEventImpl.PsiEventType.CHILD_REMOVED && event.getChild() instanceof PsiDirectory) {
            this.myAllLanguagesTracker.incModificationCount();
            return;
        }
        PsiElement[] elements2 = new PsiElement[]{event.getFile(), event.getParent(), event.getOldParent(), event.getNewParent(), event.getElement(), event.getChild(), event.getOldChild(), event.getNewChild()};
        this.incLanguageModificationCount(Language.ANY);
        for (PsiElement o : elements2) {
            if (o == null || o instanceof PsiDirectory) continue;
            if (o instanceof PsiFile) {
                for (Language language : ((PsiFile)o).getViewProvider().getLanguages()) {
                    this.incLanguageModificationCount(language);
                }
                continue;
            }
            try {
                Language language;
                IElementType type = PsiUtilCore.getElementType((PsiElement)o);
                language = type != null ? type.getLanguage() : o.getLanguage();
                this.incLanguageModificationCount(language);
            }
            catch (PsiInvalidElementAccessException e) {
                PsiDocumentManagerBase.LOG.warn((Throwable)e);
            }
        }
    }

    public long getModificationCount() {
        return this.myModificationCount.getModificationCount();
    }

    public long getOutOfCodeBlockModificationCount() {
        return this.myModificationCount.getModificationCount();
    }

    public long getJavaStructureModificationCount() {
        return this.myModificationCount.getModificationCount();
    }

    @NotNull
    public ModificationTracker getOutOfCodeBlockModificationTracker() {
        return this.myModificationCount;
    }

    @NotNull
    public ModificationTracker getJavaStructureModificationTracker() {
        return this.myModificationCount;
    }

    @ApiStatus.Experimental
    public void incLanguageModificationCount(@Nullable Language language) {
        if (language == null) {
            return;
        }
        this.myLanguageTrackers.get(language).incModificationCount();
    }

    @ApiStatus.Experimental
    @NotNull
    public ModificationTracker forLanguage(@NotNull Language language) {
        SimpleModificationTracker languageTracker = this.myLanguageTrackers.get(language);
        return () -> languageTracker.getModificationCount() + this.myAllLanguagesTracker.getModificationCount();
    }

    @ApiStatus.Experimental
    @NotNull
    public ModificationTracker forLanguages(@NotNull Condition<? super Language> condition) {
        return () -> {
            long result2 = this.myAllLanguagesTracker.getModificationCount();
            for (Language l : this.myLanguageTrackers.keySet()) {
                if (!condition.value((Object)l)) continue;
                result2 += this.myLanguageTrackers.get(l).getModificationCount();
            }
            return result2;
        };
    }
}

