/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategyFactory;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormattingDocumentModelImpl
implements FormattingDocumentModel {
    private final WhiteSpaceFormattingStrategy myWhiteSpaceStrategy;
    @NotNull
    private final Document myDocument;
    @NotNull
    private final PsiFile myFile;
    private static final Logger LOG = Logger.getInstance(FormattingDocumentModelImpl.class);
    private final CodeStyleSettings mySettings;

    public FormattingDocumentModelImpl(@NotNull Document document, @NotNull PsiFile file2) {
        this.myDocument = document;
        this.myFile = file2;
        Language language = file2.getLanguage();
        this.myWhiteSpaceStrategy = WhiteSpaceFormattingStrategyFactory.getStrategy(language);
        this.mySettings = CodeStyle.getSettings((PsiFile)file2);
    }

    public static FormattingDocumentModelImpl createOn(@NotNull PsiFile file2) {
        Document document = FormattingDocumentModelImpl.getDocumentToBeUsedFor(file2);
        if (document != null) {
            FormattingDocumentModelImpl.checkDocument(file2, document);
            return new FormattingDocumentModelImpl(document, file2);
        }
        return new FormattingDocumentModelImpl(new DocumentImpl(file2.getViewProvider().getContents(), true), file2);
    }

    private static void checkDocument(@NotNull PsiFile file2, @NotNull Document document) {
        if (file2.getTextLength() != document.getTextLength()) {
            LOG.error(DebugUtil.diagnosePsiDocumentInconsistency((PsiElement)file2, document));
        }
    }

    @Nullable
    public static Document getDocumentToBeUsedFor(PsiFile file2) {
        Project project = file2.getProject();
        if (!file2.isPhysical()) {
            return FormattingDocumentModelImpl.getDocumentForNonPhysicalFile(file2);
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
        if (document != null) {
            if (PsiDocumentManager.getInstance((Project)project).isUncommited(document)) {
                return null;
            }
            PsiToDocumentSynchronizer synchronizer = ((PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project)).getSynchronizer();
            if (synchronizer.isDocumentAffectedByTransactions(document)) {
                return null;
            }
        }
        return document;
    }

    @NotNull
    private static Document getDocumentForNonPhysicalFile(PsiFile file2) {
        Document document = file2.getViewProvider().getDocument();
        if (document != null && document.getTextLength() == file2.getTextLength()) {
            return document;
        }
        return new DocumentImpl(file2.getText(), true);
    }

    public int getLineNumber(int offset) {
        if (offset > this.myDocument.getTextLength()) {
            LOG.error(String.format("Invalid offset detected (%d). Document length: %d. Target file: %s", offset, this.myDocument.getTextLength(), this.myFile));
        }
        return this.myDocument.getLineNumber(offset);
    }

    public int getLineStartOffset(int line) {
        return this.myDocument.getLineStartOffset(line);
    }

    public CharSequence getText(TextRange textRange) {
        if (textRange.getStartOffset() < 0 || textRange.getEndOffset() > this.myDocument.getTextLength()) {
            LOG.error(String.format("Please submit a ticket to the tracker and attach current source file to it!%nInvalid processing detected: given text range (%s) targets non-existing regions (the boundaries are [0; %d)). File's language: %s", textRange, this.myDocument.getTextLength(), this.myFile.getLanguage()));
        }
        return this.myDocument.getCharsSequence().subSequence(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public int getTextLength() {
        return this.myDocument.getTextLength();
    }

    @NotNull
    public Document getDocument() {
        return this.myDocument;
    }

    @NotNull
    public PsiFile getFile() {
        return this.myFile;
    }

    public boolean containsWhiteSpaceSymbolsOnly(int startOffset, int endOffset) {
        Language injectedLanguage;
        if (this.myWhiteSpaceStrategy.check(this.myDocument.getCharsSequence(), startOffset, endOffset) >= endOffset) {
            return true;
        }
        PsiElement injectedElement = InjectedLanguageUtil.findElementAtNoCommit(this.myFile, startOffset);
        if (injectedElement != null && !(injectedLanguage = injectedElement.getLanguage()).equals(this.myFile.getLanguage())) {
            WhiteSpaceFormattingStrategy localStrategy = WhiteSpaceFormattingStrategyFactory.getStrategy(injectedLanguage);
            String unescapedText = InjectedLanguageUtil.getUnescapedLeafText(injectedElement, true);
            if (unescapedText != null) {
                return localStrategy.check(unescapedText, 0, unescapedText.length()) >= unescapedText.length();
            }
            return localStrategy.check(this.myDocument.getCharsSequence(), startOffset, endOffset) >= endOffset;
        }
        return false;
    }

    @NotNull
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, int startOffset, int endOffset, ASTNode nodeAfter, boolean changedViaPsi) {
        if (!changedViaPsi) {
            return this.myWhiteSpaceStrategy.adjustWhiteSpaceIfNecessary(whiteSpaceText, this.myDocument.getCharsSequence(), startOffset, endOffset, this.mySettings, nodeAfter);
        }
        PsiElement element2 = this.myFile.findElementAt(startOffset);
        if (element2 == null) {
            return whiteSpaceText;
        }
        return this.myWhiteSpaceStrategy.adjustWhiteSpaceIfNecessary(whiteSpaceText, element2, startOffset, endOffset, this.mySettings);
    }

    public static boolean canUseDocumentModel(@NotNull Document document, @NotNull PsiFile file2) {
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)file2.getProject());
        return !psiDocumentManager.isUncommited(document) && !psiDocumentManager.isDocumentBlockedByPsi(document) && file2.getText().equals(document.getText());
    }
}

