/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.ui;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.extractor.values.Value;
import com.intellij.psi.codeStyle.presentation.CodeStyleSelectSettingPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleSettingPresentation;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSettingsNameProvider
implements CodeStyleSettingsCustomizable {
    protected Map<LanguageCodeStyleSettingsProvider.SettingsType, Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>> mySettings = new HashMap<LanguageCodeStyleSettingsProvider.SettingsType, Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>>();
    private final Map<LanguageCodeStyleSettingsProvider.SettingsType, Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>> standardSettings = new HashMap<LanguageCodeStyleSettingsProvider.SettingsType, Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>>();

    public CodeStyleSettingsNameProvider() {
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            this.standardSettings.put(settingsType, CodeStyleSettingPresentation.getStandardSettings((LanguageCodeStyleSettingsProvider.SettingsType)settingsType));
        }
    }

    protected void addSetting(@NotNull CodeStyleSettingPresentation.SettingsGroup group, @NotNull CodeStyleSettingPresentation setting, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, @Nullable String anchorFieldName) {
        for (Map.Entry<LanguageCodeStyleSettingsProvider.SettingsType, Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>> entry : this.mySettings.entrySet()) {
            if (!entry.getValue().containsKey(group)) continue;
            this.addSetting(entry.getKey(), group, setting, anchor2, anchorFieldName);
            return;
        }
        this.addSetting(LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC, group, setting, anchor2, anchorFieldName);
    }

    protected void addSetting(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType, @NotNull CodeStyleSettingPresentation.SettingsGroup group, @NotNull CodeStyleSettingPresentation setting, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, @Nullable String anchorFieldName) {
        List<CodeStyleSettingPresentation> settingsList;
        Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> groups = this.mySettings.get(settingsType);
        if (groups == null) {
            groups = new LinkedHashMap<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>();
        }
        if ((settingsList = groups.get(group)) == null) {
            settingsList = new LinkedList<CodeStyleSettingPresentation>();
        }
        if (settingsList.contains(setting)) {
            return;
        }
        if (anchor2 != null && anchorFieldName != null) {
            CodeStyleSettingPresentation anchorSettingRepresentation = new CodeStyleSettingPresentation(anchorFieldName, anchorFieldName);
            int insertIndex = settingsList.indexOf(anchorSettingRepresentation);
            if (insertIndex < 0) {
                insertIndex = settingsList.size();
            } else {
                switch (anchor2) {
                    case BEFORE: {
                        break;
                    }
                    case AFTER: {
                        ++insertIndex;
                        break;
                    }
                    case NONE: {
                        insertIndex = settingsList.size();
                    }
                }
            }
            settingsList.add(insertIndex, setting);
        } else {
            settingsList.add(setting);
        }
        groups.put(group, settingsList);
    }

    public void showAllStandardOptions() {
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> standardGroups = this.standardSettings.get(settingsType);
            for (Map.Entry<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> entry : standardGroups.entrySet()) {
                for (CodeStyleSettingPresentation setting : entry.getValue()) {
                    this.addSetting(settingsType, entry.getKey(), setting, null, null);
                }
            }
        }
    }

    public void showStandardOptions(String ... optionNames) {
        List<String> options2 = Arrays.asList(optionNames);
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> standardGroups = this.standardSettings.get(settingsType);
            for (Map.Entry<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> entry : standardGroups.entrySet()) {
                for (CodeStyleSettingPresentation setting : entry.getValue()) {
                    if (!options2.contains(setting.getFieldName())) continue;
                    this.addSetting(settingsType, entry.getKey(), setting, null, null);
                }
            }
        }
    }

    public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, @NotNull String fieldName, @NotNull String title, @Nullable String groupName, Object ... options2) {
        this.showCustomOption(settingsClass, fieldName, title, groupName, null, null, options2);
    }

    public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, @NotNull String fieldName, @NotNull String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, @Nullable String anchorFieldName, Object ... options2) {
        if (options2.length == 2) {
            this.addSetting(new CodeStyleSettingPresentation.SettingsGroup(groupName), (CodeStyleSettingPresentation)new CodeStyleSelectSettingPresentation(fieldName, title, (int[])options2[1], (String[])options2[0]), anchor2, anchorFieldName);
        } else {
            this.addSetting(new CodeStyleSettingPresentation.SettingsGroup(groupName), new CodeStyleSettingPresentation(fieldName, title), anchor2, anchorFieldName);
        }
    }

    public void renameStandardOption(String fieldName, String newTitle) {
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> standardGroups = this.mySettings.get(settingsType);
            if (standardGroups == null) continue;
            for (Map.Entry<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> entry : standardGroups.entrySet()) {
                for (CodeStyleSettingPresentation setting : entry.getValue()) {
                    if (!setting.getFieldName().equals(fieldName)) continue;
                    setting.setUiName(newTitle);
                    return;
                }
            }
        }
    }

    public void moveStandardOption(String fieldName, String newGroup) {
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> standardGroups = this.mySettings.get(settingsType);
            if (standardGroups == null) {
                standardGroups = new LinkedHashMap<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>();
                this.mySettings.put(settingsType, standardGroups);
            }
            for (Map.Entry<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> entry : standardGroups.entrySet()) {
                CodeStyleSettingPresentation moveSetting = null;
                for (CodeStyleSettingPresentation setting : entry.getValue()) {
                    if (!setting.getFieldName().equals(fieldName)) continue;
                    moveSetting = setting;
                    break;
                }
                if (moveSetting == null) continue;
                entry.getValue().remove(moveSetting);
                this.addSetting(new CodeStyleSettingPresentation.SettingsGroup(newGroup), moveSetting, null, null);
            }
        }
    }

    public static String getSettingsTypeName(LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        switch (settingsType) {
            case BLANK_LINES_SETTINGS: {
                return ApplicationBundle.message((String)"title.blank.lines", (Object[])new Object[0]);
            }
            case SPACING_SETTINGS: {
                return ApplicationBundle.message((String)"title.spaces", (Object[])new Object[0]);
            }
            case WRAPPING_AND_BRACES_SETTINGS: {
                return ApplicationBundle.message((String)"wrapping.and.braces", (Object[])new Object[0]);
            }
            case INDENT_SETTINGS: {
                return ApplicationBundle.message((String)"title.tabs.and.indents", (Object[])new Object[0]);
            }
            case LANGUAGE_SPECIFIC: {
                return "Language-specific";
            }
        }
        throw new IllegalArgumentException("Unknown settings type: " + settingsType);
    }

    public void addSettings(LanguageCodeStyleSettingsProvider provider) {
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            provider.customizeSettings((CodeStyleSettingsCustomizable)this, settingsType);
        }
    }

    public static Value getValue(CodeStyleSettingPresentation representation, List<? extends Value> values2) {
        Value myValue = (Value)ContainerUtil.find(values2, value2 -> value2.state == Value.STATE.SELECTED && value2.name.equals(representation.getFieldName()));
        return myValue;
    }

    public String getSettings(List<? extends Value> values2) {
        StringBuilder builder2 = new StringBuilder();
        for (LanguageCodeStyleSettingsProvider.SettingsType settingsType : LanguageCodeStyleSettingsProvider.SettingsType.values()) {
            builder2.append("<br><b><u>").append(CodeStyleSettingsNameProvider.getSettingsTypeName(settingsType)).append("</u></b>");
            Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> groups = this.mySettings.get(settingsType);
            if (groups == null) continue;
            for (Map.Entry<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> entry : groups.entrySet()) {
                boolean firstSettingGroupTop = entry.getKey().isNull();
                boolean groupReported = false;
                for (CodeStyleSettingPresentation setting : entry.getValue()) {
                    Value myValue = (Value)ContainerUtil.find(values2, value2 -> value2.state == Value.STATE.SELECTED && value2.name.equals(setting.getFieldName()));
                    if (myValue == null) continue;
                    if (!groupReported) {
                        if (firstSettingGroupTop) {
                            builder2.append("<b>");
                        } else {
                            builder2.append("<br><b>").append(entry.getKey().name).append("</b>");
                        }
                    }
                    builder2.append("<br>");
                    String postNameSign = setting.getUiName().endsWith(":") ? " " : ": ";
                    builder2.append(setting.getUiName()).append(postNameSign).append(setting.getValueUiName(myValue.value));
                    if (!groupReported && firstSettingGroupTop) {
                        builder2.append("</b>");
                    }
                    groupReported = true;
                }
            }
        }
        return builder2.toString();
    }
}

