/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.engine;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementCallback;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementMoveInfo;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RestoreFoldArrangementCallback
implements ArrangementCallback {
    @NotNull
    private final Editor myEditor;

    public RestoreFoldArrangementCallback(@NotNull Editor editor) {
        this.myEditor = editor;
    }

    @Override
    public void afterArrangement(@NotNull List<ArrangementMoveInfo> moveInfos) {
        Project project = this.myEditor.getProject();
        if (project != null) {
            FoldRegion[] regions = this.myEditor.getFoldingModel().getAllFoldRegions();
            ArrayList<FoldRegionInfo> foldRegionsInfo = new ArrayList<FoldRegionInfo>();
            for (FoldRegion region : regions) {
                FoldRegionInfo info = new FoldRegionInfo(region.getStartOffset(), region.getEndOffset(), region.isExpanded());
                foldRegionsInfo.add(info);
            }
            CodeFoldingManager foldingManager = CodeFoldingManager.getInstance(project);
            foldingManager.updateFoldRegions(this.myEditor);
            this.myEditor.getFoldingModel().runBatchFoldingOperation(() -> {
                for (FoldRegionInfo info : foldRegionsInfo) {
                    FoldRegion foldRegion = foldingManager.findFoldRegion(this.myEditor, info.myStart, info.myEnd);
                    if (foldRegion == null) continue;
                    foldRegion.setExpanded(info.myIsExpanded);
                }
            });
        }
    }

    private static class FoldRegionInfo {
        private final int myStart;
        private final int myEnd;
        private final boolean myIsExpanded;

        private FoldRegionInfo(int start2, int end, boolean expanded) {
            this.myStart = start2;
            this.myEnd = end;
            this.myIsExpanded = expanded;
        }
    }
}

