/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.engine;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementEntryWrapper<E extends ArrangementEntry> {
    @NotNull
    private final List<ArrangementEntryWrapper<E>> myChildren = new ArrayList<ArrangementEntryWrapper<E>>();
    @NotNull
    private final E myEntry;
    @Nullable
    private ArrangementEntryWrapper<E> myParent;
    @Nullable
    private ArrangementEntryWrapper<E> myPrevious;
    @Nullable
    private ArrangementEntryWrapper<E> myNext;
    private int myStartOffset;
    private int myEndOffset;
    private int myBlankLinesBefore;

    public ArrangementEntryWrapper(@NotNull E entry) {
        this.myEntry = entry;
        this.myStartOffset = entry.getStartOffset();
        this.myEndOffset = entry.getEndOffset();
        ArrangementEntryWrapper<ArrangementEntry> previous = null;
        for (ArrangementEntry child2 : entry.getChildren()) {
            ArrangementEntryWrapper<ArrangementEntry> childWrapper = new ArrangementEntryWrapper<ArrangementEntry>(child2);
            childWrapper.setParent(this);
            if (previous != null) {
                previous.setNext(childWrapper);
                childWrapper.setPrevious(previous);
            }
            previous = childWrapper;
            this.myChildren.add(childWrapper);
        }
    }

    @NotNull
    public E getEntry() {
        return this.myEntry;
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    public void setEndOffset(int endOffset) {
        this.myEndOffset = endOffset;
    }

    @Nullable
    public ArrangementEntryWrapper<E> getParent() {
        return this.myParent;
    }

    public void setParent(@Nullable ArrangementEntryWrapper<E> parent) {
        this.myParent = parent;
    }

    @Nullable
    public ArrangementEntryWrapper<E> getPrevious() {
        return this.myPrevious;
    }

    public void setPrevious(@Nullable ArrangementEntryWrapper<E> previous) {
        this.myPrevious = previous;
    }

    @Nullable
    public ArrangementEntryWrapper<E> getNext() {
        return this.myNext;
    }

    public int getBlankLinesBefore() {
        return this.myBlankLinesBefore;
    }

    public void updateBlankLines(@NotNull Document document) {
        this.myBlankLinesBefore = 0;
        int lineFeeds = 0;
        CharSequence text = document.getCharsSequence();
        int current2 = this.getStartOffset() - 1;
        while (current2 >= 0 && (current2 = CharArrayUtil.shiftBackward((CharSequence)text, (int)current2, (String)" \t")) > 0 && text.charAt(current2) == '\n') {
            ++lineFeeds;
            --current2;
        }
        if (lineFeeds > 0) {
            this.myBlankLinesBefore = lineFeeds - 1;
        }
    }

    public void setNext(@Nullable ArrangementEntryWrapper<E> next) {
        this.myNext = next;
    }

    @NotNull
    public List<ArrangementEntryWrapper<E>> getChildren() {
        return this.myChildren;
    }

    public void applyShift(int shift) {
        this.myStartOffset += shift;
        this.myEndOffset += shift;
        for (ArrangementEntryWrapper<E> child2 : this.myChildren) {
            child2.applyShift(shift);
        }
    }

    public int hashCode() {
        return this.myEntry.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrangementEntryWrapper wrapper2 = (ArrangementEntryWrapper)o;
        return this.myEntry.equals(wrapper2.myEntry);
    }

    public String toString() {
        return String.format("range: [%d; %d), entry: %s", this.myStartOffset, this.myEndOffset, this.myEntry.toString());
    }
}

