/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SmartStripTrailingSpacesFilter;
import com.intellij.openapi.editor.StripTrailingSpacesFilter;
import com.intellij.openapi.editor.StripTrailingSpacesFilterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeepTrailingSpacesOnEmptyLinesFilterFactory
extends StripTrailingSpacesFilterFactory {
    @NotNull
    public StripTrailingSpacesFilter createFilter(@Nullable Project project, @NotNull Document document) {
        if (project != null && KeepTrailingSpacesOnEmptyLinesFilterFactory.shouldKeepTrailingSpacesOnEmptyLines(project, document)) {
            return new KeepTrailingSpacesOnEmptyLinesFilter(document);
        }
        return StripTrailingSpacesFilter.ALL_LINES;
    }

    private static boolean shouldKeepTrailingSpacesOnEmptyLines(@NotNull Project project, @NotNull Document document) {
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(document);
        if (file2 != null) {
            CommonCodeStyleSettings settings = CodeStyle.getLanguageSettings((PsiFile)file2);
            CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions();
            return indentOptions != null && indentOptions.KEEP_INDENTS_ON_EMPTY_LINES;
        }
        return false;
    }

    private static class KeepTrailingSpacesOnEmptyLinesFilter
    extends SmartStripTrailingSpacesFilter {
        @NotNull
        private final Document myDocument;

        KeepTrailingSpacesOnEmptyLinesFilter(@NotNull Document document) {
            this.myDocument = document;
        }

        public int getTrailingSpacesToLeave(int line) {
            int startOffset = this.myDocument.getLineStartOffset(line);
            int endOffset = this.myDocument.getLineEndOffset(line);
            return KeepTrailingSpacesOnEmptyLinesFilter.containsWhitespacesOnly(this.myDocument.getCharsSequence(), startOffset, endOffset) ? this.getMaxIndentChars(line) : 0;
        }

        private static boolean containsWhitespacesOnly(@NotNull CharSequence chars, int start2, int end) {
            for (int i2 = start2; i2 < end; ++i2) {
                char c = chars.charAt(i2);
                if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
                return false;
            }
            return true;
        }

        private int getMaxIndentChars(int line) {
            int lineAfter;
            int lineBefore = this.getNonEmptyLineBefore(line);
            int indentCharCount = -1;
            if (lineBefore >= 0) {
                indentCharCount = this.countIndentCharsAt(lineBefore);
            }
            if ((lineAfter = this.getNonEmptyLineAfter(line)) >= 0) {
                indentCharCount = Math.max(indentCharCount, this.countIndentCharsAt(lineAfter));
            }
            return indentCharCount;
        }

        private int getNonEmptyLineBefore(int line) {
            CharSequence docChars = this.myDocument.getCharsSequence();
            for (int lineBefore = line - 1; lineBefore >= 0; --lineBefore) {
                if (KeepTrailingSpacesOnEmptyLinesFilter.containsWhitespacesOnly(docChars, this.myDocument.getLineStartOffset(lineBefore), this.myDocument.getLineEndOffset(lineBefore))) continue;
                return lineBefore;
            }
            return -1;
        }

        private int getNonEmptyLineAfter(int line) {
            CharSequence docChars = this.myDocument.getCharsSequence();
            for (int lineAfter = line + 1; lineAfter < this.myDocument.getLineCount(); ++lineAfter) {
                if (KeepTrailingSpacesOnEmptyLinesFilter.containsWhitespacesOnly(docChars, this.myDocument.getLineStartOffset(lineAfter), this.myDocument.getLineEndOffset(lineAfter))) continue;
                return lineAfter;
            }
            return -1;
        }

        private int countIndentCharsAt(int line) {
            char c;
            int count = 0;
            CharSequence docChars = this.myDocument.getCharsSequence();
            for (int offset = this.myDocument.getLineStartOffset(line); offset < this.myDocument.getTextLength() && ((c = docChars.charAt(offset)) == ' ' || c == '\t'); ++offset) {
                ++count;
            }
            return count;
        }
    }
}

