/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.TimeStampedIndentOptions;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsAdjuster;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsDetectorImpl;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

class DetectAndAdjustIndentOptionsTask {
    private static final ExecutorService BOUNDED_EXECUTOR = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"DetectableIndentOptionsProvider Pool");
    private static final Logger LOG = Logger.getInstance(DetectAndAdjustIndentOptionsTask.class);
    private static final int INDENT_COMPUTATION_TIMEOUT = 5000;
    private final Document myDocument;
    private final Project myProject;
    private final TimeStampedIndentOptions myOptionsToAdjust;

    DetectAndAdjustIndentOptionsTask(@NotNull Project project, @NotNull Document document, @NotNull TimeStampedIndentOptions toAdjust) {
        this.myProject = project;
        this.myDocument = document;
        this.myOptionsToAdjust = toAdjust;
    }

    private PsiFile getFile() {
        return PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
    }

    @NotNull
    private Runnable calcIndentAdjuster(@NotNull ProgressIndicator indicator) {
        PsiFile file2 = this.getFile();
        IndentOptionsAdjuster adjuster = file2 == null ? null : new IndentOptionsDetectorImpl(file2, indicator).getIndentOptionsAdjuster();
        return adjuster != null ? () -> this.adjustOptions(adjuster) : EmptyRunnable.INSTANCE;
    }

    private void adjustOptions(IndentOptionsAdjuster adjuster) {
        PsiFile file2 = this.getFile();
        if (file2 == null) {
            return;
        }
        TimeStampedIndentOptions currentDefault = DetectAndAdjustIndentOptionsTask.getDefaultIndentOptions(file2, this.myDocument);
        this.myOptionsToAdjust.copyFrom(currentDefault);
        adjuster.adjust((CommonCodeStyleSettings.IndentOptions)this.myOptionsToAdjust);
        this.myOptionsToAdjust.setTimeStamp(this.myDocument.getModificationStamp());
        this.myOptionsToAdjust.setOriginalIndentOptionsHash(currentDefault.hashCode());
        if (!currentDefault.equals((Object)this.myOptionsToAdjust)) {
            this.myOptionsToAdjust.setDetected(true);
            this.myOptionsToAdjust.setOverrideLanguageOptions(true);
            CodeStyleSettingsManager.getInstance((Project)this.myProject).fireCodeStyleSettingsChanged(file2);
        }
    }

    private void logTooLongComputation() {
        PsiFile file2 = this.getFile();
        String fileName = file2 != null ? file2.getName() : "";
        LOG.debug("Indent detection is too long for: " + fileName);
    }

    void scheduleInBackgroundForCommittedDocument() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
            this.calcIndentAdjuster((ProgressIndicator)new DumbProgressIndicator()).run();
        } else {
            ReadAction.nonBlocking(() -> {
                Runnable indentAdjuster = (Runnable)ProgressIndicatorUtils.withTimeout(5000L, () -> this.calcIndentAdjuster(Objects.requireNonNull(ProgressIndicatorProvider.getGlobalProgressIndicator())));
                if (indentAdjuster == null) {
                    this.logTooLongComputation();
                    return EmptyRunnable.INSTANCE;
                }
                return indentAdjuster;
            }).finishOnUiThread(ModalityState.defaultModalityState(), Runnable::run).withDocumentsCommitted(this.myProject).submit((Executor)BOUNDED_EXECUTOR);
        }
    }

    @NotNull
    static TimeStampedIndentOptions getDefaultIndentOptions(@NotNull PsiFile file2, @NotNull Document document) {
        FileType fileType = file2.getFileType();
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)file2);
        return new TimeStampedIndentOptions(settings.getIndentOptions(fileType), document.getModificationStamp());
    }
}

