/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.inspectionsTree;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.profile.codeInspection.ui.ScopeOrderComparator;
import com.intellij.ui.JBColor;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MultiScopeSeverityIcon
implements Icon {
    private final LinkedHashMap<String, HighlightDisplayLevel> myScopeToAverageSeverityMap;
    private final String myDefaultScopeName;

    MultiScopeSeverityIcon(@NotNull Map<String, HighlightSeverity> scopeToAverageSeverityMap, String defaultScopeName, @NotNull InspectionProfileImpl inspectionProfile) {
        this.myDefaultScopeName = defaultScopeName;
        ArrayList<String> sortedScopeNames = new ArrayList<String>(scopeToAverageSeverityMap.keySet());
        this.myScopeToAverageSeverityMap = new LinkedHashMap();
        sortedScopeNames.sort(new ScopeOrderComparator(inspectionProfile));
        sortedScopeNames.remove(defaultScopeName);
        sortedScopeNames.add(defaultScopeName);
        for (String scopeName : sortedScopeNames) {
            HighlightDisplayLevel level;
            HighlightSeverity severity = scopeToAverageSeverityMap.get(scopeName);
            if (severity == null || (level = HighlightDisplayLevel.find((HighlightSeverity)severity)) == null) continue;
            this.myScopeToAverageSeverityMap.put(scopeName, level);
        }
    }

    private static JBColor getMixedSeverityColor() {
        return JBColor.DARK_GRAY;
    }

    public String getDefaultScopeName() {
        return this.myDefaultScopeName;
    }

    public LinkedHashMap<String, HighlightDisplayLevel> getScopeToAverageSeverityMap() {
        return this.myScopeToAverageSeverityMap;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int i2, int j) {
        int partWidth = this.getIconWidth() / this.myScopeToAverageSeverityMap.size();
        Collection<HighlightDisplayLevel> values2 = this.myScopeToAverageSeverityMap.values();
        int idx = 0;
        for (HighlightDisplayLevel level : values2) {
            Icon icon2 = level.getIcon();
            g.setColor(icon2 instanceof HighlightDisplayLevel.ColoredIcon ? ((HighlightDisplayLevel.ColoredIcon)icon2).getColor() : MultiScopeSeverityIcon.getMixedSeverityColor());
            int x = i2 + partWidth * idx;
            g.fillRect(x, j, partWidth, this.getIconHeight());
            ++idx;
        }
    }

    @Override
    public int getIconWidth() {
        return HighlightDisplayLevel.getEmptyIconDim();
    }

    @Override
    public int getIconHeight() {
        return HighlightDisplayLevel.getEmptyIconDim();
    }
}

