/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.scopeChooser.ScopeChooserConfigurable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.profile.codeInspection.ui.ScopeOrderComparator;
import com.intellij.psi.search.scope.NonProjectFilesScope;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopesOrderDialog
extends DialogWrapper {
    private final JList<String> myOptionsList = new JBList();
    private final InspectionProfileImpl myInspectionProfile;
    @NotNull
    private final Project myProject;
    private final JPanel myPanel;
    private final MyModel myModel;

    ScopesOrderDialog(@NotNull Component parent, @NotNull InspectionProfileImpl inspectionProfile, final @NotNull Project project) {
        super(parent, true);
        this.myInspectionProfile = inspectionProfile;
        this.myProject = project;
        this.myModel = new MyModel();
        this.reloadScopeList();
        this.myOptionsList.setModel(this.myModel);
        this.myOptionsList.setSelectedIndex(0);
        JPanel listPanel = ToolbarDecorator.createDecorator(this.myOptionsList).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                ListUtil.moveSelectedItemsDown((JList)ScopesOrderDialog.this.myOptionsList);
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                ListUtil.moveSelectedItemsUp((JList)ScopesOrderDialog.this.myOptionsList);
            }
        }).addExtraAction(new AnActionButton(CodeInsightBundle.messagePointer((String)"action.AnActionButton.text.edit.scopes", (Object[])new Object[0]), AllIcons.Actions.Edit){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new ScopeChooserConfigurable(project));
                ScopesOrderDialog.this.reloadScopeList();
            }
        }).disableRemoveAction().disableAddAction().createPanel();
        JLabel descr = new JLabel(AnalysisBundle.message((String)"inspections.settings.scopes.order.help.label", (Object[])new Object[0]));
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)descr);
        this.myPanel = new JPanel();
        this.myPanel.setLayout(new BorderLayout());
        this.myPanel.add((Component)listPanel, "Center");
        this.myPanel.add((Component)descr, "South");
        this.init();
        this.setTitle(AnalysisBundle.message((String)"inspections.settings.scopes.order.title", (Object[])new Object[0]));
    }

    private void reloadScopeList() {
        this.myModel.removeAllElements();
        ArrayList<String> scopes = new ArrayList<String>();
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders((Project)this.myProject)) {
            for (NamedScope scope : holder.getScopes()) {
                if (scope instanceof NonProjectFilesScope) continue;
                scopes.add(scope.getName());
            }
        }
        scopes.remove(CustomScopesProviderEx.getAllScope().getName());
        scopes.sort(new ScopeOrderComparator(this.myInspectionProfile));
        for (String scopeName : scopes) {
            this.myModel.addElement(scopeName);
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void doOKAction() {
        int size = this.myOptionsList.getModel().getSize();
        Object[] newScopeOrder = new String[size];
        for (int i2 = 0; i2 < size; ++i2) {
            String scopeName = this.myOptionsList.getModel().getElementAt(i2);
            newScopeOrder[i2] = scopeName;
        }
        if (!Arrays.equals(newScopeOrder, this.myInspectionProfile.getScopesOrder())) {
            this.myInspectionProfile.setScopesOrder((String[])newScopeOrder);
        }
        super.doOKAction();
    }

    private static class MyModel
    extends DefaultListModel<String>
    implements EditableModel {
        private MyModel() {
        }

        public void addRow() {
            throw new UnsupportedOperationException();
        }

        public void exchangeRows(int oldIndex, int newIndex) {
            String scope1 = (String)this.getElementAt(newIndex);
            this.set(newIndex, this.getElementAt(oldIndex));
            this.set(oldIndex, scope1);
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return true;
        }

        public void removeRow(int idx) {
            throw new UnsupportedOperationException();
        }
    }
}

