/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.util.PlatformUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class PlatformProjectViewOpener
implements DirectoryProjectConfigurator {
    PlatformProjectViewOpener() {
        if (PlatformUtils.isPyCharmEducational() || PlatformUtils.isDataGrip()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    @Override
    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean isProjectCreatedWithWizard) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Project");
        if (toolWindow == null) {
            MyListener listener2 = new MyListener(project);
            Disposer.register((Disposable)project, (Disposable)listener2);
            project.getMessageBus().connect((Disposable)listener2).subscribe(ToolWindowManagerListener.TOPIC, (Object)listener2);
        } else {
            StartupManager.getInstance((Project)project).runAfterOpened(() -> PlatformProjectViewOpener.activateProjectToolWindow(project, toolWindow));
        }
    }

    private static void activateProjectToolWindow(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project.isDisposed()) {
                return;
            }
            if (toolWindow.getType() != ToolWindowType.SLIDING) {
                toolWindow.activate(null);
            }
        }, ModalityState.NON_MODAL);
    }

    private static final class MyListener
    implements ToolWindowManagerListener,
    Disposable {
        private final Project myProject;

        MyListener(@NotNull Project project) {
            this.myProject = project;
        }

        @Override
        public void toolWindowsRegistered(@NotNull List<String> id2) {
            if (id2.contains("Project")) {
                Disposer.dispose((Disposable)this);
                PlatformProjectViewOpener.activateProjectToolWindow(this.myProject, ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Project"));
            }
        }

        public void dispose() {
        }
    }
}

