/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.pom.NavigatableWithText;
import com.intellij.psi.PsiFile;
import com.intellij.util.IconUtil;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleNode
extends PackageDependenciesNode
implements NavigatableWithText {
    @NotNull
    private final Module myModule;
    private final ModuleGrouper myModuleGrouper;

    public ModuleNode(@NotNull Module module, @Nullable ModuleGrouper moduleGrouper) {
        super(module.getProject());
        this.myModule = module;
        this.myModuleGrouper = moduleGrouper;
    }

    @Override
    public void fillFiles(Set<? super PsiFile> set, boolean recursively) {
        super.fillFiles(set, recursively);
        int count = this.getChildCount();
        for (int i2 = 0; i2 < count; ++i2) {
            PackageDependenciesNode child2 = (PackageDependenciesNode)this.getChildAt(i2);
            child2.fillFiles(set, true);
        }
    }

    @Override
    public boolean canNavigate() {
        return !this.myModule.isDisposed();
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public void navigate(boolean focus) {
        ProjectSettingsService.getInstance(this.myModule.getProject()).openModuleSettings(this.myModule);
    }

    @Override
    public Icon getIcon() {
        return this.myModule.isDisposed() ? super.getIcon() : this.getModuleIcon();
    }

    private Icon getModuleIcon() {
        Icon icon2 = null;
        VirtualFile virtualFile = this.myModule.getModuleFile();
        if (virtualFile != null) {
            icon2 = IconUtil.getIcon((VirtualFile)virtualFile, (int)0, (Project)this.myModule.getProject());
        }
        if (icon2 == null) {
            icon2 = ModuleType.get((Module)this.myModule).getIcon();
        }
        return icon2;
    }

    @Override
    public String toString() {
        return this.myModuleGrouper != null ? this.myModuleGrouper.getShortenedName(this.myModule) : this.myModule.getName();
    }

    public String getModuleName() {
        return this.myModule.getName();
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @Override
    public int getWeight() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this.isEquals()) {
            return super.equals(o);
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleNode)) {
            return false;
        }
        ModuleNode moduleNode = (ModuleNode)o;
        return Comparing.equal((Object)this.myModule, (Object)moduleNode.myModule);
    }

    public int hashCode() {
        return this.myModule.hashCode();
    }

    @Override
    public boolean isValid() {
        return !this.myModule.isDisposed();
    }

    public String getNavigateActionText(boolean focusEditor) {
        return ActionsBundle.message((String)"action.ModuleSettings.navigate", (Object[])new Object[0]);
    }
}

