/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import gnu.trove.THashSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForwardDependenciesBuilder
extends DependenciesBuilder {
    private final Map<PsiFile, Set<PsiFile>> myDirectDependencies = new HashMap<PsiFile, Set<PsiFile>>();
    private final int myTransitive;
    @Nullable
    private final GlobalSearchScope myTargetScope;
    private Set<VirtualFile> myStarted = new THashSet();

    public ForwardDependenciesBuilder(@NotNull Project project, @NotNull AnalysisScope scope) {
        super(project, scope);
        this.myTransitive = 0;
        this.myTargetScope = null;
    }

    public ForwardDependenciesBuilder(@NotNull Project project, @NotNull AnalysisScope scope, @Nullable GlobalSearchScope targetScope) {
        super(project, scope);
        this.myTargetScope = targetScope;
        this.myTransitive = 0;
    }

    public ForwardDependenciesBuilder(@NotNull Project project, @NotNull AnalysisScope scope, int transitive) {
        super(project, scope);
        this.myTransitive = transitive;
        this.myTargetScope = null;
    }

    @Override
    public String getRootNodeNameInUsageView() {
        return AnalysisBundle.message((String)"forward.dependencies.usage.view.root.node.text", (Object[])new Object[0]);
    }

    @Override
    public String getInitialUsagesPosition() {
        return AnalysisBundle.message((String)"forward.dependencies.usage.view.initial.text", (Object[])new Object[0]);
    }

    @Override
    public boolean isBackward() {
        return false;
    }

    @Override
    public void analyze() {
        final PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        psiManager.startBatchFilesProcessingMode();
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        try {
            this.getScope().acceptIdempotentVisitor((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitFile(@NotNull PsiFile file2) {
                    ForwardDependenciesBuilder.this.visit(file2, fileIndex, psiManager);
                }
            });
        }
        finally {
            psiManager.finishBatchFilesProcessingMode();
        }
    }

    private void visit(@NotNull PsiFile file2, @NotNull ProjectFileIndex fileIndex, @NotNull PsiManager psiManager) {
        FileViewProvider viewProvider = file2.getViewProvider();
        if (viewProvider.getBaseLanguage() != file2.getLanguage()) {
            return;
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        VirtualFile virtualFile = file2.getVirtualFile();
        if (indicator != null) {
            if (indicator.isCanceled()) {
                throw new ProcessCanceledException();
            }
            indicator.setText(AnalysisBundle.message((String)"package.dependencies.progress.text", (Object[])new Object[0]));
            if (virtualFile != null) {
                indicator.setText2(this.getRelativeToProjectPath(virtualFile));
            }
            if (this.myTotalFileCount > 0 && this.myStarted.add(virtualFile)) {
                indicator.setFraction((double)(++this.myFileCount) / (double)this.myTotalFileCount);
            }
        }
        boolean isInLibrary = virtualFile == null || fileIndex.isInLibrary(virtualFile);
        HashSet<Object> collectedDeps = new HashSet<Object>();
        collectedDeps.add(file2);
        int depth = 0;
        HashSet<PsiFile> processed2 = new HashSet<PsiFile>();
        do {
            if (depth++ > this.getTransitiveBorder()) {
                return;
            }
            for (PsiFile psiFile : new HashSet(collectedDeps)) {
                VirtualFile vFile = psiFile.getVirtualFile();
                if (vFile != null) {
                    if (indicator != null) {
                        indicator.setText2(this.getRelativeToProjectPath(vFile));
                    }
                    if (!isInLibrary && fileIndex.isInLibrary(vFile)) {
                        processed2.add(psiFile);
                    }
                }
                if (!processed2.add(psiFile)) continue;
                HashSet found = new HashSet();
                ForwardDependenciesBuilder.analyzeFileDependencies(psiFile, (place, dependency) -> {
                    PsiFile dependencyFile = dependency.getContainingFile();
                    if (dependencyFile != null) {
                        VirtualFile depFile;
                        if (viewProvider == dependencyFile.getViewProvider()) {
                            return;
                        }
                        if (dependencyFile.isPhysical() && (depFile = dependencyFile.getVirtualFile()) != null && (fileIndex.isInContent(depFile) || fileIndex.isInLibrary(depFile)) && (this.myTargetScope == null || this.myTargetScope.contains(depFile))) {
                            PsiElement navigationElement = dependencyFile.getNavigationElement();
                            found.add(navigationElement instanceof PsiFile ? (PsiFile)navigationElement : dependencyFile);
                        }
                    }
                });
                Set deps = this.getDependencies().computeIfAbsent(file2, __ -> new HashSet());
                deps.addAll(found);
                this.getDirectDependencies().put(psiFile, new HashSet(found));
                collectedDeps.addAll(found);
                psiManager.dropResolveCaches();
                InjectedLanguageManager.getInstance((Project)file2.getProject()).dropFileCaches(psiFile);
            }
            collectedDeps.removeAll(processed2);
        } while (this.isTransitive() && !collectedDeps.isEmpty());
    }

    @Override
    @NotNull
    public Map<PsiFile, Set<PsiFile>> getDirectDependencies() {
        return this.myDirectDependencies;
    }

    @Override
    public boolean isTransitive() {
        return this.myTransitive > 0;
    }

    @Override
    public int getTransitiveBorder() {
        return this.myTransitive;
    }
}

