/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.wm.WelcomeScreenTab;
import com.intellij.openapi.wm.WelcomeTabFactory;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractWelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenComponentFactory;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.CardLayoutPanel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBSlidingPanel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedWelcomeScreen
extends AbstractWelcomeScreen {
    private final JBSlidingPanel mySlidingPanel = new JBSlidingPanel();

    TabbedWelcomeScreen() {
        this.mySlidingPanel.add("root", (Component)this);
        this.setBackground(WelcomeScreenUIManager.getMainTabListBackground());
        CardLayoutPanel<WelcomeScreenTab, WelcomeScreenTab, JPanel> centralPanel = TabbedWelcomeScreen.createCardPanel();
        DefaultListModel mainListModel = new DefaultListModel();
        WelcomeTabFactory.WELCOME_TAB_FACTORY_EP.getExtensionList().forEach(it -> mainListModel.addElement(it.createWelcomeTab((Disposable)this)));
        JBList tabList = new JBList(mainListModel);
        tabList.setBackground(WelcomeScreenUIManager.getMainTabListBackground());
        tabList.setBorder((Border)JBUI.Borders.emptyLeft((int)16));
        tabList.setFixedCellHeight(JBUI.scale((int)32));
        tabList.setCellRenderer((ListCellRenderer)new MyCellRenderer());
        tabList.addListSelectionListener(e -> centralPanel.select((WelcomeScreenTab)tabList.getSelectedValue(), true));
        tabList.setSelectedIndex(0);
        JComponent logoComponent = WelcomeScreenComponentFactory.createSmallLogo();
        logoComponent.setBorder((Border)JBUI.Borders.emptyLeft((int)16));
        NonOpaquePanel leftPanel = new NonOpaquePanel();
        leftPanel.add((Component)logoComponent, "North");
        leftPanel.add((Component)tabList, "Center");
        leftPanel.setPreferredSize(new Dimension(JBUI.scale((int)196), leftPanel.getPreferredSize().height));
        this.add((Component)leftPanel, "West");
        this.add(centralPanel, "Center");
    }

    @Override
    @Nullable
    public BalloonLayout getBalloonLayout() {
        return null;
    }

    @NotNull
    private static CardLayoutPanel<WelcomeScreenTab, WelcomeScreenTab, JPanel> createCardPanel() {
        return new CardLayoutPanel<WelcomeScreenTab, WelcomeScreenTab, JPanel>(){

            @Override
            protected WelcomeScreenTab prepare(WelcomeScreenTab key) {
                return key;
            }

            @Override
            protected JPanel create(WelcomeScreenTab screenTab) {
                return JBUI.Panels.simplePanel((Component)screenTab.getAssociatedComponent());
            }
        };
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        return null;
    }

    public JComponent getWelcomePanel() {
        return this.mySlidingPanel;
    }

    public void setupFrame(JFrame frame) {
    }

    public void dispose() {
    }

    public static abstract class DefaultWelcomeScreenTab
    implements WelcomeScreenTab {
        private final JComponent myKeyComponent;
        private JComponent myAssociatedComponent;

        public DefaultWelcomeScreenTab(@NotNull @Nls String tabName) {
            this.myKeyComponent = JBUI.Panels.simplePanel().addToLeft((Component)new JLabel(tabName)).withBackground(WelcomeScreenUIManager.getMainTabListBackground());
        }

        @NotNull
        public JComponent getKeyComponent() {
            return this.myKeyComponent;
        }

        @NotNull
        public JComponent getAssociatedComponent() {
            if (this.myAssociatedComponent == null) {
                this.myAssociatedComponent = this.buildComponent();
            }
            return this.myAssociatedComponent;
        }

        protected abstract JComponent buildComponent();
    }

    private static class MyCellRenderer
    extends CellRendererPane
    implements ListCellRenderer<WelcomeScreenTab> {
        private MyCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends WelcomeScreenTab> list2, WelcomeScreenTab value2, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent keyComponent = value2.getKeyComponent();
            BorderLayoutPanel wrappedPanel = JBUI.Panels.simplePanel((Component)keyComponent);
            UIUtil.setBackgroundRecursively((Component)wrappedPanel, (Color)(isSelected ? UIUtil.getListSelectionBackground((boolean)cellHasFocus) : WelcomeScreenUIManager.getMainTabListBackground()));
            UIUtil.setForegroundRecursively((Component)wrappedPanel, (Color)UIUtil.getListForeground((boolean)isSelected, (boolean)cellHasFocus));
            return wrappedPanel;
        }
    }
}

