/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractActionWithPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.BottomLineBorder;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenColors;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.util.ui.CenteredIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CardActionsPanel
extends JPanel {
    private static final boolean USE_ICONS = true;
    private final JBCardLayout myLayout = new JBCardLayout();
    private final JPanel myContent = new JPanel((LayoutManager)this.myLayout);
    private int nCards = 0;

    public CardActionsPanel(ActionGroup rootGroup) {
        this.setLayout(new GridLayout(1, 1));
        this.add(this.myContent);
        this.createCardForGroup(rootGroup, "root", null);
    }

    private void createCardForGroup(ActionGroup group, String cardId, String parentId) {
        JPanel card = new JPanel(new BorderLayout());
        JPanel withBottomFiller = new JPanel(new BorderLayout());
        withBottomFiller.add((Component)card, "North");
        this.myContent.add((Component)withBottomFiller, cardId);
        List<JComponent> components = this.buildComponents(group, cardId);
        JPanel componentsPanel = new JPanel(new GridLayout(components.size(), 1, JBUI.scale((int)5), JBUI.scale((int)5)));
        componentsPanel.setBorder((Border)new JBEmptyBorder(15, 15, 15, 15));
        for (JComponent component2 : components) {
            componentsPanel.add(component2);
        }
        card.add((Component)componentsPanel, "Center");
        String title = group.getTemplatePresentation().getText();
        card.add((Component)new HeaderPanel(title, parentId), "North");
    }

    private List<JComponent> buildComponents(ActionGroup group, String parentId) {
        AnAction[] actions = group.getChildren(null);
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        PresentationFactory factory2 = new PresentationFactory();
        for (AnAction action2 : actions) {
            Presentation presentation2 = action2.getTemplatePresentation().clone();
            if (action2 instanceof ActionGroup) {
                ActionGroup childGroup = (ActionGroup)action2;
                if (childGroup.isPopup()) {
                    String id2 = String.valueOf(++this.nCards);
                    this.createCardForGroup(childGroup, id2, parentId);
                    components.add(new Button(new ActivateCard(id2), presentation2));
                    continue;
                }
                components.addAll(this.buildComponents(childGroup, parentId));
                continue;
            }
            if (action2 instanceof AbstractActionWithPanel) {
                JPanel panel2 = ((AbstractActionWithPanel)action2).createPanel();
                components.add(panel2);
                continue;
            }
            action2.update(new AnActionEvent(null, DataManager.getInstance().getDataContext((Component)this), "WelcomeScreen", presentation2, ActionManager.getInstance(), 0));
            if (!presentation2.isVisible()) continue;
            components.add(new Button(action2, presentation2));
        }
        return components;
    }

    private class ActivateCard
    extends AnAction {
        private final String myId;

        ActivateCard(String id2) {
            this.myId = id2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            CardActionsPanel.this.myLayout.swipe((Container)CardActionsPanel.this.myContent, this.myId, JBCardLayout.SwipeDirection.FORWARD);
        }
    }

    private static class Button
    extends ActionButtonWithText {
        private static final Icon DEFAULT_ICON = new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor(LightColors.SLIGHTLY_GREEN);
                g.fillRoundRect(x + 4, y + 4, 24, 24, 8, 8);
                g.setColor((Color)JBColor.GRAY);
                g.drawRoundRect(x + 4, y + 4, 24, 24, 8, 8);
            }

            @Override
            public int getIconWidth() {
                return 32;
            }

            @Override
            public int getIconHeight() {
                return 32;
            }
        };

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            AnAction action2 = this.getAction();
            if (action2 instanceof ActivateCard) {
                Rectangle bounds2 = this.getBounds();
                Icon icon2 = AllIcons.Actions.Forward;
                int y = (bounds2.height - icon2.getIconHeight()) / 2;
                int x = bounds2.width - icon2.getIconWidth() - 15;
                if (this.getPopState() == 1) {
                    GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g);
                    g.setColor(WelcomeScreenColors.CAPTION_BACKGROUND);
                    g.fillOval(x - 3, y - 3, icon2.getIconWidth() + 6, icon2.getIconHeight() + 6);
                    g.setColor(WelcomeScreenColors.GROUP_ICON_BORDER_COLOR);
                    g.drawOval(x - 3, y - 3, icon2.getIconWidth() + 6, icon2.getIconHeight() + 6);
                    config2.restore();
                } else {
                    icon2 = IconLoader.getDisabledIcon((Icon)icon2);
                }
                icon2.paintIcon(this, g, x, y);
            }
        }

        Button(AnAction action2, Presentation presentation2) {
            super(action2, Button.wrapIcon(presentation2), "WelcomeScreen", (Dimension)new JBDimension(32, 32));
            this.setBorder((Border)new JBEmptyBorder(3, 3, 3, 3));
            this.setForeground(WelcomeScreenColors.WELCOME_HEADER_FOREGROUND);
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        protected int horizontalTextAlignment() {
            return 2;
        }

        @Override
        protected int iconTextSpace() {
            return JBUI.scale((int)8);
        }

        private static Presentation wrapIcon(Presentation presentation2) {
            Icon original = presentation2.getIcon();
            CenteredIcon centered = new CenteredIcon(original != null ? original : DEFAULT_ICON, JBUI.scale((int)40), JBUI.scale((int)40), false);
            presentation2.setIcon((Icon)centered);
            return presentation2;
        }
    }

    private class HeaderPanel
    extends JPanel {
        private HeaderPanel(String text, final String parentId) {
            super(new BorderLayout(JBUI.scale((int)5), JBUI.scale((int)5)));
            this.setBackground(WelcomeScreenColors.CAPTION_BACKGROUND);
            if (parentId != null) {
                AnAction back = new AnAction(IdeBundle.messagePointer((String)"action.Anonymous.text.back", (Object[])new Object[0]), AllIcons.Actions.Back){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        CardActionsPanel.this.myLayout.swipe((Container)CardActionsPanel.this.myContent, parentId, JBCardLayout.SwipeDirection.BACKWARD);
                    }
                };
                ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ContextToolbar", (ActionGroup)new DefaultActionGroup(new AnAction[]{back}), true);
                JComponent toolbarComponent = toolbar.getComponent();
                toolbarComponent.setOpaque(false);
                this.add((Component)toolbarComponent, "West");
            }
            JLabel title = new JLabel(text);
            title.setHorizontalAlignment(0);
            title.setForeground(WelcomeScreenColors.CAPTION_FOREGROUND);
            this.add((Component)title, "Center");
            this.setBorder(new BottomLineBorder());
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(super.getPreferredSize().width, JBUI.scale((int)28));
        }
    }
}

