/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Deque;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicIntegerArray;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class WriteThreadIndicatorWidgetFactory
implements StatusBarWidgetFactory {
    private static final String ID = "WriteThread";

    @NotNull
    public String getId() {
        return ID;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return UIBundle.message((String)"status.bar.write.thread.widget.name", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project) {
        return ApplicationManager.getApplication().isInternal();
    }

    @NotNull
    public StatusBarWidget createWidget(@NotNull Project project) {
        return new WriteThreadWidget();
    }

    public void disposeWidget(@NotNull StatusBarWidget widget) {
        Disposer.dispose((Disposable)widget);
    }

    public boolean isConfigurable() {
        return ApplicationManager.getApplication().isInternal();
    }

    public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
        return ApplicationManager.getApplication().isInternal();
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    private static class WriteThreadWidget
    implements CustomStatusBarWidget {
        private static final Dimension WIDGET_SIZE = new Dimension(100, 20);
        private final JPanel myComponent = new MyComponent();
        private final Deque<AtomicIntegerArray> myStatsDeque = new LinkedBlockingDeque<AtomicIntegerArray>();
        private volatile AtomicIntegerArray myCurrentStats = new AtomicIntegerArray(4);
        private final javax.swing.Timer myTimer = new javax.swing.Timer(500, e -> {
            this.myStatsDeque.add(this.myCurrentStats);
            while (this.myStatsDeque.size() > WriteThreadWidget.WIDGET_SIZE.width) {
                this.myStatsDeque.pop();
            }
            this.myCurrentStats = new AtomicIntegerArray(4);
            this.myComponent.repaint();
        });
        private final Timer ourTimer2 = new Timer("Write Thread Widget Timer");

        private WriteThreadWidget() {
        }

        public JComponent getComponent() {
            return this.myComponent;
        }

        @NotNull
        public String ID() {
            return WriteThreadIndicatorWidgetFactory.ID;
        }

        public void install(@NotNull StatusBar statusBar) {
            final ApplicationImpl application = (ApplicationImpl)ObjectUtils.tryCast((Object)ApplicationManager.getApplication(), ApplicationImpl.class);
            if (application == null) {
                return;
            }
            this.ourTimer2.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    ThreeState currentValue = application.isCurrentWriteOnEdt();
                    AtomicIntegerArray currentStats = myCurrentStats;
                    currentStats.incrementAndGet(currentValue.ordinal());
                    currentStats.incrementAndGet(3);
                }
            }, 0L, 1L);
            this.myTimer.start();
        }

        public void dispose() {
            this.ourTimer2.cancel();
            this.myTimer.stop();
        }

        private class MyComponent
        extends JPanel {
            private MyComponent() {
            }

            @Override
            public Dimension getPreferredSize() {
                return WIDGET_SIZE;
            }

            @Override
            public Dimension getMinimumSize() {
                return WIDGET_SIZE;
            }

            @Override
            public Dimension getMaximumSize() {
                return WIDGET_SIZE;
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (g instanceof Graphics2D) {
                    Graphics2D g2d = (Graphics2D)g;
                    int offsetx = 0;
                    for (AtomicIntegerArray stats : WriteThreadWidget.this.myStatsDeque) {
                        g2d.setColor((Color)JBColor.GRAY);
                        g2d.fillRect(offsetx, 0, 1, WIDGET_SIZE.height);
                        int sum = stats.get(3);
                        int offsety = 0;
                        if (sum > 0) {
                            g2d.setColor((Color)JBColor.RED);
                            int height = (stats.get(0) * WIDGET_SIZE.height + sum - 1) / sum;
                            g2d.fillRect(offsetx, WIDGET_SIZE.height - offsety - height, 1, height);
                            offsety -= height;
                            g2d.setColor((Color)JBColor.GREEN);
                            height = (stats.get(1) * WIDGET_SIZE.height + sum - 1) / sum;
                            g2d.fillRect(offsetx, WIDGET_SIZE.height - offsety - height, 1, height);
                        }
                        ++offsetx;
                    }
                }
            }
        }
    }
}

