/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.status.InfoAndProgressPanel;
import com.intellij.openapi.wm.impl.status.PresentationModeProgressPanel;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.Gray;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProcessBalloon {
    private final List<InfoAndProgressPanel.MyInlineProgressIndicator> myIndicators = new ArrayList<InfoAndProgressPanel.MyInlineProgressIndicator>();
    private final int myMaxVisible;
    private int myVisible;

    ProcessBalloon(int visibleCount) {
        this.myMaxVisible = visibleCount;
    }

    public void addIndicator(@Nullable JRootPane pane2, @NotNull InfoAndProgressPanel.MyInlineProgressIndicator indicator) {
        if (pane2 != null) {
            this.myIndicators.add(indicator);
            this.show(pane2);
        }
    }

    public void removeIndicator(@Nullable JRootPane pane2, @NotNull InfoAndProgressPanel.MyInlineProgressIndicator indicator) {
        this.myIndicators.remove(indicator);
        if (indicator.myPresentationModeProgressPanel != null) {
            --this.myVisible;
            if (pane2 != null && !this.myIndicators.isEmpty()) {
                this.show(pane2);
            }
        }
    }

    private void show(final @NotNull JRootPane pane2) {
        ArrayList<InfoAndProgressPanel.MyInlineProgressIndicator> indicators = new ArrayList<InfoAndProgressPanel.MyInlineProgressIndicator>();
        for (final InfoAndProgressPanel.MyInlineProgressIndicator indicator : this.myIndicators) {
            if (indicator.myPresentationModeProgressPanel == null) {
                if (this.myVisible == this.myMaxVisible) continue;
                ++this.myVisible;
                indicator.myPresentationModeProgressPanel = new PresentationModeProgressPanel(indicator);
                indicator.updateProgressNow();
                indicator.myPresentationModeBalloon = ProcessBalloon.create(pane2, indicator, indicator.myPresentationModeProgressPanel.getProgressPanel());
                indicator.myPresentationModeShowBalloon = true;
                indicators.add(indicator);
                continue;
            }
            if (indicator.myPresentationModeBalloon.isDisposed()) continue;
            indicators.add(indicator);
        }
        for (final InfoAndProgressPanel.MyInlineProgressIndicator indicator : indicators) {
            if (indicator.myPresentationModeShowBalloon) {
                indicator.myPresentationModeShowBalloon = false;
                indicator.myPresentationModeBalloon.show((PositionTracker)new PositionTracker<Balloon>(ProcessBalloon.getAnchor(pane2)){

                    public RelativePoint recalculateLocation(Balloon balloon) {
                        Component component2;
                        Component c = ProcessBalloon.getAnchor(pane2);
                        int y = c.getHeight() - JBUIScale.scale((int)45);
                        BalloonLayoutImpl balloonLayout = ProcessBalloon.getBalloonLayout(pane2);
                        if (balloonLayout != null && !ProcessBalloon.isBottomSideToolWindowsVisible(pane2) && (component2 = balloonLayout.getTopBalloonComponent()) != null) {
                            y = SwingUtilities.convertPoint((Component)component2, (int)0, (int)(-JBUIScale.scale((int)45)), (Component)c).y;
                        }
                        if (ProcessBalloon.this.myVisible > 1) {
                            int index = ProcessBalloon.this.myIndicators.indexOf(indicator);
                            int rowHeight = balloon.getPreferredSize().height + JBUI.scale((int)5);
                            y -= rowHeight * (ProcessBalloon.this.myVisible - index - 1);
                        }
                        return new RelativePoint(c, new Point(c.getWidth() - JBUIScale.scale((int)150), y));
                    }
                }, Balloon.Position.above);
                continue;
            }
            indicator.myPresentationModeBalloon.revalidate();
        }
    }

    @NotNull
    private static Balloon create(@NotNull JRootPane pane2, @NotNull Disposable parentDisposable, @NotNull JComponent content2) {
        final Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder(content2).setFadeoutTime(0L).setFillColor(Gray.TRANSPARENT).setShowCallout(false).setBorderColor(Gray.TRANSPARENT).setBorderInsets((Insets)JBUI.emptyInsets()).setAnimationCycle(0).setCloseButtonEnabled(false).setHideOnClickOutside(false).setDisposable(parentDisposable).setHideOnFrameResize(false).setHideOnKeyOutside(false).setBlockClicksThroughBalloon(true).setHideOnAction(false).setShadow(false).createBalloon();
        final BalloonLayoutImpl balloonLayout = ProcessBalloon.getBalloonLayout(pane2);
        if (balloonLayout != null) {
            class MyListener
            implements JBPopupListener,
            Runnable {
                MyListener() {
                }

                public void beforeShown(@NotNull LightweightWindowEvent event) {
                    balloonLayout.addListener(this);
                }

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    balloonLayout.removeListener(this);
                }

                @Override
                public void run() {
                    if (!balloon.isDisposed()) {
                        balloon.revalidate();
                    }
                }
            }
            balloon.addListener((JBPopupListener)new MyListener());
        }
        return balloon;
    }

    @Nullable
    private static BalloonLayoutImpl getBalloonLayout(@NotNull JRootPane pane2) {
        Component parent = UIUtil.findUltimateParent((Component)pane2);
        if (parent instanceof IdeFrame) {
            return (BalloonLayoutImpl)((IdeFrame)parent).getBalloonLayout();
        }
        return null;
    }

    @NotNull
    private static Component getAnchor(@NotNull JRootPane pane2) {
        JComponent tabWrapper = UIUtil.findComponentOfType((JComponent)pane2, TabbedPaneWrapper.TabWrapper.class);
        if (tabWrapper != null && tabWrapper.isShowing()) {
            return tabWrapper;
        }
        EditorsSplitters splitters = (EditorsSplitters)((Object)UIUtil.findComponentOfType((JComponent)pane2, EditorsSplitters.class));
        if (splitters != null) {
            return splitters.isShowing() ? splitters : pane2;
        }
        FileEditorManagerEx ex = FileEditorManagerEx.getInstanceEx(ProjectUtil.guessCurrentProject((JComponent)pane2));
        if (ex == null) {
            return pane2;
        }
        splitters = ex.getSplitters();
        return splitters.isShowing() ? splitters : pane2;
    }

    private static boolean isBottomSideToolWindowsVisible(@NotNull JRootPane parent) {
        ToolWindowsPane pane2 = (ToolWindowsPane)((Object)UIUtil.findComponentOfType((JComponent)parent, ToolWindowsPane.class));
        return pane2 != null && pane2.isBottomSideToolWindowsVisible();
    }
}

