/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManagerListener;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncodingPanel
extends EditorBasedStatusBarPopup {
    public EncodingPanel(@NotNull Project project) {
        super(project, true);
    }

    @Override
    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
        }
        Pair<Charset, String> check = EncodingUtil.getCharsetAndTheReasonTooltip(file2);
        String failReason = (String)Pair.getSecond(check);
        Charset charset = (Charset)ObjectUtils.notNull((Object)Pair.getFirst(check), (Object)file2.getCharset());
        String charsetName = (String)ObjectUtils.notNull((Object)charset.displayName(), (Object)"n/a");
        String toolTipText = failReason == null ? IdeBundle.message((String)"status.bar.text.file.encoding", (Object[])new Object[]{charsetName}) : StringUtil.capitalize((String)failReason) + ".";
        return new EditorBasedStatusBarPopup.WidgetState(toolTipText, charsetName, failReason == null);
    }

    @Override
    @Nullable
    protected ListPopup createPopup(DataContext context) {
        ChangeFileEncodingAction action2 = new ChangeFileEncodingAction();
        action2.getTemplatePresentation().setText(IdeBundle.messagePointer((String)"action.presentation.EncodingPanel.text", (Object[])new Object[0]));
        return action2.createPopup(context);
    }

    @Override
    protected void registerCustomListeners() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(EncodingManagerListener.ENCODING_MANAGER_CHANGES, (Object)new EncodingManagerListener(){

            public void propertyChanged(@Nullable Document document, @NotNull String propertyName, Object oldValue, Object newValue2) {
                if (propertyName.equals("cachedEncoding")) {
                    EncodingPanel.this.updateForDocument(document);
                }
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter(new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if ("encoding".equals(event.getPropertyName())) {
                    EncodingPanel.this.updateForFile(event.getFile());
                }
            }
        }));
    }

    @Override
    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project) {
        return new EncodingPanel(project);
    }

    @NotNull
    public String ID() {
        return "Encoding";
    }
}

