/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.IdeFocusManagerHeadless;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolWindowHeadlessManagerImpl
extends ToolWindowManager {
    private final Map<String, ToolWindow> myToolWindows = new HashMap<String, ToolWindow>();
    private final Project myProject;

    public ToolWindowHeadlessManagerImpl(Project project) {
        this.myProject = project;
    }

    public boolean canShowNotification(@NotNull String toolWindowId) {
        return false;
    }

    public void notifyByBalloon(@NotNull String toolWindowId, @NotNull MessageType type, @NotNull String htmlBody) {
    }

    @NotNull
    public ToolWindow doRegisterToolWindow(@NotNull String id2) {
        MockToolWindow toolWindow = new MockToolWindow(this.myProject);
        this.myToolWindows.put(id2, toolWindow);
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull RegisterToolWindowTask task2) {
        return this.doRegisterToolWindow(task2.getId());
    }

    public void unregisterToolWindow(@NotNull String id2) {
        ToolWindow toolWindow = this.myToolWindows.remove(id2);
        if (toolWindow != null) {
            Disposer.dispose((Disposable)((MockToolWindow)toolWindow).myContentManager);
        }
    }

    public void activateEditorComponent() {
    }

    public boolean isEditorComponentActive() {
        return false;
    }

    public String @NotNull [] getToolWindowIds() {
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public Set<String> getToolWindowIdSet() {
        return Collections.emptySet();
    }

    public String getActiveToolWindowId() {
        return null;
    }

    @Nullable
    public String getLastActiveToolWindowId() {
        return null;
    }

    public ToolWindow getToolWindow(@Nullable String id2) {
        return this.myToolWindows.get(id2);
    }

    public void invokeLater(@NotNull Runnable runnable2) {
    }

    @NotNull
    public IdeFocusManager getFocusManager() {
        return IdeFocusManagerHeadless.INSTANCE;
    }

    public void notifyByBalloon(@NotNull String toolWindowId, @NotNull MessageType type, @NotNull String text, @Nullable Icon icon2, @Nullable HyperlinkListener listener2) {
    }

    public Balloon getToolWindowBalloon(@NotNull String id2) {
        return null;
    }

    public boolean isMaximized(@NotNull ToolWindow wnd) {
        return false;
    }

    public void setMaximized(@NotNull ToolWindow window, boolean maximized) {
    }

    @Nullable
    public ToolWindow getLastActiveToolWindow(@Nullable Predicate<JComponent> condition) {
        return null;
    }

    private static class MockContentManager
    implements ContentManager {
        private final EventDispatcher<ContentManagerListener> myDispatcher = EventDispatcher.create(ContentManagerListener.class);
        private final List<Content> myContents = new ArrayList<Content>();
        private Content mySelected;

        private MockContentManager() {
        }

        @NotNull
        public ActionCallback getReady(@NotNull Object requestor) {
            return ActionCallback.DONE;
        }

        public void addContent(@NotNull Content content2) {
            this.addContent(content2, -1);
        }

        public void addContent(@NotNull Content content2, int order) {
            this.myContents.add(order == -1 ? this.myContents.size() : order, content2);
            if (content2 instanceof ContentImpl && content2.getManager() == null) {
                ((ContentImpl)content2).setManager(this);
            }
            Disposer.register((Disposable)this, (Disposable)content2);
            ContentManagerEvent e = new ContentManagerEvent((Object)this, content2, this.myContents.indexOf(content2), ContentManagerEvent.ContentOperation.add);
            ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentAdded(e);
            if (this.mySelected == null) {
                this.setSelectedContent(content2);
            }
        }

        public void addSelectedContent(@NotNull Content content2) {
            this.addContent(content2);
            this.setSelectedContent(content2);
        }

        public void addContentManagerListener(@NotNull ContentManagerListener l) {
            this.myDispatcher.getListeners().add(0, l);
        }

        public void addDataProvider(@NotNull DataProvider provider) {
        }

        public boolean canCloseAllContents() {
            return false;
        }

        public boolean canCloseContents() {
            return false;
        }

        public Content findContent(String displayName) {
            for (Content each : this.myContents) {
                if (!each.getDisplayName().equals(displayName)) continue;
                return each;
            }
            return null;
        }

        @NotNull
        public List<AnAction> getAdditionalPopupActions(@NotNull Content content2) {
            return Collections.emptyList();
        }

        @NotNull
        public String getCloseActionName() {
            return "close";
        }

        @NotNull
        public String getCloseAllButThisActionName() {
            return "closeallbutthis";
        }

        @NotNull
        public String getPreviousContentActionName() {
            return "previous";
        }

        @NotNull
        public String getNextContentActionName() {
            return "next";
        }

        @NotNull
        public JComponent getComponent() {
            return new JLabel();
        }

        public Content getContent(@NotNull JComponent component2) {
            Content[] contents;
            for (Content content2 : contents = this.getContents()) {
                if (!Comparing.equal((Object)component2, (Object)content2.getComponent())) continue;
                return content2;
            }
            return null;
        }

        @Nullable
        public Content getContent(int index) {
            return this.myContents.get(index);
        }

        public int getContentCount() {
            return this.myContents.size();
        }

        public Content @NotNull [] getContents() {
            return this.myContents.toArray(new Content[0]);
        }

        public int getIndexOfContent(@NotNull Content content2) {
            return this.myContents.indexOf(content2);
        }

        @Nullable
        public Content getSelectedContent() {
            return this.mySelected;
        }

        public Content @NotNull [] getSelectedContents() {
            Content[] contentArray;
            if (this.mySelected != null) {
                Content[] contentArray2 = new Content[1];
                contentArray = contentArray2;
                contentArray2[0] = this.mySelected;
            } else {
                contentArray = new Content[]{};
            }
            return contentArray;
        }

        public boolean isSelected(@NotNull Content content2) {
            return content2 == this.mySelected;
        }

        public void removeAllContents(boolean dispose2) {
            for (Content content2 : this.getContents()) {
                this.removeContent(content2, dispose2);
            }
        }

        public boolean removeContent(@NotNull Content content2, boolean dispose2) {
            boolean wasSelected = this.mySelected == content2;
            int oldIndex = this.myContents.indexOf(content2);
            if (wasSelected) {
                this.removeFromSelection(content2);
            }
            boolean result2 = this.myContents.remove(content2);
            if (dispose2) {
                Disposer.dispose((Disposable)content2);
            }
            ContentManagerEvent e = new ContentManagerEvent((Object)this, content2, oldIndex, ContentManagerEvent.ContentOperation.remove);
            ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentRemoved(e);
            Content item = (Content)ContainerUtil.getFirstItem(this.myContents);
            if (item != null) {
                this.setSelectedContent(item);
            } else {
                this.mySelected = null;
            }
            return result2;
        }

        @NotNull
        public ActionCallback removeContent(@NotNull Content content2, boolean dispose2, boolean requestFocus, boolean implicitFocus) {
            this.removeContent(content2, dispose2);
            return ActionCallback.DONE;
        }

        public void removeContentManagerListener(@NotNull ContentManagerListener l) {
            this.myDispatcher.removeListener((EventListener)l);
        }

        public void removeFromSelection(@NotNull Content content2) {
            ContentManagerEvent e = new ContentManagerEvent((Object)this, content2, this.myContents.indexOf(this.mySelected), ContentManagerEvent.ContentOperation.remove);
            ((ContentManagerListener)this.myDispatcher.getMulticaster()).selectionChanged(e);
        }

        public ActionCallback selectNextContent() {
            return ActionCallback.DONE;
        }

        public ActionCallback selectPreviousContent() {
            return ActionCallback.DONE;
        }

        public void setSelectedContent(@NotNull Content content2) {
            if (this.mySelected != null) {
                this.removeFromSelection(this.mySelected);
            }
            this.mySelected = content2;
            ContentManagerEvent e = new ContentManagerEvent((Object)this, content2, this.myContents.indexOf(content2), ContentManagerEvent.ContentOperation.add);
            ((ContentManagerListener)this.myDispatcher.getMulticaster()).selectionChanged(e);
        }

        @NotNull
        public ActionCallback setSelectedContentCB(@NotNull Content content2) {
            this.setSelectedContent(content2);
            return ActionCallback.DONE;
        }

        public void setSelectedContent(@NotNull Content content2, boolean requestFocus) {
            this.setSelectedContent(content2);
        }

        @NotNull
        public ActionCallback setSelectedContentCB(@NotNull Content content2, boolean requestFocus) {
            return this.setSelectedContentCB(content2);
        }

        public void setSelectedContent(@NotNull Content content2, boolean requestFocus, boolean forcedFocus) {
            this.setSelectedContent(content2);
        }

        @NotNull
        public ActionCallback setSelectedContentCB(@NotNull Content content2, boolean requestFocus, boolean forcedFocus) {
            return this.setSelectedContentCB(content2);
        }

        @NotNull
        public ActionCallback setSelectedContent(@NotNull Content content2, boolean requestFocus, boolean forcedFocus, boolean implicit) {
            return this.setSelectedContentCB(content2);
        }

        @NotNull
        public ActionCallback requestFocus(@Nullable Content content2, boolean forced) {
            return ActionCallback.DONE;
        }

        public void dispose() {
            this.myContents.clear();
            this.mySelected = null;
            this.myDispatcher.getListeners().clear();
        }

        public boolean isDisposed() {
            return false;
        }

        public boolean isSingleSelection() {
            return true;
        }

        @NotNull
        public ContentFactory getFactory() {
            return (ContentFactory)ServiceManager.getService(ContentFactory.class);
        }
    }

    public static class MockToolWindow
    implements ToolWindowEx {
        final ContentManager myContentManager = new MockContentManager();
        private final Project project;

        public MockToolWindow(@NotNull Project project) {
            this.project = project;
            Disposer.register((Disposable)project, (Disposable)this.myContentManager);
        }

        @Override
        @NotNull
        public Project getProject() {
            return this.project;
        }

        @NotNull
        public Disposable getDisposable() {
            return this.myContentManager;
        }

        public void remove() {
        }

        @NotNull
        public String getId() {
            return "";
        }

        public boolean isActive() {
            return false;
        }

        public void activate(@Nullable Runnable runnable2) {
        }

        public boolean isDisposed() {
            return false;
        }

        public boolean isVisible() {
            return false;
        }

        public void setShowStripeButton(boolean show2) {
        }

        public boolean isShowStripeButton() {
            return false;
        }

        @NotNull
        public ActionCallback getReady(@NotNull Object requestor) {
            return ActionCallback.DONE;
        }

        public void show(@Nullable Runnable runnable2) {
        }

        public void hide(@Nullable Runnable runnable2) {
        }

        @NotNull
        public ToolWindowAnchor getAnchor() {
            return ToolWindowAnchor.BOTTOM;
        }

        public void setAnchor(@NotNull ToolWindowAnchor anchor2, @Nullable Runnable runnable2) {
        }

        public boolean isSplitMode() {
            return false;
        }

        public void setSplitMode(boolean isSideTool, @Nullable Runnable runnable2) {
        }

        public boolean isAutoHide() {
            return false;
        }

        public void setAutoHide(boolean state) {
        }

        public void setToHideOnEmptyContent(boolean hideOnEmpty) {
        }

        @NotNull
        public ToolWindowType getType() {
            return ToolWindowType.SLIDING;
        }

        public void setType(@NotNull ToolWindowType type, @Nullable Runnable runnable2) {
        }

        @Nullable
        public Icon getIcon() {
            return null;
        }

        public void setIcon(@NotNull Icon icon2) {
        }

        public String getTitle() {
            return "";
        }

        public void setTitle(String title) {
        }

        @NotNull
        public String getStripeTitle() {
            return "";
        }

        public void setStripeTitle(@NotNull String title) {
        }

        public boolean isAvailable() {
            return false;
        }

        public void setContentUiType(@NotNull ToolWindowContentUiType type, @Nullable Runnable runnable2) {
        }

        public void setDefaultContentUiType(@NotNull ToolWindowContentUiType type) {
        }

        @NotNull
        public ToolWindowContentUiType getContentUiType() {
            return ToolWindowContentUiType.TABBED;
        }

        public void setAvailable(boolean available, @Nullable Runnable runnable2) {
        }

        public void setAvailable(boolean value2) {
        }

        public void installWatcher(ContentManager contentManager2) {
        }

        @NotNull
        public JComponent getComponent() {
            return new JLabel();
        }

        @NotNull
        public ContentManager getContentManager() {
            return this.myContentManager;
        }

        @Nullable
        public ContentManager getContentManagerIfCreated() {
            return this.myContentManager;
        }

        public void addContentManagerListener(@NotNull ContentManagerListener listener2) {
        }

        public void setDefaultState(@Nullable ToolWindowAnchor anchor2, @Nullable ToolWindowType type, @Nullable Rectangle floatingBounds2) {
        }

        public void activate(@Nullable Runnable runnable2, boolean autoFocusContents) {
        }

        public void activate(@Nullable Runnable runnable2, boolean autoFocusContents, boolean forced) {
        }

        public void showContentPopup(@NotNull InputEvent inputEvent) {
        }

        @Override
        @NotNull
        public ToolWindowType getInternalType() {
            return ToolWindowType.DOCKED;
        }

        @Override
        public void stretchWidth(int value2) {
        }

        @Override
        public void stretchHeight(int value2) {
        }

        @Override
        @NotNull
        public InternalDecorator getDecorator() {
            throw new IncorrectOperationException();
        }

        @Override
        public void setAdditionalGearActions(ActionGroup additionalGearActions) {
        }

        public void setTitleActions(@NotNull List<AnAction> actions) {
        }

        @Override
        public void setTabActions(AnAction ... actions) {
        }

        @Override
        public void setTabDoubleClickActions(@NotNull List<AnAction> actions) {
        }
    }
}

