/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.actions.ToolwindowFusEventFields;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.eventLog.EventPair;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.FusAwareAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MaximizeToolWindowAction
extends AnAction
implements DumbAware,
FusAwareAction {
    public MaximizeToolWindowAction() {
        super(ActionsBundle.messagePointer((String)"action.ResizeToolWindowMaximize.text", (Object[])new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ToolWindowManager manager;
        Project project = e.getProject();
        if (project == null || project.isDisposed()) {
            return;
        }
        ToolWindow toolWindow = (ToolWindow)e.getData(PlatformDataKeys.TOOL_WINDOW);
        if (toolWindow == null) {
            return;
        }
        manager.setMaximized(toolWindow, !(manager = ToolWindowManager.getInstance((Project)project)).isMaximized(toolWindow));
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(true);
        Project project = e.getProject();
        if (project == null || project.isDisposed()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        ToolWindow toolWindow = (ToolWindow)e.getData(PlatformDataKeys.TOOL_WINDOW);
        if (toolWindow == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
        e.getPresentation().setText(manager.isMaximized(toolWindow) ? ActionsBundle.message((String)"action.ResizeToolWindowMaximize.text.alternative", (Object[])new Object[0]) : ActionsBundle.message((String)"action.ResizeToolWindowMaximize.text", (Object[])new Object[0]));
    }

    @Override
    @NotNull
    public List<EventPair> getAdditionalUsageData(@NotNull AnActionEvent event) {
        ToolWindow toolWindow = (ToolWindow)event.getData(PlatformDataKeys.TOOL_WINDOW);
        if (toolWindow != null) {
            return Collections.singletonList(ToolwindowFusEventFields.TOOLWINDOW.with((Object)toolWindow.getId()));
        }
        return Collections.emptyList();
    }
}

