/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.jdkEx.JdkEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.X11UiUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.mac.MacMainFrameDecorator;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class IdeFrameDecorator
implements IdeFrameImpl.FrameDecorator {
    static final String FULL_SCREEN = "ide.frame.full.screen";
    protected final JFrame myFrame;
    private static final Logger LOG = Logger.getInstance(IdeFrameDecorator.class);

    protected IdeFrameDecorator(@NotNull JFrame frame) {
        this.myFrame = frame;
    }

    @Override
    public abstract boolean isInFullScreen();

    @NotNull
    public abstract Promise<Boolean> toggleFullScreen(boolean var1);

    @Nullable
    public static IdeFrameDecorator decorate(@NotNull JFrame frame, @NotNull Disposable parentDisposable) {
        try {
            if (SystemInfo.isMac) {
                return new MacMainFrameDecorator(frame, parentDisposable);
            }
            if (SystemInfo.isWindows) {
                return new WinMainFrameDecorator(frame);
            }
            if (SystemInfo.isXWindow && X11UiUtil.isFullScreenSupported()) {
                return new EWMHFrameDecorator(frame, parentDisposable);
            }
        }
        catch (Throwable t) {
            LOG.warn("Failed to initialize IdeFrameDecorator. " + t.getMessage(), t);
        }
        return null;
    }

    protected void notifyFrameComponents(boolean state) {
        this.myFrame.getRootPane().putClientProperty(FULL_SCREEN, state);
        JMenuBar menuBar = this.myFrame.getJMenuBar();
        if (menuBar != null) {
            menuBar.putClientProperty(FULL_SCREEN, state);
        }
    }

    public static boolean isCustomDecorationActive() {
        return SystemInfo.isWindows && SystemProperties.getBooleanProperty((String)"ide.win.frame.decoration", (boolean)true) && JdkEx.isCustomDecorationSupported();
    }

    private static class EWMHFrameDecorator
    extends IdeFrameDecorator {
        private Boolean myRequestedState = null;

        private EWMHFrameDecorator(final @NotNull JFrame frame, @NotNull Disposable parentDisposable) {
            super(frame);
            frame.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (myRequestedState != null) {
                        this.notifyFrameComponents(myRequestedState);
                        myRequestedState = null;
                    }
                }
            });
            if (SystemInfo.isKDE && ComponentUtil.isDisableAutoRequestFocus()) {
                final WindowAdapter deiconifyListener = new WindowAdapter(){

                    @Override
                    public void windowDeiconified(WindowEvent event) {
                        frame.toFront();
                    }
                };
                frame.addWindowListener(deiconifyListener);
                Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                    public void dispose() {
                        frame.removeWindowListener(deiconifyListener);
                    }
                });
            }
        }

        @Override
        public boolean isInFullScreen() {
            return this.myFrame != null && X11UiUtil.isInFullScreenMode(this.myFrame);
        }

        @Override
        @NotNull
        public Promise<Boolean> toggleFullScreen(boolean state) {
            if (this.myFrame != null) {
                this.myRequestedState = state;
                X11UiUtil.toggleFullScreenMode(this.myFrame);
                if (this.myFrame.getJMenuBar() instanceof IdeMenuBar) {
                    IdeMenuBar frameMenuBar = (IdeMenuBar)this.myFrame.getJMenuBar();
                    frameMenuBar.onToggleFullScreen(state);
                }
            }
            return Promises.resolvedPromise((Object)state);
        }
    }

    private static class WinMainFrameDecorator
    extends IdeFrameDecorator {
        private WinMainFrameDecorator(@NotNull JFrame frame) {
            super(frame);
        }

        @Override
        public boolean isInFullScreen() {
            return UIUtil.isWindowClientPropertyTrue((Window)this.myFrame, (Object)IdeFrameDecorator.FULL_SCREEN);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Promise<Boolean> toggleFullScreen(boolean state) {
            GraphicsDevice device;
            Rectangle bounds2 = this.myFrame.getBounds();
            int extendedState = this.myFrame.getExtendedState();
            if (state && extendedState == 0) {
                this.myFrame.getRootPane().putClientProperty("normalBounds", bounds2);
            }
            if ((device = ScreenUtil.getScreenDevice((Rectangle)bounds2)) == null) {
                return Promises.rejectedPromise();
            }
            Rectangle defaultBounds = device.getDefaultConfiguration().getBounds();
            try {
                this.myFrame.getRootPane().putClientProperty("togglingFullScreenInProgress", Boolean.TRUE);
                this.myFrame.getRootPane().putClientProperty("dispose.temporary", Boolean.TRUE);
                this.myFrame.dispose();
                this.myFrame.setUndecorated(state);
            }
            finally {
                if (state) {
                    this.myFrame.setBounds(defaultBounds);
                } else {
                    Object o = this.myFrame.getRootPane().getClientProperty("normalBounds");
                    if (o instanceof Rectangle) {
                        this.myFrame.setBounds((Rectangle)o);
                    }
                }
                this.myFrame.setVisible(true);
                this.myFrame.getRootPane().putClientProperty("dispose.temporary", null);
                if (!state && (extendedState & 6) != 0) {
                    this.myFrame.setExtendedState(extendedState);
                }
                this.notifyFrameComponents(state);
            }
            EventQueue.invokeLater(() -> this.myFrame.getRootPane().putClientProperty("togglingFullScreenInProgress", null));
            return Promises.resolvedPromise((Object)state);
        }
    }
}

