/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.scale.JBUIScale;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class FrameBoundsConverter {
    @NotNull
    public static Rectangle convertFromDeviceSpaceAndFitToScreen(@NotNull Rectangle bounds2) {
        Rectangle b = bounds2.getBounds();
        int centerX = b.x + b.width / 2;
        int centerY = b.y + b.height / 2;
        boolean scaleNeeded = FrameBoundsConverter.shouldConvert();
        for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle devBounds = gc.getBounds();
            if (scaleNeeded) {
                FrameBoundsConverter.scaleUp(devBounds, gc);
            }
            if (!devBounds.contains(centerX, centerY)) continue;
            if (scaleNeeded) {
                FrameBoundsConverter.scaleDown(b, gc);
            }
            Rectangle screen = ScreenUtil.getScreenRectangle((GraphicsConfiguration)gc);
            if (b.x < screen.x) {
                b.x = screen.x;
            }
            if (b.y < screen.y) {
                b.y = screen.y;
            }
            if (b.width > screen.width) {
                b.width = screen.width;
            }
            if (b.height > screen.height) {
                b.height = screen.height;
            }
            return b;
        }
        ScreenUtil.fitToScreen((Rectangle)b);
        return b;
    }

    public static Rectangle convertToDeviceSpace(GraphicsConfiguration gc, @NotNull Rectangle bounds2) {
        Rectangle b = bounds2.getBounds();
        if (!FrameBoundsConverter.shouldConvert()) {
            return b;
        }
        try {
            FrameBoundsConverter.scaleUp(b, gc);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        return b;
    }

    private static boolean shouldConvert() {
        if (SystemInfoRt.isLinux || SystemInfoRt.isMac) {
            return false;
        }
        return JreHiDpiUtil.isJreHiDPIEnabled();
    }

    private static void scaleUp(@NotNull Rectangle bounds2, @NotNull GraphicsConfiguration gc) {
        FrameBoundsConverter.scale(bounds2, gc.getBounds(), JBUIScale.sysScale((GraphicsConfiguration)gc));
    }

    private static void scaleDown(@NotNull Rectangle bounds2, @NotNull GraphicsConfiguration gc) {
        float scale = JBUIScale.sysScale((GraphicsConfiguration)gc);
        assert (scale != 0.0f);
        FrameBoundsConverter.scale(bounds2, gc.getBounds(), 1.0f / scale);
    }

    private static void scale(@NotNull Rectangle bounds2, @NotNull Rectangle deviceBounds, float scale) {
        int x = (int)Math.floor((float)deviceBounds.x + (float)(bounds2.x - deviceBounds.x) * scale);
        int y = (int)Math.floor((float)deviceBounds.y + (float)(bounds2.y - deviceBounds.y) * scale);
        bounds2.setBounds(x, y, (int)Math.ceil((float)bounds2.width * scale), (int)Math.ceil((float)bounds2.height * scale));
    }
}

