/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.wm.impl.ToolWindowEntry;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;

final class ActiveStack {
    private final Stack<ToolWindowEntry> myStack = new Stack();
    private final Stack<ToolWindowEntry> myPersistentStack = new Stack();

    ActiveStack() {
    }

    void clear() {
        this.myStack.clear();
    }

    boolean isEmpty() {
        return this.myStack.isEmpty();
    }

    @NotNull
    ToolWindowEntry pop() {
        return (ToolWindowEntry)this.myStack.pop();
    }

    int getSize() {
        return this.myStack.size();
    }

    @NotNull
    private ToolWindowEntry peek(int i2) {
        return (ToolWindowEntry)this.myStack.get(this.getSize() - i2 - 1);
    }

    ToolWindowEntry @NotNull [] getStack() {
        ToolWindowEntry[] result2 = new ToolWindowEntry[this.getSize()];
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            result2[i2] = this.peek(i2);
        }
        return result2;
    }

    ToolWindowEntry @NotNull [] getPersistentStack() {
        ToolWindowEntry[] result2 = new ToolWindowEntry[this.getPersistentSize()];
        for (int i2 = 0; i2 < this.getPersistentSize(); ++i2) {
            result2[i2] = this.peekPersistent(i2);
        }
        return result2;
    }

    void push(@NotNull ToolWindowEntry id2) {
        this.remove(id2, true);
        this.myStack.push((Object)id2);
        this.myPersistentStack.push((Object)id2);
    }

    int getPersistentSize() {
        return this.myPersistentStack.size();
    }

    @NotNull
    ToolWindowEntry peekPersistent(int index) {
        return (ToolWindowEntry)this.myPersistentStack.get(this.myPersistentStack.size() - index - 1);
    }

    void remove(@NotNull ToolWindowEntry id2, boolean removePersistentAlso) {
        this.myStack.remove((Object)id2);
        if (removePersistentAlso) {
            this.myPersistentStack.remove((Object)id2);
        }
    }
}

