/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.impl.local.DirectoryAccessChecker;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.LocalFileSystemRefreshWorker;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.VfsEventGenerationHelper;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.containers.Queue;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshWorker {
    private final boolean myIsRecursive;
    private final Queue<NewVirtualFile> myRefreshQueue = new Queue(100);
    private final VfsEventGenerationHelper myHelper = new VfsEventGenerationHelper();
    private volatile boolean myCancelled;
    private final LocalFileSystemRefreshWorker myLocalFileSystemRefreshWorker;
    private static Consumer<? super VirtualFile> ourTestListener;

    public RefreshWorker(@NotNull NewVirtualFile refreshRoot, boolean isRecursive) {
        boolean canUseNioRefresher = refreshRoot.isInLocalFileSystem() && !(refreshRoot.getFileSystem() instanceof TempFileSystem) && Registry.is((String)"vfs.use.nio-based.local.refresh.worker");
        this.myLocalFileSystemRefreshWorker = canUseNioRefresher ? new LocalFileSystemRefreshWorker(refreshRoot, isRecursive) : null;
        this.myIsRecursive = isRecursive;
        this.myRefreshQueue.addLast((Object)refreshRoot);
    }

    @NotNull
    public List<VFileEvent> getEvents() {
        if (this.myLocalFileSystemRefreshWorker != null) {
            return this.myLocalFileSystemRefreshWorker.getEvents();
        }
        return this.myHelper.getEvents();
    }

    public void cancel() {
        if (this.myLocalFileSystemRefreshWorker != null) {
            this.myLocalFileSystemRefreshWorker.cancel();
        }
        this.myCancelled = true;
    }

    public void scan() {
        if (this.myLocalFileSystemRefreshWorker != null) {
            this.myLocalFileSystemRefreshWorker.scan();
            return;
        }
        NewVirtualFile root = (NewVirtualFile)this.myRefreshQueue.pullFirst();
        NewVirtualFileSystem fs = root.getFileSystem();
        if (root.isDirectory()) {
            fs = PersistentFS.replaceWithNativeFS(fs);
        }
        PersistentFS persistence = PersistentFS.getInstance();
        FileAttributes attributes = fs.getAttributes((VirtualFile)root);
        if (attributes == null) {
            this.myHelper.scheduleDeletion((VirtualFile)root);
            root.markClean();
            return;
        }
        if (fs instanceof LocalFileSystemBase) {
            DirectoryAccessChecker.refresh();
        }
        this.checkAndScheduleChildRefresh(fs, persistence, root.getParent(), root, attributes);
        if (root.isDirty()) {
            if (this.myRefreshQueue.isEmpty()) {
                this.queueDirectory(root);
            }
            try {
                this.processQueue(fs, persistence);
            }
            catch (RefreshCancelledException e) {
                VfsEventGenerationHelper.LOG.trace("refresh cancelled");
            }
        }
    }

    private void queueDirectory(NewVirtualFile root) {
        if (root instanceof VirtualDirectoryImpl) {
            this.myRefreshQueue.addLast((Object)root);
        } else {
            VfsEventGenerationHelper.LOG.error("not a directory: " + root + " (" + root.getClass());
        }
    }

    private void processQueue(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence) throws RefreshCancelledException {
        TObjectHashingStrategy strategy = FilePathHashingStrategy.create((boolean)fs.isCaseSensitive());
        block2: while (!this.myRefreshQueue.isEmpty()) {
            boolean succeeded;
            VirtualDirectoryImpl dir = (VirtualDirectoryImpl)((Object)this.myRefreshQueue.pullFirst());
            boolean fullSync = dir.allChildrenLoaded();
            do {
                this.myHelper.beginTransaction();
                try {
                    succeeded = fullSync ? this.fullDirRefresh(fs, persistence, (TObjectHashingStrategy<String>)strategy, dir) : this.partialDirRefresh(fs, persistence, (TObjectHashingStrategy<String>)strategy, dir);
                }
                catch (InvalidVirtualFileAccessException e) {
                    this.myHelper.endTransaction(false);
                    continue block2;
                }
                this.myHelper.endTransaction(succeeded);
                if (succeeded || !VfsEventGenerationHelper.LOG.isTraceEnabled()) continue;
                VfsEventGenerationHelper.LOG.trace("retry: " + (Object)((Object)dir));
            } while (!succeeded);
            if (!this.myIsRecursive) continue;
            dir.markClean();
        }
    }

    private boolean fullDirRefresh(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence, @NotNull TObjectHashingStrategy<String> strategy, @NotNull VirtualDirectoryImpl dir) {
        VirtualFileSystemEntry child2;
        OpenTHashSet actualNames;
        Pair<List<String>, List<VirtualFile>> snapshot = LocalFileSystemRefreshWorker.getDirectorySnapshot(dir);
        if (snapshot == null) {
            return false;
        }
        List persistedNames = (List)snapshot.getFirst();
        List children2 = (List)snapshot.getSecond();
        Object[] upToDateNames = VfsUtil.filterNames((String[])fs.list((VirtualFile)dir));
        THashSet newNames = new THashSet(Arrays.asList(upToDateNames), strategy);
        if (dir.allChildrenLoaded() && children2.size() < upToDateNames.length) {
            for (VirtualFile child3 : children2) {
                newNames.remove(child3.getName());
            }
        } else {
            newNames.removeAll(persistedNames);
        }
        THashSet deletedNames = ContainerUtil.newTroveSet(strategy, (Collection)persistedNames);
        ContainerUtil.removeAll((Collection)deletedNames, (Object[])upToDateNames);
        OpenTHashSet openTHashSet = actualNames = fs.isCaseSensitive() ? null : new OpenTHashSet(strategy, upToDateNames);
        if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
            VfsEventGenerationHelper.LOG.trace("current=" + persistedNames + " +" + newNames + " -" + deletedNames);
        }
        ArrayList<ChildInfo> newKids = new ArrayList<ChildInfo>(newNames.size());
        for (String newName : newNames) {
            this.checkCancelled(dir);
            ChildInfo record = RefreshWorker.childRecord(fs, (VirtualFile)dir, newName);
            if (record != null) {
                newKids.add(record);
                continue;
            }
            if (!VfsEventGenerationHelper.LOG.isTraceEnabled()) continue;
            VfsEventGenerationHelper.LOG.trace("[+] fs=" + fs + " dir=" + (Object)((Object)dir) + " name=" + newName);
        }
        ArrayList<Pair> updatedMap = new ArrayList<Pair>(children2.size());
        for (VirtualFile child4 : children2) {
            this.checkCancelled(dir);
            if (deletedNames.contains(child4.getName())) continue;
            updatedMap.add(Pair.pair((Object)child4, (Object)fs.getAttributes(child4)));
        }
        if (this.isFullScanDirectoryChanged(dir, persistedNames, children2)) {
            return false;
        }
        for (String name : deletedNames) {
            child2 = dir.findChild(name);
            if (child2 == null) continue;
            this.myHelper.scheduleDeletion((VirtualFile)child2);
        }
        for (ChildInfo record : newKids) {
            this.myHelper.scheduleCreation((VirtualFile)dir, record.getName().toString(), record.getFileAttributes(), record.getSymlinkTarget(), (ThrowableRunnable<RefreshCancelledException>)((ThrowableRunnable)() -> this.checkCancelled(dir)));
        }
        for (Pair pair : updatedMap) {
            child2 = (NewVirtualFile)pair.first;
            this.checkCancelled(child2);
            FileAttributes childAttributes = (FileAttributes)pair.second;
            if (childAttributes != null) {
                this.checkAndScheduleChildRefresh(fs, persistence, dir, child2, childAttributes);
                this.checkAndScheduleFileNameChange((OpenTHashSet<String>)actualNames, (VirtualFile)child2);
                continue;
            }
            if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
                VfsEventGenerationHelper.LOG.warn("[x] fs=" + fs + " dir=" + (Object)((Object)dir) + " name=" + child2.getName());
            }
            this.myHelper.scheduleDeletion((VirtualFile)child2);
        }
        return !this.isFullScanDirectoryChanged(dir, persistedNames, children2);
    }

    private boolean isFullScanDirectoryChanged(VirtualDirectoryImpl dir, List<String> names2, List<VirtualFile> children2) {
        return (Boolean)ReadAction.compute(() -> {
            this.checkCancelled(dir);
            return LocalFileSystemRefreshWorker.areChildrenOrNamesChanged(dir, names2, children2);
        });
    }

    private boolean partialDirRefresh(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence, @NotNull TObjectHashingStrategy<String> strategy, @NotNull VirtualDirectoryImpl dir) {
        OpenTHashSet actualNames;
        Pair snapshot = (Pair)ReadAction.compute(() -> {
            this.checkCancelled(dir);
            return Pair.pair((Object)dir.getCachedChildren(), dir.getSuspiciousNames());
        });
        List cached = (List)snapshot.getFirst();
        List wanted = (List)snapshot.getSecond();
        OpenTHashSet openTHashSet = actualNames = fs.isCaseSensitive() || cached.isEmpty() ? null : new OpenTHashSet(strategy, (Object[])VfsUtil.filterNames((String[])fs.list((VirtualFile)dir)));
        if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
            VfsEventGenerationHelper.LOG.trace("cached=" + cached + " actual=" + actualNames + " suspicious=" + wanted);
        }
        ArrayList<Pair> existingMap = new ArrayList<Pair>(cached.size());
        for (VirtualFile child2 : cached) {
            this.checkCancelled(dir);
            existingMap.add(Pair.pair((Object)child2, (Object)fs.getAttributes(child2)));
        }
        ArrayList<ChildInfo> newKids = new ArrayList<ChildInfo>(wanted.size());
        for (String name : wanted) {
            if (name.isEmpty()) continue;
            this.checkCancelled(dir);
            ChildInfo record = RefreshWorker.childRecord(fs, (VirtualFile)dir, name);
            if (record == null) continue;
            newKids.add(record);
        }
        if (this.isDirectoryChanged(dir, cached, wanted)) {
            return false;
        }
        for (Pair pair : existingMap) {
            NewVirtualFile child3 = (NewVirtualFile)pair.first;
            this.checkCancelled(child3);
            FileAttributes childAttributes = (FileAttributes)pair.second;
            if (childAttributes != null) {
                this.checkAndScheduleChildRefresh(fs, persistence, dir, child3, childAttributes);
                this.checkAndScheduleFileNameChange((OpenTHashSet<String>)actualNames, (VirtualFile)child3);
                continue;
            }
            this.myHelper.scheduleDeletion((VirtualFile)child3);
        }
        for (ChildInfo record : newKids) {
            this.myHelper.scheduleCreation((VirtualFile)dir, record.getName().toString(), record.getFileAttributes(), record.getSymlinkTarget(), (ThrowableRunnable<RefreshCancelledException>)((ThrowableRunnable)() -> this.checkCancelled(dir)));
        }
        return !this.isDirectoryChanged(dir, cached, wanted);
    }

    private boolean isDirectoryChanged(@NotNull VirtualDirectoryImpl dir, @NotNull List<VirtualFile> cached, @NotNull List<String> wanted) {
        return (Boolean)ReadAction.compute(() -> {
            this.checkCancelled(dir);
            return !cached.equals(dir.getCachedChildren()) || !wanted.equals(dir.getSuspiciousNames());
        });
    }

    @Nullable
    private static ChildInfo childRecord(@NotNull NewVirtualFileSystem fs, @NotNull VirtualFile dir, @NotNull String name) {
        String symlinkTarget;
        FakeVirtualFile file2 = new FakeVirtualFile(dir, name);
        FileAttributes attributes = fs.getAttributes((VirtualFile)file2);
        if (attributes == null) {
            return null;
        }
        boolean isEmptyDir = attributes.isDirectory() && !fs.hasChildren((VirtualFile)file2);
        String string = symlinkTarget = attributes.isSymLink() ? fs.resolveSymLink((VirtualFile)file2) : null;
        if (!fs.isCaseSensitive()) {
            name = fs.getCanonicallyCasedName((VirtualFile)file2);
        }
        return new ChildInfoImpl(-238, name, attributes, (ChildInfo[])(isEmptyDir ? ChildInfo.EMPTY_ARRAY : null), symlinkTarget);
    }

    private void checkCancelled(@NotNull NewVirtualFile stopAt) throws RefreshCancelledException {
        if (ourTestListener != null) {
            ourTestListener.accept((VirtualFile)stopAt);
        }
        if (this.myCancelled) {
            if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
                VfsEventGenerationHelper.LOG.trace("cancelled at: " + stopAt);
            }
            RefreshWorker.forceMarkDirty(stopAt);
            while (!this.myRefreshQueue.isEmpty()) {
                RefreshWorker.forceMarkDirty((NewVirtualFile)this.myRefreshQueue.pullFirst());
            }
            throw new RefreshCancelledException();
        }
    }

    private static void forceMarkDirty(@NotNull NewVirtualFile file2) {
        file2.markClean();
        file2.markDirty();
    }

    private void checkAndScheduleChildRefresh(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence, @Nullable NewVirtualFile parent, @NotNull NewVirtualFile child2, @NotNull FileAttributes childAttributes) {
        if (!VfsEventGenerationHelper.checkDirty(child2)) {
            return;
        }
        if (this.checkAndScheduleFileTypeChange(fs, parent, child2, childAttributes)) {
            child2.markClean();
            return;
        }
        this.myHelper.checkWritableAttributeChange((VirtualFile)child2, persistence.isWritable((VirtualFile)child2), childAttributes.isWritable());
        if (SystemInfo.isWindows) {
            this.myHelper.checkHiddenAttributeChange((VirtualFile)child2, child2.is(VFileProperty.HIDDEN), childAttributes.isHidden());
        }
        if (childAttributes.isSymLink()) {
            this.myHelper.checkSymbolicLinkChange((VirtualFile)child2, child2.getCanonicalPath(), fs.resolveSymLink((VirtualFile)child2));
        }
        if (!childAttributes.isDirectory()) {
            long oltTS = persistence.getTimeStamp((VirtualFile)child2);
            long newTS = childAttributes.lastModified;
            long oldLength = persistence.getLastRecordedLength((VirtualFile)child2);
            long newLength = childAttributes.length;
            this.myHelper.checkContentChanged((VirtualFile)child2, oltTS, newTS, oldLength, newLength);
            child2.markClean();
        } else if (this.myIsRecursive) {
            this.queueDirectory(child2);
        }
    }

    private boolean checkAndScheduleFileTypeChange(@NotNull NewVirtualFileSystem fs, @Nullable NewVirtualFile parent, @NotNull NewVirtualFile child2, @NotNull FileAttributes childAttributes) {
        boolean currentIsDirectory = child2.isDirectory();
        boolean upToDateIsDirectory = childAttributes.isDirectory();
        boolean currentIsSymlink = child2.is(VFileProperty.SYMLINK);
        boolean upToDateIsSymlink = childAttributes.isSymLink();
        boolean currentIsSpecial = child2.is(VFileProperty.SPECIAL);
        boolean upToDateIsSpecial = childAttributes.isSpecial();
        if (currentIsDirectory != upToDateIsDirectory || currentIsSymlink != upToDateIsSymlink || currentIsSpecial != upToDateIsSpecial) {
            this.myHelper.scheduleDeletion((VirtualFile)child2);
            if (parent != null) {
                String symlinkTarget = upToDateIsSymlink ? fs.resolveSymLink((VirtualFile)child2) : null;
                this.myHelper.scheduleCreation((VirtualFile)parent, child2.getName(), childAttributes, symlinkTarget, (ThrowableRunnable<RefreshCancelledException>)((ThrowableRunnable)() -> this.checkCancelled(parent)));
            } else {
                VfsEventGenerationHelper.LOG.error("transgender orphan: " + child2 + ' ' + childAttributes);
            }
            return true;
        }
        return false;
    }

    private void checkAndScheduleFileNameChange(@Nullable OpenTHashSet<String> actualNames, @NotNull VirtualFile child2) {
        String currentName;
        String actualName;
        if (actualNames != null && (actualName = (String)actualNames.get((Object)(currentName = child2.getName()))) != null && !currentName.equals(actualName)) {
            this.myHelper.scheduleAttributeChange(child2, "name", currentName, actualName);
        }
    }

    public static void setTestListener(@Nullable Consumer<? super VirtualFile> testListener) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ourTestListener = testListener;
        LocalFileSystemRefreshWorker.setTestListener(testListener);
    }

    static class RefreshCancelledException
    extends RuntimeException {
        RefreshCancelledException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

