/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.win32.Win32LocalFileSystem;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.BitUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PersistentFS
extends ManagingFS {
    static final int CHILDREN_CACHED_FLAG = 1;
    static final int IS_DIRECTORY_FLAG = 2;
    static final int IS_READ_ONLY = 4;
    static final int MUST_RELOAD_CONTENT = 8;
    static final int IS_SYMLINK = 16;
    static final int IS_SPECIAL = 32;
    static final int IS_HIDDEN = 64;
    static final int MUST_RELOAD_LENGTH = 128;
    static final int ALL_VALID_FLAGS = 255;

    public static PersistentFS getInstance() {
        return (PersistentFS)ManagingFS.getInstance();
    }

    public abstract void clearIdCache();

    public abstract String @NotNull [] listPersisted(@NotNull VirtualFile var1);

    @ApiStatus.Internal
    @NotNull
    public abstract List<? extends ChildInfo> listAll(@NotNull VirtualFile var1);

    @ApiStatus.Internal
    public abstract ChildInfo findChildInfo(@NotNull VirtualFile var1, @NotNull String var2, @NotNull NewVirtualFileSystem var3);

    public abstract String getName(int var1);

    public abstract long getLastRecordedLength(@NotNull VirtualFile var1);

    public abstract boolean isHidden(@NotNull VirtualFile var1);

    @Attributes
    public abstract int getFileAttributes(int var1);

    public static boolean isDirectory(@Attributes int attributes) {
        return BitUtil.isSet((int)attributes, (int)2);
    }

    public static boolean isWritable(@Attributes int attributes) {
        return !BitUtil.isSet((int)attributes, (int)4);
    }

    public static boolean isSymLink(@Attributes int attributes) {
        return BitUtil.isSet((int)attributes, (int)16);
    }

    public static boolean isSpecialFile(@Attributes int attributes) {
        return BitUtil.isSet((int)attributes, (int)32);
    }

    public static boolean isHidden(@Attributes int attributes) {
        return BitUtil.isSet((int)attributes, (int)64);
    }

    @Nullable
    public abstract NewVirtualFile findFileByIdIfCached(int var1);

    public abstract int storeUnlinkedContent(byte @NotNull [] var1);

    public abstract byte @NotNull [] contentsToByteArray(int var1) throws IOException;

    public abstract byte @NotNull [] contentsToByteArray(@NotNull VirtualFile var1, boolean var2) throws IOException;

    public abstract int acquireContent(@NotNull VirtualFile var1);

    public abstract void releaseContent(int var1);

    public abstract int getCurrentContentId(@NotNull VirtualFile var1);

    public abstract void processEvents(@NotNull List<? extends VFileEvent> var1);

    @NotNull
    public static NewVirtualFileSystem replaceWithNativeFS(@NotNull NewVirtualFileSystem fs) {
        if (SystemInfo.isWindows && !(fs instanceof Win32LocalFileSystem) && fs.getProtocol().equals("file") && Win32LocalFileSystem.isAvailable()) {
            return Win32LocalFileSystem.getWin32Instance();
        }
        return fs;
    }

    public abstract boolean mayHaveChildren(int var1);

    @NotNull
    public static FileAttributes toFileAttributes(@Attributes int attr) {
        return new FileAttributes(PersistentFS.isDirectory(attr), PersistentFS.isSpecialFile(attr), PersistentFS.isSymLink(attr), PersistentFS.isHidden(attr), -1L, -1L, PersistentFS.isWritable(attr));
    }

    public static @interface Attributes {
    }
}

