/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.local;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public class CoreLocalVirtualFile
extends VirtualFile {
    private final CoreLocalFileSystem myFileSystem;
    private final File myIoFile;
    private VirtualFile[] myChildren;
    private final NotNullLazyValue<Boolean> myIsDirectory;

    public CoreLocalVirtualFile(@NotNull CoreLocalFileSystem fileSystem, @NotNull File ioFile) {
        this.myFileSystem = fileSystem;
        this.myIoFile = ioFile;
        this.myIsDirectory = NotNullLazyValue.createValue(this.myIoFile::isDirectory);
    }

    public CoreLocalVirtualFile(@NotNull CoreLocalFileSystem fileSystem, @NotNull File ioFile, boolean isDirectory) {
        this.myFileSystem = fileSystem;
        this.myIoFile = ioFile;
        this.myIsDirectory = NotNullLazyValue.createConstantValue((Object)isDirectory);
    }

    @NotNull
    public String getName() {
        return this.myIoFile.getName();
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.myFileSystem;
    }

    @NotNull
    public String getPath() {
        return FileUtil.toSystemIndependentName((String)this.myIoFile.getAbsolutePath());
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isDirectory() {
        return (Boolean)this.myIsDirectory.getValue();
    }

    public boolean isValid() {
        return true;
    }

    public VirtualFile getParent() {
        File parentFile = this.myIoFile.getParentFile();
        return parentFile != null ? new CoreLocalVirtualFile(this.myFileSystem, parentFile, true) : null;
    }

    public VirtualFile[] getChildren() {
        VirtualFile[] answer = this.myChildren;
        if (answer == null) {
            File[] files2 = this.myIoFile.listFiles();
            if (files2 == null || files2.length == 0) {
                answer = EMPTY_ARRAY;
            } else {
                answer = new VirtualFile[files2.length];
                for (int i2 = 0; i2 < files2.length; ++i2) {
                    answer[i2] = new CoreLocalVirtualFile(this.myFileSystem, files2[i2]);
                }
            }
            this.myChildren = answer;
        }
        return answer;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte @NotNull [] contentsToByteArray() throws IOException {
        return FileUtil.loadFileBytes((File)this.myIoFile);
    }

    public long getTimeStamp() {
        return this.myIoFile.lastModified();
    }

    public long getLength() {
        return this.myIoFile.length();
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.inputStreamSkippingBOM((InputStream)new BufferedInputStream(new FileInputStream(this.myIoFile)), (VirtualFile)this);
    }

    public long getModificationStamp() {
        return 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CoreLocalVirtualFile that = (CoreLocalVirtualFile)((Object)o);
        return this.myIoFile.equals(that.myIoFile);
    }

    public int hashCode() {
        return this.myIoFile.hashCode();
    }
}

