/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePointerCapableFileSystem;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.impl.local.SymbolicLinkRefresher;
import com.intellij.openapi.vfs.impl.local.WatchRootsManager;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;

public final class LocalFileSystemImpl
extends LocalFileSystemBase
implements Disposable,
VirtualFilePointerCapableFileSystem {
    private static final int STATUS_UPDATE_PERIOD = 1000;
    private final ManagingFS myManagingFS = ManagingFS.getInstance();
    private final FileWatcher myWatcher = new FileWatcher(this.myManagingFS, () -> AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> {
        if (!ApplicationManager.getApplication().isDisposed()) {
            this.storeRefreshStatusToFiles();
        }
    }, 1000L, 1000L, TimeUnit.MILLISECONDS));
    private final WatchRootsManager myWatchRootsManager = new WatchRootsManager(this.myWatcher, this);
    private volatile boolean myDisposed;

    public LocalFileSystemImpl() {
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this);
        new SymbolicLinkRefresher(this);
    }

    @NotNull
    public FileWatcher getFileWatcher() {
        return this.myWatcher;
    }

    public void dispose() {
        this.myDisposed = true;
        this.myWatcher.dispose();
    }

    private void storeRefreshStatusToFiles() {
        if (this.myWatcher.isOperational()) {
            FileWatcher.DirtyPaths dirtyPaths = this.myWatcher.getDirtyPaths();
            this.markPathsDirty(dirtyPaths.dirtyPaths);
            this.markFlatDirsDirty(dirtyPaths.dirtyDirectories);
            this.markRecursiveDirsDirty(dirtyPaths.dirtyPathsRecursive);
        }
    }

    private void markPathsDirty(@NotNull Iterable<String> dirtyPaths) {
        for (String dirtyPath : dirtyPaths) {
            VirtualFile file2 = this.findFileByPathIfCached(dirtyPath);
            if (!(file2 instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)file2).markDirty();
        }
    }

    private void markFlatDirsDirty(@NotNull Iterable<String> dirtyPaths) {
        for (String dirtyPath : dirtyPaths) {
            Pair<NewVirtualFile, NewVirtualFile> pair = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)this, dirtyPath);
            if (pair.first != null) {
                ((NewVirtualFile)pair.first).markDirty();
                for (VirtualFile child2 : ((NewVirtualFile)pair.first).getCachedChildren()) {
                    ((NewVirtualFile)child2).markDirty();
                }
                continue;
            }
            if (pair.second == null) continue;
            ((NewVirtualFile)pair.second).markDirty();
        }
    }

    private void markRecursiveDirsDirty(@NotNull Iterable<String> dirtyPaths) {
        for (String dirtyPath : dirtyPaths) {
            Pair<NewVirtualFile, NewVirtualFile> pair = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)this, dirtyPath);
            if (pair.first != null) {
                ((NewVirtualFile)pair.first).markDirtyRecursively();
                continue;
            }
            if (pair.second == null) continue;
            ((NewVirtualFile)pair.second).markDirty();
        }
    }

    public void markSuspiciousFilesDirty(@NotNull List<? extends VirtualFile> files2) {
        this.storeRefreshStatusToFiles();
        if (this.myWatcher.isOperational()) {
            for (String string : this.myWatcher.getManualWatchRoots()) {
                VirtualFile suspiciousRoot = this.findFileByPathIfCached(string);
                if (suspiciousRoot == null) continue;
                ((NewVirtualFile)suspiciousRoot).markDirtyRecursively();
            }
        } else {
            for (VirtualFile virtualFile : files2) {
                if (virtualFile.getFileSystem() != this) continue;
                ((NewVirtualFile)virtualFile).markDirtyRecursively();
            }
        }
    }

    @NotNull
    public @NotNull Iterable<@NotNull VirtualFile> findCachedFilesForPath(@NotNull String path) {
        return ContainerUtil.mapNotNull(this.getAliasedPaths(path), this::findFileByPathIfCached);
    }

    @NotNull
    private @NotNull List<@NotNull @SystemDependent String> getAliasedPaths(@NotNull String path) {
        path = FileUtil.toSystemDependentName((String)path);
        ArrayList<@NotNull String> aliases = new ArrayList<String>(this.getFileWatcher().mapToAllSymlinks(path));
        assert (!aliases.contains(path));
        aliases.add(0, path);
        return aliases;
    }

    @NotNull
    public Set<LocalFileSystem.WatchRequest> replaceWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> watchRequestsToRemove, @Nullable Collection<String> recursiveRootsToAdd, @Nullable Collection<String> flatRootsToAdd) {
        if (this.myDisposed) {
            return Collections.emptySet();
        }
        List nonNullWatchRequestsToRemove = ContainerUtil.skipNulls(watchRequestsToRemove);
        LOG.assertTrue(nonNullWatchRequestsToRemove.size() == watchRequestsToRemove.size(), (Object)"watch requests collection should not contain `null` elements");
        return this.myWatchRootsManager.replaceWatchedRoots(nonNullWatchRequestsToRemove, (Collection)ObjectUtils.notNull(recursiveRootsToAdd, Collections.emptyList()), (Collection)ObjectUtils.notNull(flatRootsToAdd, Collections.emptyList()));
    }

    public void refreshWithoutFileWatcher(boolean asynchronous) {
        Runnable heavyRefresh = () -> {
            for (VirtualFile root : this.myManagingFS.getRoots((NewVirtualFileSystem)this)) {
                ((NewVirtualFile)root).markDirtyRecursively();
            }
            this.refresh(asynchronous);
        };
        if (asynchronous && this.myWatcher.isOperational()) {
            RefreshQueue.getInstance().refresh(true, true, heavyRefresh, this.myManagingFS.getRoots((NewVirtualFileSystem)this));
        } else {
            heavyRefresh.run();
        }
    }

    @ApiStatus.Internal
    public final void symlinkUpdated(int fileId, @Nullable VirtualFile parent, @NotNull String linkPath, @Nullable String linkTarget) {
        if (linkTarget == null || !LocalFileSystemImpl.isRecursiveOrCircularSymlink(linkPath, linkTarget, parent)) {
            this.myWatchRootsManager.updateSymlink(fileId, linkPath, linkTarget);
        }
    }

    @ApiStatus.Internal
    public final void symlinkRemoved(int fileId) {
        this.myWatchRootsManager.removeSymlink(fileId);
    }

    public String toString() {
        return "LocalFileSystem";
    }

    public void cleanupForNextTest() {
        FileDocumentManager.getInstance().saveAllDocuments();
        PersistentFS.getInstance().clearIdCache();
        this.myWatchRootsManager.clear();
    }

    private static boolean isRecursiveOrCircularSymlink(@NotNull String linkPath, @NotNull String symlinkTarget, @Nullable VirtualFile parent) {
        if (FileUtil.startsWith((String)linkPath, (String)symlinkTarget)) {
            return true;
        }
        if (!(parent instanceof VirtualFileSystemEntry)) {
            return false;
        }
        for (VirtualFileSystemEntry p = (VirtualFileSystemEntry)parent; p != null; p = p.getParent()) {
            String parentResolved;
            if (!p.hasSymlink()) {
                return false;
            }
            if (!p.is(VFileProperty.SYMLINK) || (parentResolved = p.getCanonicalPath()) == null || !symlinkTarget.equals(parentResolved)) continue;
            return true;
        }
        return false;
    }
}

