/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.application.options.RegistryManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.CanonicalPathMap;
import com.intellij.openapi.vfs.local.FileWatcherNotificationSink;
import com.intellij.openapi.vfs.local.PluggableFileWatcher;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileWatcher {
    private static final Logger LOG = Logger.getInstance(FileWatcher.class);
    public static final NotNullLazyValue<NotificationGroup> NOTIFICATION_GROUP = new NotNullLazyValue<NotificationGroup>(){

        @NotNull
        protected NotificationGroup compute() {
            return new NotificationGroup("File Watcher Messages", NotificationDisplayType.STICKY_BALLOON, true);
        }
    };
    private final ManagingFS myManagingFS;
    private final MyFileWatcherNotificationSink myNotificationSink;
    private final AtomicBoolean myFailureShown = new AtomicBoolean(false);
    private final ExecutorService myFileWatcherExecutor = FileWatcher.executor();
    private final AtomicReference<Future<?>> myLastTask = new AtomicReference<Object>(null);
    private volatile CanonicalPathMap myPathMap = CanonicalPathMap.empty();
    private volatile List<Collection<String>> myManualWatchRoots = Collections.emptyList();
    public static final String RESET = "(reset)";
    public static final String OTHER = "(other)";
    private volatile Consumer<? super String> myTestNotifier;

    @NotNull
    private static ExecutorService executor() {
        boolean async = RegistryManager.getInstance().is("vfs.filewatcher.works.in.async.way");
        return async ? AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"File Watcher", (int)1) : ConcurrencyUtil.newSameThreadExecutorService();
    }

    FileWatcher(@NotNull ManagingFS managingFS, @NotNull Runnable postInitCallback) {
        this.myManagingFS = managingFS;
        this.myNotificationSink = new MyFileWatcherNotificationSink();
        this.myFileWatcherExecutor.execute(() -> {
            PluggableFileWatcher.EP_NAME.forEachExtensionSafe(watcher -> watcher.initialize(this.myManagingFS, (FileWatcherNotificationSink)this.myNotificationSink));
            if (this.isOperational()) {
                postInitCallback.run();
            }
        });
    }

    public void dispose() {
        this.myFileWatcherExecutor.shutdown();
        Future<?> lastTask = this.myLastTask.get();
        if (lastTask != null) {
            lastTask.cancel(false);
        }
        try {
            this.myFileWatcherExecutor.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
        PluggableFileWatcher.EP_NAME.forEachExtensionSafe(watcher -> watcher.dispose());
    }

    public boolean isOperational() {
        for (PluggableFileWatcher watcher : PluggableFileWatcher.EP_NAME.getIterable()) {
            if (!watcher.isOperational()) continue;
            return true;
        }
        return false;
    }

    public boolean isSettingRoots() {
        Future<?> lastTask = this.myLastTask.get();
        if (lastTask != null && !lastTask.isDone()) {
            return true;
        }
        for (PluggableFileWatcher watcher : PluggableFileWatcher.EP_NAME.getIterable()) {
            if (!watcher.isSettingRoots()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    DirtyPaths getDirtyPaths() {
        return this.myNotificationSink.getDirtyPaths();
    }

    @NotNull
    public @NotNull Collection<@NotNull String> getManualWatchRoots() {
        List<Collection<String>> manualWatchRoots = this.myManualWatchRoots;
        Collection<String> result2 = null;
        for (Collection<String> roots : manualWatchRoots) {
            if (result2 == null) {
                result2 = new HashSet<String>(roots);
                continue;
            }
            result2.retainAll(roots);
        }
        return result2 != null ? result2 : Collections.emptyList();
    }

    void setWatchRoots(@NotNull Supplier<CanonicalPathMap> pathMapSupplier) {
        Future<?> prevTask = this.myLastTask.getAndSet(this.myFileWatcherExecutor.submit(() -> {
            try {
                CanonicalPathMap pathMap = (CanonicalPathMap)pathMapSupplier.get();
                if (pathMap == null) {
                    return;
                }
                this.myPathMap = pathMap;
                this.myManualWatchRoots = ContainerUtil.createLockFreeCopyOnWriteList();
                Pair<List<String>, List<String>> roots = pathMap.getCanonicalWatchRoots();
                PluggableFileWatcher.EP_NAME.forEachExtensionSafe(watcher -> watcher.setWatchRoots((List)roots.first, (List)roots.second));
            }
            catch (Error | RuntimeException e) {
                LOG.error(e);
            }
        }));
        if (prevTask != null) {
            prevTask.cancel(false);
        }
    }

    public void notifyOnFailure(@NotNull String cause, @Nullable NotificationListener listener2) {
        LOG.warn(cause);
        if (this.myFailureShown.compareAndSet(false, true)) {
            NotificationGroup group = (NotificationGroup)NOTIFICATION_GROUP.getValue();
            String title = ApplicationBundle.message((String)"watcher.slow.sync", (Object[])new Object[0]);
            ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)group.createNotification(title, cause, NotificationType.WARNING, listener2)), ModalityState.NON_MODAL);
        }
    }

    boolean belongsToWatchRoots(@NotNull String reportedPath, boolean isFile) {
        return this.myPathMap.belongsToWatchRoots(reportedPath, isFile);
    }

    @NotNull
    @NotNull Collection<@NotNull String> mapToAllSymlinks(@NotNull String reportedPath) {
        Collection<String> result2 = this.myPathMap.mapToOriginalWatchRoots(reportedPath, true);
        if (!result2.isEmpty()) {
            result2.remove(reportedPath);
        }
        return result2;
    }

    private void notifyOnEvent(String path) {
        Consumer<? super String> notifier = this.myTestNotifier;
        if (notifier != null) {
            notifier.accept(path);
        }
    }

    public void startup(@Nullable Consumer<? super String> notifier) throws Exception {
        this.myTestNotifier = notifier;
        this.myFileWatcherExecutor.submit(() -> {
            for (PluggableFileWatcher watcher : PluggableFileWatcher.EP_NAME.getIterable()) {
                watcher.startup();
            }
            return null;
        }).get();
    }

    public void shutdown() throws Exception {
        this.myFileWatcherExecutor.submit(() -> {
            for (PluggableFileWatcher watcher : PluggableFileWatcher.EP_NAME.getIterable()) {
                watcher.shutdown();
            }
            this.myTestNotifier = null;
            return null;
        }).get();
    }

    private final class MyFileWatcherNotificationSink
    implements FileWatcherNotificationSink {
        private final Object myLock = new Object();
        private DirtyPaths myDirtyPaths = new DirtyPaths();

        private MyFileWatcherNotificationSink() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        DirtyPaths getDirtyPaths() {
            DirtyPaths dirtyPaths = DirtyPaths.EMPTY;
            Object object = this.myLock;
            synchronized (object) {
                if (!this.myDirtyPaths.isEmpty()) {
                    dirtyPaths = this.myDirtyPaths;
                    this.myDirtyPaths = new DirtyPaths();
                }
            }
            PluggableFileWatcher.EP_NAME.forEachExtensionSafe(watcher -> watcher.resetChangedPaths());
            return dirtyPaths;
        }

        public void notifyManualWatchRoots(@NotNull Collection<String> roots) {
            FileWatcher.this.myManualWatchRoots.add(roots.isEmpty() ? Collections.emptySet() : new HashSet<String>(roots));
            FileWatcher.this.notifyOnEvent(FileWatcher.OTHER);
        }

        public void notifyMapping(@NotNull Collection<? extends Pair<String, String>> mapping2) {
            if (!mapping2.isEmpty()) {
                FileWatcher.this.myPathMap.addMapping(mapping2);
            }
            FileWatcher.this.notifyOnEvent(FileWatcher.OTHER);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyPath(@NotNull String path) {
            Collection<String> paths = FileWatcher.this.myPathMap.mapToOriginalWatchRoots(path, true);
            if (!paths.isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    for (String eachPath : paths) {
                        this.myDirtyPaths.addDirtyPath(eachPath);
                    }
                }
            }
            FileWatcher.this.notifyOnEvent(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyPathCreatedOrDeleted(@NotNull String path) {
            Collection<String> paths = FileWatcher.this.myPathMap.mapToOriginalWatchRoots(path, true);
            if (!paths.isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    for (String p : paths) {
                        this.myDirtyPaths.addDirtyPathRecursive(p);
                        String parentPath = new File(p).getParent();
                        if (parentPath == null) continue;
                        this.myDirtyPaths.addDirtyPath(parentPath);
                    }
                }
            }
            FileWatcher.this.notifyOnEvent(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyDirectory(@NotNull String path) {
            Collection<String> paths = FileWatcher.this.myPathMap.mapToOriginalWatchRoots(path, false);
            if (!paths.isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myDirtyPaths.dirtyDirectories.addAll(paths);
                }
            }
            FileWatcher.this.notifyOnEvent(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyDirtyPathRecursive(@NotNull String path) {
            Collection<String> paths = FileWatcher.this.myPathMap.mapToOriginalWatchRoots(path, false);
            if (!paths.isEmpty()) {
                Object object = this.myLock;
                synchronized (object) {
                    for (String each : paths) {
                        this.myDirtyPaths.addDirtyPathRecursive(each);
                    }
                }
            }
            FileWatcher.this.notifyOnEvent(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyReset(@Nullable String path) {
            if (path != null) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myDirtyPaths.addDirtyPathRecursive(path);
                }
            }
            VirtualFile[] roots = FileWatcher.this.myManagingFS.getLocalRoots();
            Object object = this.myLock;
            synchronized (object) {
                for (VirtualFile root : roots) {
                    this.myDirtyPaths.addDirtyPathRecursive(root.getPresentableUrl());
                }
            }
            FileWatcher.this.notifyOnEvent(FileWatcher.RESET);
        }

        public void notifyUserOnFailure(@NotNull String cause, @Nullable NotificationListener listener2) {
            FileWatcher.this.notifyOnFailure(cause, listener2);
        }
    }

    static final class DirtyPaths {
        final Set<String> dirtyPaths = new THashSet();
        final Set<String> dirtyPathsRecursive = new THashSet();
        final Set<String> dirtyDirectories = new THashSet();
        static final DirtyPaths EMPTY = new DirtyPaths();

        DirtyPaths() {
        }

        boolean isEmpty() {
            return this.dirtyPaths.isEmpty() && this.dirtyPathsRecursive.isEmpty() && this.dirtyDirectories.isEmpty();
        }

        void addDirtyPath(String path) {
            if (!this.dirtyPathsRecursive.contains(path)) {
                this.dirtyPaths.add(path);
            }
        }

        void addDirtyPathRecursive(String path) {
            this.dirtyPaths.remove(path);
            this.dirtyPathsRecursive.add(path);
        }
    }
}

