/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SdkListItem {
    private SdkListItem() {
    }

    public static final class GroupItem
    extends SdkListItem {
        final Icon myIcon;
        final String myCaption;
        final List<? extends SdkListItem> mySubItems;

        GroupItem(@NotNull Icon icon2, @NotNull String caption, @NotNull List<ActionItem> subItems) {
            this.myIcon = icon2;
            this.myCaption = caption;
            this.mySubItems = ImmutableList.copyOf((Collection)ContainerUtil.map(subItems, it -> it.withGroup(this)));
        }
    }

    public static final class ActionItem
    extends SdkListItem {
        @Nullable
        final GroupItem myGroup;
        @NotNull
        final ActionRole myRole;
        @NotNull
        final ProjectSdksModel.NewSdkAction myAction;

        ActionItem(@NotNull ActionRole role, @NotNull ProjectSdksModel.NewSdkAction action2, @Nullable GroupItem group) {
            this.myRole = role;
            this.myAction = action2;
            this.myGroup = group;
        }

        @NotNull
        public ActionRole getRole() {
            return this.myRole;
        }

        @NotNull
        public ProjectSdksModel.NewSdkAction getAction() {
            return this.myAction;
        }

        @NotNull
        ActionItem withGroup(@NotNull GroupItem group) {
            return new ActionItem(this.myRole, this.myAction, group);
        }
    }

    public static enum ActionRole {
        DOWNLOAD,
        ADD;

    }

    public static final class SuggestedItem
    extends SdkListItem {
        private final SdkType mySdkType;
        private final String myHomePath;
        private final String myVersion;

        SuggestedItem(@NotNull SdkType sdkType, @NotNull String version2, @NotNull String homePath) {
            this.mySdkType = sdkType;
            this.myHomePath = homePath;
            this.myVersion = version2;
        }

        @NotNull
        public SdkType getSdkType() {
            return this.mySdkType;
        }

        @NotNull
        public String getHomePath() {
            return this.myHomePath;
        }

        @NotNull
        public String getVersion() {
            return this.myVersion;
        }
    }

    public static final class InvalidSdkItem
    extends SdkListItem {
        private final String mySdkName;

        InvalidSdkItem(@NotNull String name) {
            this.mySdkName = name;
        }

        @NotNull
        public String getSdkName() {
            return this.mySdkName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InvalidSdkItem)) {
                return false;
            }
            InvalidSdkItem item = (InvalidSdkItem)o;
            return this.mySdkName.equals(item.mySdkName);
        }

        public int hashCode() {
            return Objects.hash(this.mySdkName);
        }
    }

    public static final class NoneSdkItem
    extends SdkListItem {
        public int hashCode() {
            return 42;
        }

        public boolean equals(Object obj) {
            return obj instanceof NoneSdkItem;
        }
    }

    public static final class ProjectSdkItem
    extends SdkListItem {
        public int hashCode() {
            return 42;
        }

        public boolean equals(Object obj) {
            return obj instanceof ProjectSdkItem;
        }
    }

    public static abstract class SdkItem
    extends SdkListItem {
        private final Sdk mySdk;

        SdkItem(@NotNull Sdk sdk2) {
            this.mySdk = sdk2;
        }

        @NotNull
        public final Sdk getSdk() {
            return this.mySdk;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SdkItem)) {
                return false;
            }
            SdkItem item = (SdkItem)o;
            return this.mySdk.equals(item.mySdk);
        }

        public final int hashCode() {
            return Objects.hash(this.mySdk);
        }

        abstract boolean hasSameSdk(@NotNull Sdk var1);
    }

    public static final class SdkReferenceItem
    extends SdkListItem {
        private final SdkType mySdkType;
        private final String myName;
        private final String myVersionString;
        private final boolean myHasValidPath;

        SdkReferenceItem(@NotNull SdkType sdkType, @NotNull String name, @Nullable String versionString, boolean hasValidPath) {
            this.mySdkType = sdkType;
            this.myName = name;
            this.myVersionString = versionString;
            this.myHasValidPath = hasValidPath;
        }

        @NotNull
        public SdkType getSdkType() {
            return this.mySdkType;
        }

        @NotNull
        public String getName() {
            return this.myName;
        }

        @Nullable
        public String getVersionString() {
            return this.myVersionString;
        }

        public boolean isValid() {
            return this.myHasValidPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SdkReferenceItem)) {
                return false;
            }
            SdkReferenceItem item = (SdkReferenceItem)o;
            return this.mySdkType.equals((Object)item.mySdkType) && this.myName.equals(item.myName);
        }

        public int hashCode() {
            return Objects.hash(this.mySdkType, this.myName);
        }
    }
}

