/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.RootFilter;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class DescendentBasedRootFilter
extends RootFilter {
    private final Predicate<? super VirtualFile> myCondition;

    public DescendentBasedRootFilter(OrderRootType rootType, boolean jarDirectory, String presentableRootTypeName, Predicate<? super VirtualFile> condition) {
        super(rootType, jarDirectory, presentableRootTypeName);
        this.myCondition = condition;
    }

    public static DescendentBasedRootFilter createFileTypeBasedFilter(OrderRootType rootType, boolean jarDirectory, @NotNull FileType fileType, String presentableRootTypeName) {
        return new DescendentBasedRootFilter(rootType, jarDirectory, presentableRootTypeName, file2 -> FileTypeRegistry.getInstance().isFileOfType(file2, fileType));
    }

    @Override
    public boolean isAccepted(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator2) {
        if (this.isJarDirectory()) {
            if (!rootCandidate.isDirectory() || !rootCandidate.isInLocalFileSystem()) {
                return false;
            }
            for (VirtualFile child2 : rootCandidate.getChildren()) {
                VirtualFile jarRoot;
                if (child2.isDirectory() || !FileTypeRegistry.getInstance().isFileOfType(child2, (FileType)ArchiveFileType.INSTANCE) || (jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(child2)) == null || !this.containsFileOfType(jarRoot, progressIndicator2)) continue;
                return true;
            }
            return false;
        }
        return this.containsFileOfType(rootCandidate, progressIndicator2);
    }

    private boolean containsFileOfType(VirtualFile rootCandidate, ProgressIndicator progressIndicator2) {
        return !VfsUtilCore.processFilesRecursively((VirtualFile)rootCandidate, virtualFile -> {
            progressIndicator2.checkCanceled();
            if (virtualFile.isDirectory()) {
                progressIndicator2.setText2(virtualFile.getPath());
                return true;
            }
            return !this.myCondition.test((VirtualFile)virtualFile);
        });
    }
}

