/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.InvalidDataException;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class LibraryTableImplUtil {
    @NonNls
    public static final String MODULE_LEVEL = "module";

    private LibraryTableImplUtil() {
    }

    @NotNull
    public static Library loadLibrary(@NotNull Element rootElement, @NotNull RootModelImpl rootModel) throws InvalidDataException {
        List children2 = rootElement.getChildren("library");
        if (children2.size() != 1) {
            throw new InvalidDataException();
        }
        Element element2 = (Element)children2.get(0);
        return new LibraryImpl(null, element2, (ModifiableRootModel)rootModel);
    }

    @NotNull
    public static Library createModuleLevelLibrary(@Nullable String name, PersistentLibraryKind kind, @NotNull RootModelImpl rootModel, @Nullable ProjectModelExternalSource externalSource) {
        return new LibraryImpl(name, kind, null, rootModel, externalSource);
    }

    public static boolean isValidLibrary(@NotNull Library library) {
        LibraryTable table = library.getTable();
        if (table != null) {
            String name = library.getName();
            return name != null && table.getLibraryByName(name) == library;
        }
        if (!(library instanceof LibraryEx)) {
            return false;
        }
        Module module = ((LibraryEx)library).getModule();
        if (module == null || module.isDisposed()) {
            return false;
        }
        for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            if (!(entry instanceof LibraryOrderEntry) || ((LibraryOrderEntry)entry).getLibrary() != library) continue;
            return true;
        }
        return false;
    }
}

