/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.UnknownLibraryKind;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

final class LibraryKindLoader
implements ApplicationInitializedListener {
    LibraryKindLoader() {
    }

    public void componentsInitialized() {
        LibraryType.EP_NAME.getExtensionList();
        LibraryType.EP_NAME.addExtensionPointListener(new ExtensionPointListener<LibraryType<?>>(){

            public void extensionAdded(@NotNull LibraryType<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                WriteAction.run(() -> {
                    LibraryKind.registerKind(extension.getKind());
                    LibraryKindLoader.processAllLibraries(library -> LibraryKindLoader.rememberKind(extension.getKind(), library));
                });
            }

            public void extensionRemoved(@NotNull LibraryType<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                LibraryKind.unregisterKind(extension.getKind());
                LibraryKindLoader.processAllLibraries(library -> LibraryKindLoader.forgetKind(extension.getKind(), library));
            }
        }, null);
    }

    private static void processAllLibraries(@NotNull Consumer<Library> processor2) {
        LibraryKindLoader.processLibraries(LibraryTablesRegistrar.getInstance().getLibraryTable(), processor2);
        for (LibraryTable table : LibraryTablesRegistrar.getInstance().getCustomLibraryTables()) {
            LibraryKindLoader.processLibraries(table, processor2);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            LibraryKindLoader.processLibraries(LibraryTablesRegistrar.getInstance().getLibraryTable(project), processor2);
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                for (Library library : OrderEntryUtil.getModuleLibraries((ModuleRootModel)ModuleRootManager.getInstance((Module)module))) {
                    processor2.accept(library);
                }
            }
        }
    }

    private static void processLibraries(@NotNull LibraryTable table, Consumer<Library> processor2) {
        for (Library library : table.getLibraries()) {
            processor2.accept(library);
        }
    }

    private static void forgetKind(@NotNull PersistentLibraryKind<?> kind, @NotNull Library library) {
        if (kind.equals((Object)((LibraryEx)library).getKind())) {
            LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
            model.forgetKind();
            model.commit();
        }
    }

    private static void rememberKind(@NotNull PersistentLibraryKind<?> kind, @NotNull Library library) {
        PersistentLibraryKind libraryKind = ((LibraryEx)library).getKind();
        if (libraryKind instanceof UnknownLibraryKind && libraryKind.getKindId().equals(kind.getKindId())) {
            LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
            model.restoreKind();
            model.commit();
        }
    }
}

