/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.impl.libraries.UnknownLibraryKind;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class LibraryImpl
extends TraceableDisposable
implements LibraryEx.ModifiableModelEx,
LibraryEx,
RootProvider {
    private static final Logger LOG = Logger.getInstance(LibraryImpl.class);
    private static final String EXCLUDED_ROOTS_TAG = "excluded";
    private String myName;
    private final LibraryTable myLibraryTable;
    private final Map<OrderRootType, VirtualFilePointerContainer> myRoots = new HashMap<OrderRootType, VirtualFilePointerContainer>(3);
    @Nullable
    private VirtualFilePointerContainer myExcludedRoots;
    private final LibraryImpl mySource;
    private PersistentLibraryKind<?> myKind;
    private LibraryProperties myProperties;
    @Nullable
    private final ModifiableRootModel myRootModel;
    private boolean myDisposed;
    private final Disposable myPointersDisposable = Disposer.newDisposable();
    private final ProjectModelExternalSource myExternalSource;
    private final EventDispatcher<RootProvider.RootSetChangedListener> myDispatcher = EventDispatcher.create(RootProvider.RootSetChangedListener.class);
    @NonNls
    public static final String ROOT_TYPE_ATTR = "type";
    private static final OrderRootType DEFAULT_JAR_DIRECTORY_TYPE = OrderRootType.CLASSES;

    LibraryImpl(LibraryTable table, @NotNull Element element2, ModifiableRootModel rootModel) throws InvalidDataException {
        this(table, rootModel, null, null, LibraryImpl.findPersistentLibraryKind(element2), LibraryImpl.findExternalSource(element2));
        this.readExternal(element2);
    }

    LibraryImpl(String name, @Nullable PersistentLibraryKind<?> kind, LibraryTable table, ModifiableRootModel rootModel, ProjectModelExternalSource externalSource) {
        this(table, rootModel, null, name, kind, externalSource);
        if (kind != null) {
            this.myProperties = kind.createDefaultProperties();
        }
    }

    private LibraryImpl(@NotNull LibraryImpl from, LibraryImpl newSource, ModifiableRootModel rootModel) {
        this(from.myLibraryTable, rootModel, newSource, from.myName, from.myKind, from.myExternalSource);
        from.checkDisposed();
        if (from.myKind != null && from.myProperties != null) {
            this.myProperties = this.myKind.createDefaultProperties();
            Object state = from.myProperties.getState();
            if (state != null) {
                this.myProperties.loadState(state);
            }
        }
        for (OrderRootType rootType : this.getAllRootTypes()) {
            VirtualFilePointerContainer thatContainer = from.myRoots.get(rootType);
            if (thatContainer == null || thatContainer.isEmpty()) continue;
            this.getOrCreateContainer(rootType).addAll(thatContainer);
        }
        if (from.myExcludedRoots != null) {
            this.myExcludedRoots = from.myExcludedRoots.clone(this.myPointersDisposable);
        }
    }

    private LibraryImpl(LibraryTable table, @Nullable ModifiableRootModel rootModel, LibraryImpl newSource, String name, @Nullable PersistentLibraryKind<?> kind, @Nullable ProjectModelExternalSource externalSource) {
        super(true);
        this.myLibraryTable = table;
        this.myRootModel = rootModel;
        this.mySource = newSource;
        this.myKind = kind;
        this.myName = name;
        this.myExternalSource = externalSource;
        Disposer.register((Disposable)this, (Disposable)this.myPointersDisposable);
    }

    @Nullable
    private static ProjectModelExternalSource findExternalSource(@NotNull Element element2) {
        @Nullable String externalSourceId = element2.getAttributeValue("__external-system-id");
        return externalSourceId != null ? ExternalProjectSystemRegistry.getInstance().getSourceById(externalSourceId) : null;
    }

    @Nullable
    private static PersistentLibraryKind<?> findPersistentLibraryKind(@NotNull Element element2) {
        String typeString = element2.getAttributeValue(ROOT_TYPE_ATTR);
        if (typeString == null) {
            return null;
        }
        LibraryKind kind = LibraryKind.findById((String)typeString);
        if (kind == null) {
            return UnknownLibraryKind.getOrCreate(typeString);
        }
        if (!(kind instanceof PersistentLibraryKind)) {
            LOG.error("Cannot load non-persistable library kind: " + typeString);
            return null;
        }
        return (PersistentLibraryKind)kind;
    }

    @NotNull
    private Set<OrderRootType> getAllRootTypes() {
        Set rootTypes = ContainerUtil.set((Object[])OrderRootType.getAllTypes());
        if (this.myKind != null) {
            rootTypes.addAll(Arrays.asList(this.myKind.getAdditionalRootTypes()));
        }
        return rootTypes;
    }

    public void dispose() {
        this.checkDisposed();
        this.myDisposed = true;
        this.kill(null);
    }

    private void checkDisposed() {
        if (this.isDisposed()) {
            this.throwDisposalError("'" + this.myName + "' already disposed: " + this.getStackTrace());
        }
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public String getName() {
        return this.myName;
    }

    public String @NotNull [] getUrls(@NotNull OrderRootType rootType) {
        this.checkDisposed();
        VirtualFilePointerContainer result2 = this.myRoots.get(rootType);
        return result2 == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : result2.getUrls();
    }

    public VirtualFile @NotNull [] getFiles(@NotNull OrderRootType rootType) {
        this.checkDisposed();
        VirtualFilePointerContainer container2 = this.myRoots.get(rootType);
        return container2 == null ? VirtualFile.EMPTY_ARRAY : container2.getFiles();
    }

    public void setName(String name) {
        LOG.assertTrue(this.isWritable());
        this.myName = name;
    }

    @NotNull
    public LibraryEx.ModifiableModelEx getModifiableModel() {
        this.checkDisposed();
        return new LibraryImpl(this, this, this.myRootModel);
    }

    @NotNull
    public Library cloneLibrary(@NotNull RootModelImpl rootModel) {
        LOG.assertTrue(this.myLibraryTable == null);
        return new LibraryImpl(this, null, (ModifiableRootModel)rootModel);
    }

    @NotNull
    public List<String> getInvalidRootUrls(@NotNull OrderRootType type) {
        if (this.myDisposed) {
            return Collections.emptyList();
        }
        VirtualFilePointerContainer container2 = this.myRoots.get(type);
        List pointers2 = container2 == null ? Collections.emptyList() : container2.getList();
        SmartList invalidPaths = null;
        for (VirtualFilePointer pointer : pointers2) {
            if (pointer.isValid()) continue;
            if (invalidPaths == null) {
                invalidPaths = new SmartList();
            }
            invalidPaths.add(pointer.getUrl());
        }
        return ContainerUtil.notNullize(invalidPaths);
    }

    public void setProperties(LibraryProperties properties) {
        LOG.assertTrue(this.isWritable());
        this.myProperties = properties;
    }

    @NotNull
    public RootProvider getRootProvider() {
        return this;
    }

    @NotNull
    private VirtualFilePointerListener getListener() {
        Project project;
        Project project2 = project = this.myLibraryTable instanceof ProjectLibraryTable ? ((ProjectLibraryTable)this.myLibraryTable).getProject() : null;
        return this.myRootModel != null ? ((RootModelImpl)this.myRootModel).getRootsChangedListener() : (project != null ? ProjectRootManagerImpl.getInstanceImpl(project).getRootsValidityChangedListener() : ProjectJdkImpl.getGlobalVirtualFilePointerListener());
    }

    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        return this.myExternalSource;
    }

    public void readExternal(Element element2) throws InvalidDataException {
        this.readName(element2);
        this.readProperties(element2);
        this.readRoots(element2);
        this.readJarDirectories(element2);
    }

    @NotNull
    private VirtualFilePointerContainer getOrCreateContainer(@NotNull OrderRootType rootType) {
        VirtualFilePointerContainer roots = this.myRoots.get(rootType);
        if (roots == null) {
            roots = VirtualFilePointerManager.getInstance().createContainer(this.myPointersDisposable, this.getListener());
            this.myRoots.put(rootType, roots);
        }
        return roots;
    }

    @Deprecated
    private void readJarDirectories(@NotNull Element element2) {
        List jarDirs = element2.getChildren("jarDirectory");
        for (Element jarDir : jarDirs) {
            String url = jarDir.getAttributeValue("url");
            if (url == null) continue;
            String recursive = jarDir.getAttributeValue("recursive");
            OrderRootType rootType = LibraryImpl.getJarDirectoryRootType(jarDir.getAttributeValue(ROOT_TYPE_ATTR));
            VirtualFilePointerContainer roots = this.getOrCreateContainer(rootType);
            boolean recursively = Boolean.parseBoolean(recursive);
            roots.addJarDirectory(url, recursively);
        }
    }

    @NotNull
    private static OrderRootType getJarDirectoryRootType(@Nullable String type) {
        for (PersistentOrderRootType rootType : OrderRootType.getAllPersistentTypes()) {
            if (!rootType.name().equals(type)) continue;
            return rootType;
        }
        return DEFAULT_JAR_DIRECTORY_TYPE;
    }

    private void readProperties(@NotNull Element element2) {
        String typeId = element2.getAttributeValue(ROOT_TYPE_ATTR);
        if (typeId == null) {
            return;
        }
        this.myKind = (PersistentLibraryKind)LibraryKind.findById((String)typeId);
        Element propertiesElement = element2.getChild("properties");
        if (this.myKind == null) {
            this.myKind = UnknownLibraryKind.getOrCreate(typeId);
            UnknownLibraryKind.UnknownLibraryProperties properties = new UnknownLibraryKind.UnknownLibraryProperties();
            properties.setConfiguration(propertiesElement);
            this.myProperties = properties;
            return;
        }
        this.myProperties = this.myKind.createDefaultProperties();
        if (propertiesElement != null) {
            ComponentSerializationUtil.loadComponentState((PersistentStateComponent)this.myProperties, (Element)propertiesElement);
        }
    }

    private void readName(@NotNull Element element2) {
        this.myName = element2.getAttributeValue("name");
    }

    private void readRoots(@NotNull Element element2) throws InvalidDataException {
        for (OrderRootType rootType : this.getAllRootTypes()) {
            Element rootChild = element2.getChild(rootType.name());
            if (rootChild == null || rootChild.getChildren("root").isEmpty()) continue;
            VirtualFilePointerContainer roots = this.getOrCreateContainer(rootType);
            roots.readExternal(rootChild, "root", false);
        }
        Element excludedRoot = element2.getChild(EXCLUDED_ROOTS_TAG);
        if (excludedRoot != null && !excludedRoot.getChildren("root").isEmpty()) {
            this.getOrCreateExcludedRoots().readExternal(excludedRoot, "root", false);
        }
    }

    @NotNull
    private VirtualFilePointerContainer getOrCreateExcludedRoots() {
        VirtualFilePointerContainer excludedRoots = this.myExcludedRoots;
        if (excludedRoots == null) {
            this.myExcludedRoots = excludedRoots = VirtualFilePointerManager.getInstance().createContainer(this.myPointersDisposable);
        }
        return excludedRoots;
    }

    @NotNull
    private static List<OrderRootType> sortRootTypes(@NotNull Collection<? extends OrderRootType> rootTypes) {
        ArrayList<OrderRootType> allTypes = new ArrayList<OrderRootType>(rootTypes);
        allTypes.sort((o1, o2) -> o1.name().compareToIgnoreCase(o2.name()));
        return allTypes;
    }

    public void writeExternal(Element rootElement) {
        Module module;
        Object project;
        this.checkDisposed();
        Element element2 = new Element("library");
        if (this.myName != null) {
            element2.setAttribute("name", this.myName);
        }
        if (this.myKind != null) {
            element2.setAttribute(ROOT_TYPE_ATTR, this.myKind.getKindId());
            LOG.assertTrue(this.myProperties != null, (Object)("Properties is 'null' in library with kind " + this.myKind));
            Object state = this.myProperties.getState();
            if (state != null) {
                Element propertiesElement;
                Element element3 = propertiesElement = state instanceof Element ? ((Element)state).clone() : XmlSerializer.serialize((Object)state);
                if (propertiesElement != null) {
                    element2.addContent(propertiesElement.setName("properties"));
                }
            }
        }
        if (this.myExternalSource != null && ProjectUtilCore.isExternalStorageEnabled((Project)(project = (module = this.getModule()) == null ? (this.myLibraryTable instanceof ProjectLibraryTable ? ((ProjectLibraryTable)this.myLibraryTable).getProject() : null) : module.getProject()))) {
            element2.setAttribute("__external-system-id", this.myExternalSource.getId());
        }
        ArrayList<OrderRootType> storableRootTypes = new ArrayList<OrderRootType>(Arrays.asList(OrderRootType.getAllTypes()));
        if (this.myKind != null) {
            storableRootTypes.addAll(Arrays.asList(this.myKind.getAdditionalRootTypes()));
        }
        for (OrderRootType rootType : LibraryImpl.sortRootTypes(storableRootTypes)) {
            VirtualFilePointerContainer roots = this.myRoots.get(rootType);
            if ((roots == null || roots.isEmpty()) && rootType.skipWriteIfEmpty()) continue;
            Element rootTypeElement = new Element(rootType.name());
            if (roots != null) {
                roots.writeExternal(rootTypeElement, "root", false);
            }
            element2.addContent(rootTypeElement);
        }
        if (this.myExcludedRoots != null && !this.myExcludedRoots.isEmpty()) {
            Element excluded = new Element(EXCLUDED_ROOTS_TAG);
            this.myExcludedRoots.writeExternal(excluded, "root", false);
            element2.addContent(excluded);
        }
        this.writeJarDirectories(element2);
        rootElement.addContent(element2);
    }

    @Deprecated
    private void writeJarDirectories(@NotNull Element element2) {
        List<OrderRootType> rootTypes = LibraryImpl.sortRootTypes(this.myRoots.keySet());
        for (OrderRootType rootType : rootTypes) {
            VirtualFilePointerContainer container2 = this.myRoots.get(rootType);
            ArrayList<Pair> jarDirectories = new ArrayList<Pair>(container2.getJarDirectories());
            jarDirectories.sort(Comparator.comparing(p -> (String)p.getFirst(), String.CASE_INSENSITIVE_ORDER));
            for (Pair pair : jarDirectories) {
                String url = (String)pair.getFirst();
                boolean isRecursive = (Boolean)pair.getSecond();
                Element jarDirElement = new Element("jarDirectory");
                jarDirElement.setAttribute("url", url);
                jarDirElement.setAttribute("recursive", Boolean.toString(isRecursive));
                if (!rootType.equals((Object)DEFAULT_JAR_DIRECTORY_TYPE)) {
                    jarDirElement.setAttribute(ROOT_TYPE_ATTR, rootType.name());
                }
                element2.addContent(jarDirElement);
            }
        }
    }

    private boolean isWritable() {
        return this.mySource != null;
    }

    @Nullable
    public PersistentLibraryKind<?> getKind() {
        return this.myKind;
    }

    public void forgetKind() {
        if (this.myKind == null) {
            return;
        }
        this.myKind = UnknownLibraryKind.getOrCreate(this.myKind.getKindId());
        Object propertiesState = this.myProperties.getState();
        if (propertiesState != null) {
            UnknownLibraryKind.UnknownLibraryProperties properties = new UnknownLibraryKind.UnknownLibraryProperties();
            properties.setConfiguration(XmlSerializer.serialize((Object)propertiesState));
            this.myProperties = properties;
        } else {
            this.myProperties = null;
        }
    }

    public void restoreKind() {
        if (this.myKind == null || !(this.myKind instanceof UnknownLibraryKind)) {
            return;
        }
        this.myKind = (PersistentLibraryKind)LibraryKind.findById((String)this.myKind.getKindId());
        Element configuration = ((UnknownLibraryKind.UnknownLibraryProperties)this.myProperties).getConfiguration();
        this.myProperties = this.myKind.createDefaultProperties();
        if (configuration != null) {
            ComponentSerializationUtil.loadComponentState((PersistentStateComponent)this.myProperties, (Element)configuration);
        }
    }

    public void addExcludedRoot(@NotNull String url) {
        VirtualFilePointerContainer roots = this.getOrCreateExcludedRoots();
        if (roots.findByUrl(url) == null) {
            roots.add(url);
        }
    }

    public boolean removeExcludedRoot(@NotNull String url) {
        VirtualFilePointer pointer;
        if (this.myExcludedRoots != null && (pointer = this.myExcludedRoots.findByUrl(url)) != null) {
            this.myExcludedRoots.remove(pointer);
            return true;
        }
        return false;
    }

    public String @NotNull [] getExcludedRootUrls() {
        return this.myExcludedRoots != null ? this.myExcludedRoots.getUrls() : ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public VirtualFile @NotNull [] getExcludedRoots() {
        return this.myExcludedRoots != null ? this.myExcludedRoots.getFiles() : VirtualFile.EMPTY_ARRAY;
    }

    public LibraryProperties getProperties() {
        return this.myProperties;
    }

    public void setKind(@NotNull PersistentLibraryKind<?> kind) {
        LOG.assertTrue(this.isWritable());
        LOG.assertTrue(this.myKind == null || this.myKind == kind, (Object)("Library kind cannot be changed from " + this.myKind + " to " + kind));
        this.myKind = kind;
        this.myProperties = kind.createDefaultProperties();
    }

    public void addRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container2 = this.getOrCreateContainer(rootType);
        container2.add(url);
    }

    public void addRoot(@NotNull VirtualFile file2, @NotNull OrderRootType rootType) {
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container2 = this.getOrCreateContainer(rootType);
        container2.add(file2);
    }

    public void addJarDirectory(@NotNull String url, boolean recursive) {
        this.addJarDirectory(url, recursive, OrderRootType.CLASSES);
    }

    public void addJarDirectory(@NotNull VirtualFile file2, boolean recursive) {
        this.addJarDirectory(file2, recursive, OrderRootType.CLASSES);
    }

    public void addJarDirectory(@NotNull String url, boolean recursive, @NotNull OrderRootType rootType) {
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container2 = this.getOrCreateContainer(rootType);
        container2.addJarDirectory(url, recursive);
    }

    public void addJarDirectory(@NotNull VirtualFile file2, boolean recursive, @NotNull OrderRootType rootType) {
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container2 = this.getOrCreateContainer(rootType);
        container2.addJarDirectory(file2.getUrl(), recursive);
    }

    public boolean isJarDirectory(@NotNull String url) {
        return this.isJarDirectory(url, OrderRootType.CLASSES);
    }

    public boolean isJarDirectory(@NotNull String url, @NotNull OrderRootType rootType) {
        VirtualFilePointerContainer container2 = this.myRoots.get(rootType);
        if (container2 == null) {
            return false;
        }
        List jarDirectories = container2.getJarDirectories();
        return jarDirectories.contains(Pair.create((Object)url, (Object)false)) || jarDirectories.contains(Pair.create((Object)url, (Object)true));
    }

    public boolean isValid(@NotNull String url, @NotNull OrderRootType rootType) {
        VirtualFilePointerContainer container2 = this.myRoots.get(rootType);
        VirtualFilePointer fp = container2 == null ? null : container2.findByUrl(url);
        return fp != null && fp.isValid();
    }

    public boolean removeRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        VirtualFilePointer byUrl;
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container2 = this.myRoots.get(rootType);
        VirtualFilePointer virtualFilePointer = byUrl = container2 == null ? null : container2.findByUrl(url);
        if (byUrl != null) {
            container2.remove(byUrl);
            if (this.myExcludedRoots != null) {
                for (String excludedRoot : this.myExcludedRoots.getUrls()) {
                    VirtualFilePointer pointer;
                    if (this.isUnderRoots(excludedRoot) || (pointer = this.myExcludedRoots.findByUrl(excludedRoot)) == null) continue;
                    this.myExcludedRoots.remove(pointer);
                }
            }
            container2.removeJarDirectory(url);
            return true;
        }
        return false;
    }

    private boolean isUnderRoots(@NotNull String url) {
        for (VirtualFilePointerContainer container2 : this.myRoots.values()) {
            if (!VfsUtilCore.isUnder((String)url, Arrays.asList(container2.getUrls()))) continue;
            return true;
        }
        return false;
    }

    public void moveRootUp(@NotNull String url, @NotNull OrderRootType rootType) {
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container2 = this.myRoots.get(rootType);
        if (container2 != null) {
            container2.moveUp(url);
        }
    }

    public void moveRootDown(@NotNull String url, @NotNull OrderRootType rootType) {
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container2 = this.myRoots.get(rootType);
        if (container2 != null) {
            container2.moveDown(url);
        }
    }

    public boolean isChanged() {
        return !this.mySource.equals((Object)this);
    }

    private boolean areRootsChanged(@NotNull LibraryImpl that) {
        return !that.equals((Object)this);
    }

    public Library getSource() {
        return this.mySource;
    }

    public void commit() {
        this.checkDisposed();
        if (this.isChanged()) {
            this.mySource.commit(this);
        }
        Disposer.dispose((Disposable)this);
    }

    private void commit(@NotNull LibraryImpl fromModel) {
        if (this.myLibraryTable != null) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
        }
        if (!Objects.equals(fromModel.myName, this.myName)) {
            String oldName = this.myName;
            this.myName = fromModel.myName;
            if (this.myLibraryTable instanceof LibraryTableBase) {
                ((LibraryTableBase)this.myLibraryTable).fireLibraryRenamed(this, oldName);
            }
        }
        this.myKind = fromModel.getKind();
        this.myProperties = fromModel.myProperties;
        if (this.areRootsChanged(fromModel)) {
            this.disposeMyPointers();
            this.copyRootsFrom(fromModel);
            this.fireRootSetChanged();
        }
    }

    private void copyRootsFrom(@NotNull LibraryImpl fromModel) {
        HashMap<OrderRootType, VirtualFilePointerContainer> clonedRoots = new HashMap<OrderRootType, VirtualFilePointerContainer>();
        for (Map.Entry<OrderRootType, VirtualFilePointerContainer> entry : fromModel.myRoots.entrySet()) {
            OrderRootType rootType = entry.getKey();
            VirtualFilePointerContainer container2 = entry.getValue();
            VirtualFilePointerContainer clone = container2.clone(this.myPointersDisposable, this.getListener());
            clonedRoots.put(rootType, clone);
        }
        this.myRoots.clear();
        this.myRoots.putAll(clonedRoots);
        VirtualFilePointerContainer excludedRoots = fromModel.myExcludedRoots;
        this.myExcludedRoots = excludedRoots != null ? excludedRoots.clone(this.myPointersDisposable) : null;
    }

    private void disposeMyPointers() {
        for (VirtualFilePointerContainer container2 : new THashSet(this.myRoots.values())) {
            container2.killAll();
        }
        if (this.myExcludedRoots != null) {
            this.myExcludedRoots.killAll();
        }
        Disposer.dispose((Disposable)this.myPointersDisposable);
        Disposer.register((Disposable)this, (Disposable)this.myPointersDisposable);
    }

    public LibraryTable getTable() {
        return this.myLibraryTable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LibraryImpl library = (LibraryImpl)((Object)o);
        if (!Objects.equals(this.myName, library.myName)) {
            return false;
        }
        if (!this.myRoots.equals(library.myRoots)) {
            return false;
        }
        if (!Objects.equals(this.myKind, library.myKind)) {
            return false;
        }
        if (!Objects.equals(this.myProperties, library.myProperties)) {
            return false;
        }
        return Comparing.equal((Object)this.myExcludedRoots, (Object)library.myExcludedRoots);
    }

    public int hashCode() {
        int result2 = this.myName != null ? this.myName.hashCode() : 0;
        result2 = 31 * result2 + this.myRoots.hashCode();
        return result2;
    }

    @NonNls
    public String toString() {
        return "Library: name:" + this.myName + "; roots:" + this.myRoots.values();
    }

    @Nullable(value="will return non-null value only for module level libraries")
    public @Nullable(value="will return non-null value only for module level libraries") Module getModule() {
        return this.myRootModel == null ? null : this.myRootModel.getModule();
    }

    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void removeRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2, @NotNull Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    private void fireRootSetChanged() {
        ((RootProvider.RootSetChangedListener)this.myDispatcher.getMulticaster()).rootSetChanged((RootProvider)this);
    }
}

