/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OrderEntryUtil {
    private OrderEntryUtil() {
    }

    @Nullable
    public static LibraryOrderEntry findLibraryOrderEntry(@NotNull ModuleRootModel model, @Nullable Library library) {
        if (library == null) {
            return null;
        }
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry) || !library.equals(((LibraryOrderEntry)orderEntry).getLibrary())) continue;
            return (LibraryOrderEntry)orderEntry;
        }
        return null;
    }

    @Nullable
    public static LibraryOrderEntry findLibraryOrderEntry(@NotNull ModuleRootModel model, @NotNull String libraryName) {
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            String libName;
            if (!(orderEntry instanceof LibraryOrderEntry) || !libraryName.equals(libName = ((LibraryOrderEntry)orderEntry).getLibraryName())) continue;
            return (LibraryOrderEntry)orderEntry;
        }
        return null;
    }

    @Nullable
    public static ModuleOrderEntry findModuleOrderEntry(@NotNull ModuleRootModel model, @Nullable Module module) {
        if (module == null) {
            return null;
        }
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            if (!(orderEntry instanceof ModuleOrderEntry) || !module.equals(((ModuleOrderEntry)orderEntry).getModule())) continue;
            return (ModuleOrderEntry)orderEntry;
        }
        return null;
    }

    @Nullable
    public static JdkOrderEntry findJdkOrderEntry(@NotNull ModuleRootModel model, @Nullable Sdk sdk2) {
        if (sdk2 == null) {
            return null;
        }
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            if (!(orderEntry instanceof JdkOrderEntry) || !sdk2.equals(((JdkOrderEntry)orderEntry).getJdk())) continue;
            return (JdkOrderEntry)orderEntry;
        }
        return null;
    }

    public static boolean equals(OrderEntry orderEntry1, OrderEntry orderEntry2) {
        if (orderEntry1 instanceof JdkOrderEntry && orderEntry2 instanceof JdkOrderEntry) {
            JdkOrderEntry jdkOrderEntry1 = (JdkOrderEntry)orderEntry1;
            JdkOrderEntry jdkOrderEntry2 = (JdkOrderEntry)orderEntry2;
            return Comparing.equal((Object)jdkOrderEntry1.getJdk(), (Object)jdkOrderEntry2.getJdk()) && Comparing.strEqual((String)jdkOrderEntry1.getJdkName(), (String)jdkOrderEntry2.getJdkName());
        }
        if (orderEntry1 instanceof LibraryOrderEntry && orderEntry2 instanceof LibraryOrderEntry) {
            LibraryOrderEntry jdkOrderEntry1 = (LibraryOrderEntry)orderEntry1;
            LibraryOrderEntry jdkOrderEntry2 = (LibraryOrderEntry)orderEntry2;
            return Comparing.equal((Object)jdkOrderEntry1.getLibrary(), (Object)jdkOrderEntry2.getLibrary());
        }
        if (orderEntry1 instanceof ModuleSourceOrderEntry && orderEntry2 instanceof ModuleSourceOrderEntry) {
            ModuleSourceOrderEntry jdkOrderEntry1 = (ModuleSourceOrderEntry)orderEntry1;
            ModuleSourceOrderEntry jdkOrderEntry2 = (ModuleSourceOrderEntry)orderEntry2;
            return Comparing.equal((Object)jdkOrderEntry1.getOwnerModule(), (Object)jdkOrderEntry2.getOwnerModule());
        }
        if (orderEntry1 instanceof ModuleOrderEntry && orderEntry2 instanceof ModuleOrderEntry) {
            ModuleOrderEntry jdkOrderEntry1 = (ModuleOrderEntry)orderEntry1;
            ModuleOrderEntry jdkOrderEntry2 = (ModuleOrderEntry)orderEntry2;
            return Comparing.equal((Object)jdkOrderEntry1.getModule(), (Object)jdkOrderEntry2.getModule());
        }
        return false;
    }

    public static boolean equals(Library library1, Library library2) {
        if (library1 == library2) {
            return true;
        }
        if (library1 == null || library2 == null) {
            return false;
        }
        LibraryTable table = library1.getTable();
        if (table != null) {
            if (library2.getTable() != table) {
                return false;
            }
            String name = library1.getName();
            return name != null && name.equals(library2.getName());
        }
        if (library2.getTable() != null) {
            return false;
        }
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            if (Arrays.equals(library1.getUrls(type), library2.getUrls(type))) continue;
            return false;
        }
        return true;
    }

    public static void addLibraryToRoots(@NotNull LibraryOrderEntry libraryOrderEntry, @NotNull Module module) {
        Library library = libraryOrderEntry.getLibrary();
        if (library == null) {
            return;
        }
        OrderEntryUtil.addLibraryToRoots(module, library);
    }

    public static void addLibraryToRoots(@NotNull Module module, @NotNull Library library) {
        OrderEntryUtil.addLibraryToRoots(module, library, DependencyScope.COMPILE, false);
    }

    public static void addLibraryToRoots(@NotNull Module module, @NotNull Library library, @NotNull DependencyScope scope, boolean exported) {
        LibraryOrderEntry entry;
        ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        if (library.getTable() == null) {
            Library jarLibrary = rootModel.getModuleLibraryTable().createLibrary();
            Library.ModifiableModel libraryModel = jarLibrary.getModifiableModel();
            for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
                VirtualFile[] files2;
                for (VirtualFile jarFile : files2 = library.getFiles(orderRootType)) {
                    libraryModel.addRoot(jarFile, orderRootType);
                }
            }
            libraryModel.commit();
            entry = rootModel.findLibraryOrderEntry(jarLibrary);
        } else {
            entry = rootModel.addLibraryEntry(library);
        }
        if (entry != null) {
            entry.setScope(scope);
            entry.setExported(exported);
        }
        rootModel.commit();
    }

    private static int findLibraryOrderEntry(OrderEntry @NotNull [] entries, @NotNull Library library) {
        for (int i2 = 0; i2 < entries.length; ++i2) {
            OrderEntry entry = entries[i2];
            if (!(entry instanceof LibraryOrderEntry) || !library.equals(((LibraryOrderEntry)entry).getLibrary())) continue;
            return i2;
        }
        return -1;
    }

    public static void replaceLibrary(@NotNull ModifiableRootModel model, @NotNull Library oldLibrary, @NotNull Library newLibrary) {
        int i2 = OrderEntryUtil.findLibraryOrderEntry(model.getOrderEntries(), oldLibrary);
        if (i2 == -1) {
            return;
        }
        model.addLibraryEntry(newLibrary);
        OrderEntryUtil.replaceLibraryByAdded(model, i2);
    }

    public static void replaceLibraryEntryByAdded(@NotNull ModifiableRootModel model, @NotNull LibraryOrderEntry entry) {
        int i2 = ArrayUtil.indexOf((Object[])model.getOrderEntries(), (Object)entry);
        if (i2 == -1) {
            return;
        }
        OrderEntryUtil.replaceLibraryByAdded(model, i2);
    }

    private static void replaceLibraryByAdded(@NotNull ModifiableRootModel model, int toReplace) {
        OrderEntry[] entries = model.getOrderEntries();
        LibraryOrderEntry newEntry = (LibraryOrderEntry)entries[entries.length - 1];
        LibraryOrderEntry libraryEntry = (LibraryOrderEntry)entries[toReplace];
        boolean exported = libraryEntry.isExported();
        DependencyScope scope = libraryEntry.getScope();
        model.removeOrderEntry((OrderEntry)libraryEntry);
        newEntry.setExported(exported);
        newEntry.setScope(scope);
        OrderEntry[] newEntries = new OrderEntry[entries.length - 1];
        System.arraycopy(entries, 0, newEntries, 0, toReplace);
        newEntries[toReplace] = newEntry;
        System.arraycopy(entries, toReplace + 1, newEntries, toReplace + 1, entries.length - toReplace - 2);
        model.rearrangeOrderEntries(newEntries);
    }

    public static <T extends OrderEntry> void processOrderEntries(@NotNull Module module, @NotNull Class<? extends T> orderEntryClass, @NotNull Processor<? super T> processor2) {
        OrderEntry[] orderEntries;
        for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            if (orderEntryClass.isInstance(orderEntry) && !processor2.process(orderEntryClass.cast(orderEntry))) break;
        }
    }

    @NotNull
    public static DependencyScope intersectScopes(@NotNull DependencyScope scope1, @NotNull DependencyScope scope2) {
        if (scope1 == scope2) {
            return scope1;
        }
        if (scope1 == DependencyScope.COMPILE) {
            return scope2;
        }
        if (scope2 == DependencyScope.COMPILE) {
            return scope1;
        }
        if (scope1 == DependencyScope.TEST || scope2 == DependencyScope.TEST) {
            return DependencyScope.TEST;
        }
        return scope1;
    }

    @NotNull
    public static List<Library> getModuleLibraries(@NotNull ModuleRootModel model) {
        OrderEntry[] orderEntries = model.getOrderEntries();
        ArrayList<Library> libraries = new ArrayList<Library>();
        for (OrderEntry orderEntry : orderEntries) {
            LibraryOrderEntry entry;
            if (!(orderEntry instanceof LibraryOrderEntry) || !(entry = (LibraryOrderEntry)orderEntry).isModuleLevel()) continue;
            libraries.add(entry.getLibrary());
        }
        return libraries;
    }

    public static boolean isModuleLibraryOrderEntry(@Nullable OrderEntry orderEntry) {
        return orderEntry instanceof LibraryOrderEntry && ((LibraryOrderEntry)orderEntry).isModuleLevel();
    }
}

