/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.FileIndexBase;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.roots.impl.RootIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@ApiStatus.Internal
public class ModuleFileIndexImpl
extends FileIndexBase
implements ModuleFileIndex {
    @NotNull
    private final Module myModule;

    public ModuleFileIndexImpl(@NotNull Module module) {
        super(DirectoryIndex.getInstance(module.getProject()));
        this.myModule = module;
    }

    public boolean iterateContent(@NotNull ContentIterator processor2, @Nullable VirtualFileFilter filter2) {
        Set<VirtualFile> contentRoots = this.getModuleRootsToIterate();
        for (VirtualFile contentRoot : contentRoots) {
            if (this.iterateContentUnderDirectory(contentRoot, processor2, filter2)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    Set<VirtualFile> getModuleRootsToIterate() {
        return (Set)ReadAction.compute(() -> {
            if (this.myModule.isDisposed()) {
                return Collections.emptySet();
            }
            LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
            List allRoots = Arrays.asList(ModuleRootManager.getInstance((Module)this.myModule).getContentRoots(), ModuleRootManager.getInstance((Module)this.myModule).getSourceRoots());
            Iterator iterator2 = allRoots.iterator();
            while (iterator2.hasNext()) {
                VirtualFile[] roots;
                for (VirtualFile root : roots = (VirtualFile[])iterator2.next()) {
                    DirectoryInfo parentInfo;
                    VirtualFile parent;
                    DirectoryInfo info = this.getInfoForFileOrDirectory(root);
                    if (!info.isInProject(root) || (parent = root.getParent()) != null && this.myModule.equals((parentInfo = this.myDirectoryIndex.getInfoForFile(parent)).getModule())) continue;
                    result2.add(root);
                }
            }
            return result2;
        });
    }

    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        return this.isInContent(fileOrDir, this.getInfoForFileOrDirectory(fileOrDir));
    }

    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInModuleSource(fileOrDir) && this.myModule.equals(info.getModule());
    }

    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile fileOrDir) {
        return ModuleFileIndexImpl.findAllOrderEntriesWithOwnerModule(this.myModule, this.myDirectoryIndex.getOrderEntries(this.getInfoForFileOrDirectory(fileOrDir)));
    }

    public OrderEntry getOrderEntryForFile(@NotNull VirtualFile fileOrDir) {
        return ModuleFileIndexImpl.findOrderEntryWithOwnerModule(this.myModule, this.myDirectoryIndex.getOrderEntries(this.getInfoForFileOrDirectory(fileOrDir)));
    }

    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInModuleSource(fileOrDir) && this.myModule.equals(info.getModule()) && this.isTestSourcesRoot(info);
    }

    public boolean isUnderSourceRootOfType(@NotNull VirtualFile fileOrDir, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInModuleSource(fileOrDir) && this.myModule.equals(info.getModule()) && rootTypes.contains(this.myDirectoryIndex.getSourceRootType(info));
    }

    @Override
    protected boolean isScopeDisposed() {
        return this.myModule.isDisposed();
    }

    @Nullable
    public static OrderEntry findOrderEntryWithOwnerModule(@NotNull Module ownerModule, @NotNull List<? extends OrderEntry> orderEntries) {
        if (orderEntries.size() < 10) {
            for (OrderEntry orderEntry : orderEntries) {
                if (orderEntry.getOwnerModule() != ownerModule) continue;
                return orderEntry;
            }
            return null;
        }
        int index = Collections.binarySearch(orderEntries, new FakeOrderEntry(ownerModule), RootIndex.BY_OWNER_MODULE);
        return index < 0 ? null : orderEntries.get(index);
    }

    @NotNull
    private static List<OrderEntry> findAllOrderEntriesWithOwnerModule(@NotNull Module ownerModule, @NotNull List<? extends OrderEntry> entries) {
        int lastIndex;
        if (entries.isEmpty()) {
            return Collections.emptyList();
        }
        if (entries.size() == 1) {
            OrderEntry entry = entries.get(0);
            return entry.getOwnerModule() == ownerModule ? new ArrayList<OrderEntry>(entries) : Collections.emptyList();
        }
        int index = Collections.binarySearch(entries, new FakeOrderEntry(ownerModule), RootIndex.BY_OWNER_MODULE);
        if (index < 0) {
            return Collections.emptyList();
        }
        int firstIndex = index;
        while (firstIndex - 1 >= 0 && entries.get(firstIndex - 1).getOwnerModule() == ownerModule) {
            --firstIndex;
        }
        for (lastIndex = index + 1; lastIndex < entries.size() && entries.get(lastIndex).getOwnerModule() == ownerModule; ++lastIndex) {
        }
        return new ArrayList<OrderEntry>(entries.subList(firstIndex, lastIndex));
    }

    @Override
    protected boolean isInContent(@NotNull VirtualFile file2, @NotNull DirectoryInfo info) {
        return ProjectFileIndexImpl.isFileInContent(file2, info) && this.myModule.equals(info.getModule());
    }

    private static class FakeOrderEntry
    implements OrderEntry {
        private final Module myOwnerModule;

        FakeOrderEntry(@NotNull Module ownerModule) {
            this.myOwnerModule = ownerModule;
        }

        public VirtualFile @NotNull [] getFiles(@NotNull OrderRootType type) {
            throw new IncorrectOperationException();
        }

        public String @NotNull [] getUrls(@NotNull OrderRootType rootType) {
            throw new IncorrectOperationException();
        }

        @NotNull
        public String getPresentableName() {
            throw new IncorrectOperationException();
        }

        public boolean isValid() {
            throw new IncorrectOperationException();
        }

        @NotNull
        public Module getOwnerModule() {
            return this.myOwnerModule;
        }

        public <R> R accept(@NotNull RootPolicy<R> policy, @Nullable R initialValue) {
            throw new IncorrectOperationException();
        }

        public int compareTo(@NotNull OrderEntry o) {
            throw new IncorrectOperationException();
        }

        public boolean isSynthetic() {
            throw new IncorrectOperationException();
        }
    }
}

