/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.CachedValueWithTTL;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkListParser;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.io.HttpRequests;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tukaani.xz.XZInputStream;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\"\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\f\u001a\u0004\u0018\u00010\rR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkListDownloader;", "", "()V", "feedUrl", "", "getFeedUrl", "()Ljava/lang/String;", "jdksListCache", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/CachedValueWithTTL;", "", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "downloadForUI", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "downloadJdkList", "", "kotlin.jvm.PlatformType", "downloadJdksListNoCache", "downloadJdksListWithCache", "downloadModelForJdkInstaller", "Companion", "intellij.platform.lang.impl"})
public final class JdkListDownloader {
    private final CachedValueWithTTL<List<JdkItem>> jdksListCache = new CachedValueWithTTL((Pair<Integer, ? extends TimeUnit>)TuplesKt.to((Object)15, (Object)((Object)TimeUnit.MINUTES)));
    public static final Companion Companion = new Companion(null);

    private final String getFeedUrl() {
        Object object;
        Object object2 = this;
        boolean bl = false;
        try {
            object = Result.Companion;
            JdkListDownloader $this$runCatching = object2;
            boolean bl2 = false;
            String string = Registry.get((String)"jdk.downloader.url").asString();
            boolean bl3 = false;
            object = Result.constructor-impl((Object)string);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        bl = false;
        String registry = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
        object2 = registry;
        bl = false;
        boolean bl5 = false;
        if (!(object2 == null || StringsKt.isBlank((CharSequence)object2))) {
            return registry;
        }
        return "https://download.jetbrains.com/jdk/feed/v1/jdks.json.xz";
    }

    private final byte[] downloadJdkList(String feedUrl, ProgressIndicator progress2) {
        return HttpRequests.request((String)feedUrl).productNameAsUserAgent().readBytes(progress2);
    }

    @NotNull
    public final List<JdkItem> downloadModelForJdkInstaller(@Nullable ProgressIndicator progress2) {
        return this.downloadJdksListWithCache(this.getFeedUrl(), progress2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JdkItem> downloadForUI(@Nullable ProgressIndicator progress2, @Nullable String feedUrl) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.downloadJdksListWithCache(feedUrl, progress2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JdkItem it = (JdkItem)element$iv$iv;
            boolean bl = false;
            if (!it.isVisibleOnUI()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List downloadForUI$default(JdkListDownloader jdkListDownloader, ProgressIndicator progressIndicator2, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return jdkListDownloader.downloadForUI(progressIndicator2, string);
    }

    private final List<JdkItem> downloadJdksListWithCache(String feedUrl, ProgressIndicator progress2) {
        String string = feedUrl;
        if (string == null) {
            string = this.getFeedUrl();
        }
        String feedUrl2 = string;
        boolean bl = false;
        return this.jdksListCache.getOrCompute(feedUrl2, CollectionsKt.emptyList(), (Function0<List<JdkItem>>)((Function0)new Function0<List<? extends JdkItem>>(this, feedUrl2, progress2){
            final /* synthetic */ JdkListDownloader this$0;
            final /* synthetic */ String $feedUrl;
            final /* synthetic */ ProgressIndicator $progress;

            @NotNull
            public final List<JdkItem> invoke() {
                return JdkListDownloader.access$downloadJdksListNoCache(this.this$0, this.$feedUrl, this.$progress);
            }
            {
                this.this$0 = jdkListDownloader;
                this.$feedUrl = string;
                this.$progress = progressIndicator2;
                super(0);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<JdkItem> downloadJdksListNoCache(String feedUrl, ProgressIndicator progress2) {
        ObjectNode t3;
        Object t22;
        byte[] byArray;
        try {
            byArray = this.downloadJdkList(feedUrl, progress2);
        }
        catch (IOException t22) {
            Logger.getInstance(this.getClass()).warn("Failed to download the list of available JDKs from " + feedUrl + ". " + t22.getMessage());
            return CollectionsKt.emptyList();
        }
        byte[] rawDataXZ = byArray;
        try {
            byte[] byArray2;
            t22 = new ByteArrayInputStream(rawDataXZ);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                byte[] byArray3;
                ByteArrayInputStream input = (ByteArrayInputStream)t22;
                boolean bl3 = false;
                Closeable closeable = (Closeable)new XZInputStream((InputStream)input);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    XZInputStream it = (XZInputStream)closeable;
                    boolean bl6 = false;
                    byArray3 = ByteStreamsKt.readBytes((InputStream)((InputStream)it));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                byArray2 = byArray3;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)t22, (Throwable)throwable);
            }
            t22 = byArray2;
        }
        catch (Throwable t3) {
            throw (Throwable)new RuntimeException("Failed to unpack the list of available JDKs from " + feedUrl + ". " + t3.getMessage(), t3);
        }
        Object rawData = t22;
        try {
            t3 = JdkListParser.INSTANCE.readTree((byte[])rawData);
        }
        catch (Throwable t4) {
            throw (Throwable)new RuntimeException("Failed to parse the downloaded list of available JDKs. " + t4.getMessage(), t4);
        }
        ObjectNode json = t3;
        try {
            return (List)ImmutableList.copyOf((Collection)JdkListParser.INSTANCE.parseJdkList(json, JdkPredicate.Companion.createInstance()));
        }
        catch (Throwable t23) {
            throw (Throwable)new RuntimeException("Failed to process the downloaded list of available JDKs from " + feedUrl + ". " + t23.getMessage(), t23);
        }
    }

    public static final /* synthetic */ List access$downloadJdksListNoCache(JdkListDownloader $this, String feedUrl, ProgressIndicator progress2) {
        return $this.downloadJdksListNoCache(feedUrl, progress2);
    }

    @JvmStatic
    @NotNull
    public static final JdkListDownloader getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkListDownloader$Companion;", "", "()V", "getInstance", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkListDownloader;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final JdkListDownloader getInstance() {
            boolean $i$f$service = false;
            return (JdkListDownloader)ApplicationManager.getApplication().getService(JdkListDownloader.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

