/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbServiceMergingTaskQueue;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public final class DumbServiceSyncTaskQueue {
    private final AtomicBoolean myIsRunning = new AtomicBoolean(false);
    private final DumbServiceMergingTaskQueue myTaskQueue;

    public DumbServiceSyncTaskQueue(@NotNull DumbServiceMergingTaskQueue queue) {
        this.myTaskQueue = queue;
    }

    public void runTaskSynchronously(@NotNull DumbModeTask task2) {
        this.myTaskQueue.addTask(task2);
        if (!this.myIsRunning.compareAndSet(false, true)) {
            return;
        }
        try {
            this.processQueue();
        }
        finally {
            this.myIsRunning.set(false);
        }
    }

    private void processQueue() {
        while (true) {
            DumbServiceMergingTaskQueue.QueuedDumbModeTask nextTask = this.myTaskQueue.extractNextTask();
            Throwable throwable = null;
            try {
                if (nextTask == null) break;
                DumbServiceSyncTaskQueue.doRunTaskSynchronously(nextTask);
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (nextTask == null) continue;
                if (throwable != null) {
                    try {
                        nextTask.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                nextTask.close();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRunTaskSynchronously(@NotNull DumbServiceMergingTaskQueue.QueuedDumbModeTask task2) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator == null) {
            indicator = new EmptyProgressIndicator();
        }
        indicator.pushState();
        ((CoreProgressManager)ProgressManager.getInstance()).suppressPrioritizing();
        try (AccessToken ignored = HeavyProcessLatch.INSTANCE.processStarted("Performing indexing task", HeavyProcessLatch.Type.Indexing);){
            task2.executeTask(indicator);
        }
        finally {
            ((CoreProgressManager)ProgressManager.getInstance()).restorePrioritizing();
            indicator.popState();
        }
    }
}

