/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.AppIconScheme;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.ui.AppIcon;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;

class DumbServiceAppIconProgress
extends ProgressIndicatorBase {
    private final Project myProject;
    private double lastFraction;

    DumbServiceAppIconProgress(@NotNull Project project) {
        this.myProject = project;
    }

    static void registerForProgress(@NotNull Project project, @NotNull ProgressIndicatorEx indicator) {
        indicator.addStateDelegate(new DumbServiceAppIconProgress(project));
    }

    @Override
    public void setFraction(double fraction) {
        if (fraction - this.lastFraction < 0.01) {
            return;
        }
        this.lastFraction = fraction;
        UIUtil.invokeLaterIfNeeded(() -> AppIcon.getInstance().setProgress(this.myProject, "indexUpdate", AppIconScheme.Progress.INDEXING, fraction, true));
    }

    @Override
    public void finish(@NotNull TaskInfo task2) {
        if (this.lastFraction != 0.0) {
            UIUtil.invokeLaterIfNeeded(() -> {
                AppIcon appIcon = AppIcon.getInstance();
                if (appIcon.hideProgress(this.myProject, "indexUpdate")) {
                    if (Registry.is((String)"ide.appIcon.requestAttention.after.indexing", (boolean)false)) {
                        appIcon.requestAttention(this.myProject, false);
                    }
                    appIcon.setOkBadge(this.myProject, true);
                }
            });
        }
    }
}

