/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressWrapper
extends AbstractProgressIndicatorBase
implements WrappedProgressIndicator,
StandardProgressIndicator {
    private final ProgressIndicator myOriginal;
    private final boolean myCheckCanceledForMe;
    private final int nested;

    protected ProgressWrapper(@NotNull ProgressIndicator original) {
        this(original, false);
    }

    protected ProgressWrapper(@NotNull ProgressIndicator original, boolean checkCanceledForMe) {
        if (!(original instanceof StandardProgressIndicator)) {
            throw new IllegalArgumentException("Original indicator " + original + " must be StandardProgressIndicator but got: " + original.getClass());
        }
        this.myOriginal = original;
        this.myCheckCanceledForMe = checkCanceledForMe;
        this.nested = 1 + (original instanceof ProgressWrapper ? ((ProgressWrapper)original).nested : -1);
        ProgressManager.assertNotCircular((ProgressIndicator)original);
        this.dontStartActivity();
    }

    @Override
    public final void cancel() {
        super.cancel();
    }

    @Override
    public final boolean isCanceled() {
        ProgressIndicator original;
        ProgressWrapper current2 = this;
        while (true) {
            if (current2.myCheckCanceledForMe && current2.isCanceledRaw()) {
                return true;
            }
            original = current2.getOriginalProgressIndicator();
            if (!(original instanceof ProgressWrapper)) break;
            current2 = (ProgressWrapper)original;
        }
        return original.isCanceled();
    }

    @Override
    @Nullable
    protected Throwable getCancellationTrace() {
        if (this.myOriginal instanceof AbstractProgressIndicatorBase) {
            return ((AbstractProgressIndicatorBase)this.myOriginal).getCancellationTrace();
        }
        return super.getCancellationTrace();
    }

    private boolean isCanceledRaw() {
        return super.isCanceled();
    }

    private void checkCanceledRaw() {
        super.checkCanceled();
    }

    @Override
    public final void checkCanceled() {
        ProgressIndicator original;
        ProgressWrapper current2 = this;
        while (true) {
            if (current2.isCanceledRaw()) {
                current2.checkCanceledRaw();
            }
            if (!((original = current2.getOriginalProgressIndicator()) instanceof ProgressWrapper)) break;
            current2 = (ProgressWrapper)original;
        }
        original.checkCanceled();
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.myOriginal.setText(text);
    }

    @Override
    public void setText2(String text) {
        super.setText2(text);
        this.myOriginal.setText2(text);
    }

    @Override
    public void setFraction(double fraction) {
        super.setFraction(fraction);
        this.myOriginal.setFraction(fraction);
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        this.myOriginal.setIndeterminate(indeterminate);
    }

    @Override
    public boolean isIndeterminate() {
        return this.myOriginal.isIndeterminate();
    }

    @Override
    @NotNull
    public ModalityState getModalityState() {
        return this.myOriginal.getModalityState();
    }

    @NotNull
    public ProgressIndicator getOriginalProgressIndicator() {
        return this.myOriginal;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static ProgressWrapper wrap(@Nullable ProgressIndicator indicator) {
        return indicator == null ? null : new ProgressWrapper(indicator);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static ProgressIndicator unwrap(ProgressIndicator indicator) {
        return indicator instanceof ProgressWrapper ? ((ProgressWrapper)indicator).getOriginalProgressIndicator() : indicator;
    }

    @NotNull
    public static ProgressIndicator unwrapAll(@NotNull ProgressIndicator indicator) {
        while (indicator instanceof ProgressWrapper) {
            indicator = ((ProgressWrapper)indicator).getOriginalProgressIndicator();
        }
        return indicator;
    }
}

