/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public abstract class AtomicCancelableLazyValue<T> {
    private static final int TIMEOUT = 50;
    private volatile T myValue;
    private final ReentrantLock myLock = new ReentrantLock();

    @NotNull
    public final T getValue() {
        T curValue = this.myValue;
        if (curValue != null) {
            return curValue;
        }
        return ProgressIndicatorUtils.computeWithLockAndCheckingCanceled(this.myLock, 50, TimeUnit.MILLISECONDS, () -> {
            T value2 = this.myValue;
            if (value2 == null) {
                RecursionGuard.StackStamp stamp = RecursionManager.markStack();
                value2 = this.compute();
                if (stamp.mayCacheNow()) {
                    this.myValue = value2;
                }
            }
            return value2;
        });
    }

    @NotNull
    protected abstract T compute();

    public boolean isComputed() {
        return this.myValue != null;
    }

    @NotNull
    public static <T> AtomicCancelableLazyValue<T> createValue(final @NotNull NotNullFactory<? extends T> value2) {
        return new AtomicCancelableLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                return value2.create();
            }
        };
    }
}

